/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.IFilter;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.ui.ConnectionEditUtils;
import org.eclipse.stardust.modeling.repository.common.ui.ConnectionQueryUtils;
import org.eclipse.stardust.modeling.repository.common.ui.ObjectDescriptorLabelProvider;
import org.eclipse.stardust.modeling.repository.common.ui.ObjectDescriptorListContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ElementSelectionAction
extends SelectionAction {
    private ObjectDescriptorLabelProvider labelProvider;
    private ObjectDescriptorListContentProvider contentProvider;

    public ElementSelectionAction(IWorkbenchPart part) {
        super(part);
        this.setId("org.eclipse.stardust.modeling.repository.common.select");
        this.setText(Diagram_Messages.TXT_SEL_MD_ELEMENTS);
        this.labelProvider = new ObjectDescriptorLabelProvider();
        this.contentProvider = new ObjectDescriptorListContentProvider();
    }

    public void run() {
        WorkflowModelEditor editor = (WorkflowModelEditor)this.getWorkbenchPart();
        ModelType model = editor.getWorkflowModel();
        Connection connection = this.getConnection();
        ConnectionManager manager = (ConnectionManager)this.getWorkbenchPart().getAdapter(ConnectionManager.class);
        try {
            manager.open(connection);
            List content = ConnectionQueryUtils.select((Connection)connection, (ConnectionManager)manager, (IFilter[])new IFilter[0]);
            List<IObjectDescriptor> result = this.select(this.getWorkbenchPart().getSite().getShell(), connection, content);
            Command cmd = ConnectionEditUtils.linkObject((ModelType)model, (IObjectDescriptor[])result.toArray(new IObjectDescriptor[0]), (ConnectionManager)manager);
            this.execute(cmd);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public List<IObjectDescriptor> select(Shell parent, Connection connection, List<IObjectDescriptor> input) throws CoreException {
        this.contentProvider.reset(input);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent, (ILabelProvider)this.labelProvider, (ITreeContentProvider)this.contentProvider);
        dialog.setTitle(Diagram_Messages.DIA_TITLE_ELEMENT_SELE);
        dialog.setMessage(connection.getName());
        dialog.setInput(input);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                String description = null;
                int i = 0;
                while (i < selection.length) {
                    if (!(selection[i] instanceof IObjectDescriptor)) {
                        return Status.CANCEL_STATUS;
                    }
                    ++i;
                }
                if (selection.length == 1) {
                    description = ((IObjectDescriptor)selection[0]).getDescription();
                }
                return new Status(0, "org.eclipse.stardust.modeling.repository.common", 0, description == null ? "" : description, null);
            }
        });
        if (dialog.open() == 0) {
            Object[] entries = dialog.getResult();
            List dialogResult = CollectionUtils.newList();
            int i = 0;
            while (i < entries.length) {
                if (entries[i] instanceof IObjectDescriptor) {
                    dialogResult.add((IObjectDescriptor)entries[i]);
                }
                ++i;
            }
            if (dialogResult.size() > 0) {
                return dialogResult;
            }
        }
        return Collections.emptyList();
    }

    protected boolean calculateEnabled() {
        return this.getConnection() != null;
    }

    private Connection getConnection() {
        Object item;
        Object selection;
        List objects = this.getSelectedObjects();
        if (objects.size() == 1 && (selection = objects.get(0)) instanceof IAdaptable && (item = ((IAdaptable)selection).getAdapter(EObject.class)) instanceof Connection) {
            return (Connection)item;
        }
        return null;
    }
}

