/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.GenericLinkConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LinkTypeType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.PublicInterfaceSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AnnotationSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramRootEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.ExecutedByConnectionEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.GenericLinkConnectionEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PartOfConnectionEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PerformsConnectionEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PoolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.RefersToConnectionEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.SubProcessOfConnectionEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.SymbolGroupEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.TeamLeadConnectionEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.TextSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.TriggersConnectionEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.WorksForConnectionEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ChildCategoryNode;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPropertyPageContributor;
import org.eclipse.stardust.modeling.core.editors.ui.ModelElementPropertyDialog;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ShowPropertiesAction
extends PropertyDialogAction {
    private WorkflowModelEditor editor;

    public ShowPropertiesAction(WorkflowModelEditor editor, ISelectionProvider selectionProvider) {
        super((IShellProvider)editor.getSite(), selectionProvider);
        this.editor = editor;
    }

    public boolean isEnabled() {
        return !(this.getStructuredSelection().getFirstElement() instanceof ChildCategoryNode) && this.isApplicableForSelection(this.getStructuredSelection());
    }

    public boolean isApplicableForSelection(IStructuredSelection selection) {
        PoolSymbol symbol;
        if (selection.size() != 1) {
            return false;
        }
        Object object = this.getStructuredSelection().getFirstElement();
        if (object instanceof PoolEditPart && DiagramUtil.isDefaultPool((ISwimlaneSymbol)(symbol = ((PoolEditPart)object).getPoolModel()))) {
            return false;
        }
        if (!(object instanceof IAdaptable)) {
            return false;
        }
        EObject element = (EObject)((IAdaptable)object).getAdapter(IModelElement.class);
        if (element == null) {
            element = (EObject)((IAdaptable)object).getAdapter(EObject.class);
        }
        if (element == null) {
            return false;
        }
        if (CarnotPropertyPageContributor.instance().isApplicableTo((IAdaptable)object)) {
            PreferenceManager pageManager = new PreferenceManager('.');
            IAdaptable adaptable = (IAdaptable)this.getStructuredSelection().getFirstElement();
            return this.getPages(pageManager, adaptable).hasNext();
        }
        return false;
    }

    private Iterator<?> getPages(PreferenceManager pageManager, IAdaptable adaptable) {
        GenericLinkConnectionType model;
        LinkTypeType link;
        EditPart linkEP;
        if (adaptable instanceof GenericLinkConnectionEditPart && (linkEP = this.editor.findEditPart(link = (model = (GenericLinkConnectionType)((GenericLinkConnectionEditPart)adaptable).getModel()).getLinkType())) != null) {
            adaptable = linkEP;
        }
        CarnotPropertyPageContributor.instance().contributePropertyPages(pageManager, adaptable);
        return pageManager.getElements(0).iterator();
    }

    public String getText() {
        return Diagram_Messages.LBL_Properties;
    }

    public PreferenceDialog createDialog() {
        return this.createDialog(null);
    }

    public PreferenceDialog createDialog(ChangeRecorder recorder) {
        if (!this.isApplicableForSelection(this.getStructuredSelection())) {
            return null;
        }
        IAdaptable element = (IAdaptable)this.getStructuredSelection().getFirstElement();
        PreferenceManager pageManager = new PreferenceManager('.');
        Shell shell = this.editor.getSite().getShell();
        String name = ShowPropertiesAction.getName(element);
        Iterator<?> pages = this.getPages(pageManager, element);
        if (!pages.hasNext()) {
            String informationMessage = NLS.bind((String)Diagram_Messages.BIND_NoPropertyPages, (Object)name);
            if (element instanceof PartOfConnectionEditPart) {
                informationMessage = Diagram_Messages.BIND_NoPropertyPagesConnectionPartOf;
            } else if (element instanceof PerformsConnectionEditPart) {
                informationMessage = Diagram_Messages.BIND_NoPropertyPagesConnectionPerformedBy;
            } else if (element instanceof SubProcessOfConnectionEditPart) {
                informationMessage = Diagram_Messages.BIND_NoPropertyPagesSubprocessOf;
            } else if (element instanceof GenericLinkConnectionEditPart) {
                informationMessage = Diagram_Messages.BIND_NoPropertyPagesGenericLink;
            } else if (element instanceof ExecutedByConnectionEditPart) {
                informationMessage = Diagram_Messages.BIND_NoPropertyPagesExecutedBy;
            } else if (element instanceof WorksForConnectionEditPart) {
                informationMessage = Diagram_Messages.BIND_NoPropertyPagesWorksFor;
            } else if (element instanceof TeamLeadConnectionEditPart) {
                informationMessage = Diagram_Messages.BIND_NoPropertyPagesTeamLead;
            } else if (element instanceof TriggersConnectionEditPart) {
                informationMessage = Diagram_Messages.BIND_NoPropertyPagesTriggersConnection;
            } else if (element instanceof RefersToConnectionEditPart) {
                informationMessage = Diagram_Messages.BIND_NoPropertyPagesRefersToConnection;
            } else if (element instanceof AnnotationSymbolEditPart) {
                informationMessage = Diagram_Messages.BIND_NoPropertyPagesAnnotationSymbol;
            } else if (element instanceof TextSymbolEditPart) {
                informationMessage = Diagram_Messages.BIND_NoPropertyPagesTextSymbol;
            } else if (element instanceof SymbolGroupEditPart) {
                informationMessage = Diagram_Messages.BIND_NoPropertyPagesSymbolGroup;
            }
            MessageDialog.openInformation((Shell)shell, (String)Diagram_Messages.MSG_PropertyPages, (String)informationMessage);
            return null;
        }
        ModelElementPropertyDialog preferenceDialog = new ModelElementPropertyDialog(this.editor, shell, pageManager, element, recorder);
        preferenceDialog.create();
        preferenceDialog.getShell().setText(NLS.bind((String)Diagram_Messages.BIND_Properties, (Object)name));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)preferenceDialog.getShell(), "org.eclipse.ui.property_dialog_context");
        return preferenceDialog;
    }

    private static String getName(IAdaptable element) {
        IWorkbenchAdapter adapter;
        if (element instanceof EditPart) {
            Object model;
            if (element instanceof DiagramRootEditPart) {
                element = (DiagramEditPart)((DiagramRootEditPart)((Object)element)).getChildren().get(0);
            }
            if ((model = ((EditPart)element).getModel()) instanceof PublicInterfaceSymbol) {
                return Diagram_Messages.PageTitle_ProcessInterface;
            }
            if (model instanceof IModelElementNodeSymbol) {
                model = ((IModelElementNodeSymbol)model).getModelElement();
            }
            if (model instanceof IIdentifiableElement) {
                return ((IIdentifiableElement)model).getName();
            }
            if (model instanceof TransitionConnectionType) {
                return ((TransitionConnectionType)model).getTransition().getName();
            }
            if (model instanceof GatewaySymbol) {
                GatewaySymbol gateway = (GatewaySymbol)model;
                ActivitySymbolType symbol = gateway.getActivitySymbol();
                if (symbol == null) {
                    return "";
                }
                ActivityType activity = (ActivityType)symbol.getModelElement();
                return String.valueOf(gateway.getFlowKind().getValue() == 1 ? " Join" : "Split") + " Gateway (" + activity.getName() + ")";
            }
            if (model instanceof DiagramType) {
                return String.valueOf(((DiagramType)model).getName()) + " (" + ((IIdentifiableElement)((DiagramType)model).eContainer()).getName() + ")";
            }
            if (model instanceof TypeDeclarationType) {
                return ((TypeDeclarationType)model).getName();
            }
            if (model instanceof DataMappingConnectionType) {
                return Diagram_Messages.BIND_PropertyPagesDataMappingConnection;
            }
            if (model instanceof IObjectDescriptor) {
                return ((IObjectDescriptor)model).getLabel();
            }
            if (model instanceof Connection) {
                return ((Connection)model).getName();
            }
            if (model instanceof ExternalPackage) {
                return ((ExternalPackage)model).getName();
            }
        }
        if ((adapter = (IWorkbenchAdapter)element.getAdapter(IWorkbenchAdapter.class)) != null) {
            return adapter.getLabel(element);
        }
        return "";
    }
}

