/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.properties;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.util.IConnection;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributesType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class ExternalPackagePropertyPage
extends AbstractModelElementPropertyPage {
    protected LabeledText txtId;
    protected LabeledText txtName;
    private ComboViewer fileConnectionCombo;
    private LabeledText modelIDText;
    private ExternalPackage externalPackage;
    private Connection selectedConnection;

    @Override
    public boolean performOk() {
        return true;
    }

    public String getTitle() {
        return Diagram_Messages.TXT_EXTERNAL_MD_REFERENCES_PROPERTY_PAGE;
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LBL_FILE_CONNECTION);
        this.fileConnectionCombo = new ComboViewer(FormBuilder.createCombo((Composite)composite));
        this.fileConnectionCombo.setLabelProvider((IBaseLabelProvider)new ConnectionLabelProvider());
        this.modelIDText = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LBL_MD_ID);
        ModelType modelType = (ModelType)this.getEditor().getModel();
        this.externalPackage = (ExternalPackage)((EditPart)this.getElement()).getModel();
        final ConnectionManager cm = (ConnectionManager)modelType.getConnectionManager();
        ModelType referencedModel = cm.find(this.externalPackage);
        if (this.getElement() instanceof EditPart) {
            ExtendedAttributeType attribute = ExtendedAttributeUtil.getAttribute((ExtendedAttributesType)this.externalPackage.getExtendedAttributes(), (String)"carnot:connection:uri");
            String connectionURI = attribute.getValue();
            IConnection packageConnection = cm.findConnection(connectionURI);
            this.selectedConnection = null;
            Iterator i = cm.getConnections();
            while (i.hasNext()) {
                Connection connection = (Connection)i.next();
                this.fileConnectionCombo.add((Object)connection);
                if (!packageConnection.getId().equalsIgnoreCase(connection.getId())) continue;
                this.selectedConnection = connection;
            }
            StructuredSelection selection = new StructuredSelection((Object)this.selectedConnection);
            this.fileConnectionCombo.setSelection((ISelection)selection);
            this.modelIDText.getText().setText(referencedModel.getId());
            this.modelIDText.getText().setEnabled(false);
            this.fileConnectionCombo.addSelectionChangedListener(new ISelectionChangedListener(){
                private boolean ignoreEvent;

                public void selectionChanged(SelectionChangedEvent event) {
                    if (!this.ignoreEvent) {
                        MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 296);
                        messageBox.setText(Diagram_Messages.TXT_WR);
                        messageBox.setMessage(Diagram_Messages.MSG_THIS_OPERATION_MAY_RESULT_IN_DANGLING_REFE);
                        if (messageBox.open() == 32) {
                            if (event.getSelection() instanceof IStructuredSelection) {
                                IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
                                Connection connection = (Connection)structuredSelection.getFirstElement();
                                String newURI = "cnx://" + connection.getId() + "/";
                                ExtendedAttributeType attribute = ExtendedAttributeUtil.getAttribute((ExtendedAttributesType)ExternalPackagePropertyPage.this.externalPackage.getExtendedAttributes(), (String)"carnot:connection:uri");
                                String oldURI = attribute.getValue();
                                ExtendedAttributeUtil.setAttribute((ExtendedAttributesType)ExternalPackagePropertyPage.this.externalPackage.getExtendedAttributes(), (String)"carnot:connection:uri", (String)newURI);
                                EObject o = cm.find(newURI);
                                ModelType referencedModel = (ModelType)Reflect.getFieldValue((Object)o, (String)"eObject");
                                ExternalPackagePropertyPage.this.externalPackage.setHref(referencedModel.getId());
                                ModelType modelType = (ModelType)ExternalPackagePropertyPage.this.getEditor().getModel();
                                ExternalPackagePropertyPage.this.substituteURI((EObject)modelType, oldURI, newURI);
                                ExternalPackagePropertyPage.this.modelIDText.getText().setText(ExternalPackagePropertyPage.this.externalPackage.getHref());
                            }
                        } else {
                            this.ignoreEvent = true;
                            StructuredSelection selection = new StructuredSelection((Object)ExternalPackagePropertyPage.this.selectedConnection);
                            ExternalPackagePropertyPage.this.fileConnectionCombo.setSelection((ISelection)selection);
                            this.ignoreEvent = false;
                        }
                    }
                }
            });
        }
        return composite;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    private void substituteURI(EObject modelElement, String oldURI, String newURI) {
        if (modelElement.eContainer() != null) {
            String value;
            AttributeType attribute;
            if (modelElement instanceof AttributeType && (attribute = (AttributeType)modelElement).getValue().startsWith(oldURI)) {
                value = attribute.getValue();
                value = value.substring(oldURI.length());
                attribute.setValue(String.valueOf(newURI) + value);
            }
            if (modelElement instanceof ExtendedAttributeType && (attribute = (ExtendedAttributeType)modelElement).getValue().startsWith(oldURI)) {
                value = attribute.getValue();
                value = value.substring(oldURI.length());
                attribute.setValue(String.valueOf(newURI) + value);
            }
        }
        Iterator i = modelElement.eContents().iterator();
        while (i.hasNext()) {
            this.substituteURI((EObject)i.next(), oldURI, newURI);
        }
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    public boolean isValid() {
        return super.isValid();
    }

    class ConnectionLabelProvider
    extends LabelProvider {
        ConnectionLabelProvider() {
        }

        public String getText(Object element) {
            Connection c = (Connection)element;
            return c.getName();
        }
    }
}

