/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.IPropertyPage;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.createUtils.CreationUtils;
import org.eclipse.stardust.modeling.core.editors.IValidationEventListener;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPropertyPageContributor;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.ModelElementPropertyDialog;
import org.eclipse.stardust.modeling.core.editors.ui.validation.PageValidationManager;
import org.eclipse.stardust.modeling.core.properties.ModelElementsOutlineSynchronizer;
import org.eclipse.stardust.modeling.core.spi.IModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.utils.CompositeUtils;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.stardust.modeling.repository.common.descriptors.EObjectDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractModelElementPropertyPage
extends PropertyPage
implements IAdaptable,
IPropertyPage,
IModelElementPropertyPage {
    protected static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    public static final boolean preselect = true;
    private final WidgetBindingManager wBndMgr = new WidgetBindingManager((IPreferencePage)this);
    private Composite buttonBar;
    private Composite pageContent;
    protected boolean enablePage = true;
    private List<ModelElementsOutlineSynchronizer> elements = new ArrayList<ModelElementsOutlineSynchronizer>();

    public List<ModelElementsOutlineSynchronizer> getModelElementsOutlineElements() {
        return this.elements;
    }

    protected void updateApplyButton() {
        Button defaultsButton;
        Button applyButton = this.getApplyButton();
        if (applyButton != null) {
            applyButton.setEnabled(this.enablePage && this.isValid());
        }
        if ((defaultsButton = this.getDefaultsButton()) != null) {
            defaultsButton.setEnabled(this.enablePage && this.isValid());
        }
    }

    public void addModelElementsOutlineSynchronizer(ModelElementsOutlineSynchronizer element) {
        this.elements.add(element);
    }

    public void setEnablePage(boolean enablePage) {
        Button defaultsButton;
        this.enablePage = enablePage;
        CompositeUtils.enableContentComposite(this.pageContent, enablePage);
        this.enableContentOutline();
        this.enableContentButtons();
        Button applyButton = this.getApplyButton();
        if (applyButton != null) {
            applyButton.setEnabled(enablePage);
        }
        if ((defaultsButton = this.getDefaultsButton()) != null) {
            defaultsButton.setEnabled(enablePage);
        }
    }

    public WidgetBindingManager getWidgetBindingManager() {
        return this.wBndMgr;
    }

    @Override
    public void dispose() {
        this.wBndMgr.dispose();
        super.dispose();
        if (this.getControl() != null) {
            this.getControl().dispose();
        }
    }

    public boolean performOk() {
        CreationUtils.refreshTreeItem(this.getModelElement());
        this.apply();
        return true;
    }

    protected EObject getModelElement() {
        IModelElement modelElement = this.getModelElementFromSymbol(this.getModelElementNodeSymbol());
        if (modelElement == null) {
            return this.getModelElement(this.getElement());
        }
        return modelElement;
    }

    protected EObject getModelElement(IAdaptable adaptable) {
        EditPart editPart = (EditPart)adaptable.getAdapter(EditPart.class);
        Object model = editPart.getModel();
        if (model instanceof IModelElementNodeSymbol) {
            IModelElementNodeSymbol nd = (IModelElementNodeSymbol)model;
            return nd.getModelElement();
        }
        if (model instanceof Proxy) {
            Proxy proxy = (Proxy)model;
            InvocationHandler ih = Proxy.getInvocationHandler(proxy);
            Object value = Reflect.getFieldValue((Object)ih, (String)"val$desc");
            if (value == null || !(value instanceof EObjectDescriptor)) {
                return null;
            }
            EObjectDescriptor ed = (EObjectDescriptor)value;
            return ed.getEObject();
        }
        if (model instanceof EObject) {
            return (EObject)model;
        }
        return null;
    }

    protected IModelElement getModelElementFromSymbol(IModelElementNodeSymbol symbol) {
        return (IModelElement)(symbol == null ? this.getElement().getAdapter(IModelElement.class) : symbol.getModelElement());
    }

    protected IModelElementNodeSymbol getModelElementNodeSymbol() {
        IModelElementNodeSymbol symbol = (IModelElementNodeSymbol)this.getElement().getAdapter(IModelElementNodeSymbol.class);
        return symbol;
    }

    protected void performDefaults() {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ((ModelElementPropertyDialog)container).performDefaults();
        } else {
            super.performDefaults();
        }
    }

    protected void performApply() {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ((ModelElementPropertyDialog)container).performApply();
        } else {
            super.performApply();
        }
    }

    public void apply() {
        IModelElementNodeSymbol symbol = this.getModelElementNodeSymbol();
        IModelElement modelElement = this.getModelElementFromSymbol(symbol);
        this.loadElementFromFields(symbol, modelElement);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        new UIJob(Diagram_Messages.LB_PageUpdate){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!AbstractModelElementPropertyPage.this.getControl().isDisposed()) {
                    try {
                        AbstractModelElementPropertyPage.this.elementChanged();
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected Control createContents(Composite parent) {
        this.pageContent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.pageContent.setLayout((Layout)layout);
        Control pageBody = this.createBody(this.pageContent);
        if (pageBody != null) {
            pageBody.setLayoutData((Object)new GridData(1808));
        }
        this.buttonBar = new Composite(this.pageContent, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.buttonBar.setLayout((Layout)layout);
        GridData gd = new GridData(2);
        this.buttonBar.setLayoutData((Object)gd);
        this.contributeVerticalButtons(this.buttonBar);
        if (this.buttonBar.getChildren().length < 1) {
            this.buttonBar.dispose();
        } else {
            this.buttonBar.setEnabled(this.enablePage);
        }
        this.pageContent.pack();
        return this.pageContent;
    }

    private void enableContentButtons() {
        if (this.buttonBar != null && !this.buttonBar.isDisposed()) {
            this.buttonBar.setEnabled(this.enablePage);
            this.buttonBar.setCapture(this.enablePage);
        }
    }

    private void enableContentOutline() {
        for (ModelElementsOutlineSynchronizer element : this.elements) {
            List<IPreferenceNode> nodes = element.getNodes();
            for (IPreferenceNode node : nodes) {
                IWorkbenchPropertyPage page;
                if (!(node instanceof CarnotPreferenceNode) || (page = (IWorkbenchPropertyPage)node.getPage()) == null) continue;
                if (page instanceof AbstractModelElementPropertyPage) {
                    ((AbstractModelElementPropertyPage)page).setEnablePage(this.enablePage);
                    continue;
                }
                if (!(page instanceof PropertyPage)) continue;
                CompositeUtils.enableComposite(this.pageContent, this.enablePage);
            }
        }
    }

    @Override
    public void contributeButtons(Composite parent) {
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
    }

    public void elementChanged() {
        IModelElementNodeSymbol symbol = (IModelElementNodeSymbol)this.getElement().getAdapter(IModelElementNodeSymbol.class);
        IModelElement modelElement = (IModelElement)(symbol == null ? this.getElement().getAdapter(IModelElement.class) : symbol.getModelElement());
        if (modelElement == null) {
            modelElement = (IModelElement)this.getModelElement();
        }
        if (modelElement != null || symbol != null && symbol.getModelElement() == null) {
            this.loadFieldsFromElement(symbol, modelElement);
            this.enableContentOutline();
        }
        super.performDefaults();
    }

    protected void removePreferenceNodes(String parentNodeId) {
        this.removePreferenceNodes(parentNodeId, false);
    }

    public void removePreferenceNodes(String parentNodeId, boolean removeParent) {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)container;
            dialog.removePreferenceNodes(parentNodeId, removeParent);
        }
    }

    protected void removePreferenceNode(CarnotPreferenceNode parentNode, CarnotPreferenceNode node) {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)container;
            dialog.removePreferenceNode((IPreferenceNode)parentNode, (IPreferenceNode)node);
        }
    }

    public CarnotPreferenceNode addNodeTo(String pageId, CarnotPreferenceNode node, EObjectLabelProvider labelProvider) {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)container;
            dialog.addNodeTo(pageId, node, labelProvider);
            return node;
        }
        return null;
    }

    protected WorkflowModelEditor getEditor() {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)container;
            return dialog.getEditor();
        }
        return null;
    }

    protected void registerValidation(IAdaptable adaptable) {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)container;
            dialog.registerValidation(adaptable);
        }
    }

    public void refreshTree() {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)container;
            dialog.refreshTree();
        }
    }

    protected void expandTree() {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)container;
            dialog.expandTree();
        }
    }

    protected void addNodesTo(String category) {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)container;
            CarnotPropertyPageContributor.instance().contributePropertyPages(dialog.getPreferenceManager(), this.getElement(), category);
        }
    }

    protected void addSpiNodes(ITypedElement element) {
        IMetaType type = element.getMetaType();
        if (type != null) {
            this.addSpiNodes(type.getExtensionPointId(), type.getId());
        }
    }

    protected void addSpiNodes(String extensionId, String type) {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)container;
            CarnotPropertyPageContributor.instance().contributeSpiPropertyPages(dialog, extensionId, type, this.getElement());
        }
    }

    protected void selectPage(String path) {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)container;
            dialog.selectPage(path);
        }
    }

    protected void selectPageForObject(Object selection) {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)container;
            dialog.selectPageForObject(selection);
        }
    }

    public PreferenceManager getPreferenceManager() {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)container;
            return dialog.getPreferenceManager();
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        PageValidationManager result = null;
        if (IValidationEventListener.class.equals((Object)adapter)) {
            result = this.getWidgetBindingManager().getValidationBindingManager();
        } else if (PageValidationManager.class.equals((Object)adapter)) {
            result = this.getWidgetBindingManager().getValidationBindingManager();
        }
        return result;
    }

    public IPreferencePage getPage(String pageId) {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            return ((ModelElementPropertyDialog)container).getPage(pageId);
        }
        return null;
    }

    public IPreferenceNode getNode(String pageId) {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            return ((ModelElementPropertyDialog)container).getNode(pageId);
        }
        return null;
    }

    public String composePageId(String parentId, String id) {
        return ModelElementPropertyDialog.composePageId(parentId, id);
    }

    public void addDependentCommand(Command command) {
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof ModelElementPropertyDialog) {
            ((ModelElementPropertyDialog)container).addDependentCommand(command);
        }
    }

    @Override
    public void setDelegateContainer(AbstractModelElementPropertyPage page) {
    }
}

