/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.ui.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ApplicationRetrySynchronousPropertyPage
extends AbstractModelElementPropertyPage {
    protected LabeledText number;
    protected LabeledText time;
    protected Button retryButton;
    private SelectionListener retryListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
        }
    };
    private ModifyListener numberListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            boolean isValid = ApplicationRetrySynchronousPropertyPage.this.validateNumber();
            if (!isValid) {
                ApplicationRetrySynchronousPropertyPage.this.setErrorMessage(Diagram_Messages.ERROR_MSG_VALUE_MUST_BE_NUMERIC_BETWEEN_1_AND_10);
                ApplicationRetrySynchronousPropertyPage.this.setValid(false);
            } else if (ApplicationRetrySynchronousPropertyPage.this.validate()) {
                ApplicationRetrySynchronousPropertyPage.this.setValid(true);
                ApplicationRetrySynchronousPropertyPage.this.setErrorMessage(null);
            }
        }
    };
    private ModifyListener timeListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            boolean isValid = ApplicationRetrySynchronousPropertyPage.this.validateTime();
            if (!isValid) {
                ApplicationRetrySynchronousPropertyPage.this.setErrorMessage(Diagram_Messages.ERROR_MSG_VALUE_MUST_BE_NUMERIC_BETWEEN_1_AND_60);
                ApplicationRetrySynchronousPropertyPage.this.setValid(false);
            } else if (ApplicationRetrySynchronousPropertyPage.this.validate()) {
                ApplicationRetrySynchronousPropertyPage.this.setValid(true);
                ApplicationRetrySynchronousPropertyPage.this.setErrorMessage(null);
            }
        }
    };

    private boolean validate() {
        return this.validateNumber() && this.validateTime();
    }

    private boolean validateNumber() {
        String numberValue = this.number.getText().getText();
        if (StringUtils.isEmpty(numberValue)) {
            return true;
        }
        try {
            int value = Integer.parseInt(numberValue);
            if (value >= 1 && value <= 10) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return false;
    }

    private boolean validateTime() {
        String timeValue = this.time.getText().getText();
        if (StringUtils.isEmpty(timeValue)) {
            return true;
        }
        try {
            int value = Integer.parseInt(timeValue);
            if (value >= 1 && value <= 60) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return false;
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        AttributeType retryAttribute;
        AttributeType timeAttribute;
        this.number.getText().removeModifyListener(this.numberListener);
        this.time.getText().removeModifyListener(this.timeListener);
        this.retryButton.removeSelectionListener(this.retryListener);
        AttributeType numberAttribute = AttributeUtil.getAttribute((IExtensibleElement)((ApplicationType)element), (String)"synchronous:retry:number");
        if (numberAttribute != null) {
            this.number.getText().setText(numberAttribute.getValue());
        }
        if ((timeAttribute = AttributeUtil.getAttribute((IExtensibleElement)((ApplicationType)element), (String)"synchronous:retry:time")) != null) {
            this.time.getText().setText(timeAttribute.getValue());
        }
        if ((retryAttribute = AttributeUtil.getAttribute((IExtensibleElement)((ApplicationType)element), (String)"synchronous:retry:enable")) != null) {
            this.retryButton.setSelection(AttributeUtil.getBooleanValue((AttributeType)retryAttribute));
        }
        this.number.getText().addModifyListener(this.numberListener);
        this.time.getText().addModifyListener(this.timeListener);
        this.retryButton.addSelectionListener(this.retryListener);
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        if (this.validate()) {
            AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"synchronous:retry:number", (String)this.number.getText().getText());
            AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"synchronous:retry:time", (String)this.time.getText().getText());
            AttributeUtil.setBooleanAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"synchronous:retry:enable", (Boolean)this.retryButton.getSelection());
        }
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createLabeledControlsComposite((Composite)parent);
        this.retryButton = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.LB_APPLICATION_RETRY_ENABLE, (int)2);
        this.number = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_APPLICATION_RETRY_NUMBER);
        this.number.setTextLimit(2);
        this.time = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_APPLICATION_RETRY_TIME);
        this.time.setTextLimit(2);
        return composite;
    }
}

