/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IdRef;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.ProcessDefinitionImplemetationLabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ProcessDefinitionImplementationPropertyPage
extends AbstractModelElementPropertyPage {
    private boolean isImplementing = false;
    private ProcessDefinitionType process = null;
    private Button implementsButton;
    private Table implementsTable;
    private TableViewer viewer;
    private List<ProcessDefinitionType> processes;

    @Override
    protected void performDefaults() {
        super.performDefaults();
    }

    @Override
    protected void performApply() {
        super.performApply();
        if (!this.isImplementing) {
            this.process.setExternalRef(null);
        }
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.process = (ProcessDefinitionType)element;
        this.initializeImplementsPanel();
    }

    private void initializeImplementsPanel() {
        ProcessDefinitionType selectedProcess;
        IdRef externalReference = this.process.getExternalRef();
        this.implementsButton.setSelection(externalReference != null);
        this.implementsTable.setEnabled(externalReference != null);
        boolean bl = this.isImplementing = externalReference != null;
        if (externalReference != null && (selectedProcess = this.findProcess(externalReference)) != null) {
            this.viewer.getTable().select(this.processes.indexOf(selectedProcess));
        }
    }

    private ProcessDefinitionType findProcess(IdRef externalReference) {
        for (ProcessDefinitionType proc : this.processes) {
            ModelType refModel = (ModelType)proc.eContainer();
            String pid = externalReference.getRef();
            String mid = externalReference.getPackageRef().getId();
            if (!refModel.getId().equalsIgnoreCase(mid) || !proc.getId().equalsIgnoreCase(pid)) continue;
            return proc;
        }
        return null;
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.implementsButton = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.BOX_PROCESS_IMPLEMENTS, (int)2);
        this.implementsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ProcessDefinitionImplementationPropertyPage.this.isImplementing = !ProcessDefinitionImplementationPropertyPage.this.isImplementing;
                ProcessDefinitionImplementationPropertyPage.this.implementsTable.setEnabled(ProcessDefinitionImplementationPropertyPage.this.isImplementing);
                ProcessDefinitionImplementationPropertyPage.this.process.setExternalRef(null);
            }
        });
        this.implementsTable = new Table(composite, 67584);
        this.implementsTable.setHeaderVisible(true);
        this.implementsTable.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)this.implementsTable);
        this.viewer = new TableViewer(this.implementsTable);
        TableUtil.createColumns(this.implementsTable, new String[]{Diagram_Messages.COL_MD, Diagram_Messages.COL_PROCESS});
        TableUtil.setInitialColumnSizes(this.implementsTable, new int[]{35, 35});
        this.processes = this.collectProcessDefinitions(this.getEditor().getWorkflowModel());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProcessDefinitionImplemetationLabelProvider());
        this.viewer.setInput(this.processes);
        this.implementsTable.setEnabled(this.isImplementing);
        this.implementsTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem tableItem;
                if (e.item != null && (tableItem = (TableItem)e.item).getData() != null) {
                    ProcessDefinitionType processDefinition = (ProcessDefinitionType)tableItem.getData();
                    ModelType referencedModel = (ModelType)processDefinition.eContainer();
                    ExternalPackage packageRef = ProcessDefinitionImplementationPropertyPage.this.getEditor().getWorkflowModel().getExternalPackages().getExternalPackage(referencedModel.getId());
                    IdRef idRef = CarnotWorkflowModelFactory.eINSTANCE.createIdRef();
                    idRef.setRef(processDefinition.getId());
                    idRef.setPackageRef(packageRef);
                    ProcessDefinitionImplementationPropertyPage.this.process.setExternalRef(idRef);
                }
            }
        });
        return composite;
    }

    private List<ProcessDefinitionType> collectProcessDefinitions(ModelType model) {
        List processesList = CollectionUtils.newList();
        ExternalPackages packages = model.getExternalPackages();
        if (packages != null) {
            for (ExternalPackage pkg : packages.getExternalPackage()) {
                EList externalDeclarations;
                IConnectionManager manager;
                String uri = ExtendedAttributeUtil.getAttributeValue((Extensible)pkg, (String)"carnot:connection:uri");
                if (StringUtils.isEmpty((String)uri) || (manager = model.getConnectionManager()) == null) continue;
                EObject externalModel = manager.find(uri);
                if (externalModel instanceof IObjectReference) {
                    externalModel = ((IObjectReference)externalModel).getEObject();
                }
                if (!(externalModel instanceof ModelType) || (externalDeclarations = ((ModelType)externalModel).getProcessDefinition()) == null) continue;
                processesList.addAll(externalDeclarations);
            }
        }
        return processesList;
    }
}

