/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.contextTypes.jsp;

import java.net.URL;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.IContextPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.spi.DefaultModelElementPropertyPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JspPropertyPage
extends DefaultModelElementPropertyPage
implements IContextPropertyPage {
    private static final String WEBEX_SCOPE = "carnot:webex:";
    private static final String HTML_PATH_ATT = "carnot:webex:htmlPath";
    private Text urlText = null;
    private Button testButton = null;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        ContextType context = (ContextType)element;
        EList attributes = context.getAttribute();
        String url = null;
        int i = 0;
        while (i < attributes.size()) {
            AttributeType attribute = (AttributeType)attributes.get(i);
            if (HTML_PATH_ATT.equals(attribute.getName())) {
                url = attribute.getValue();
            }
            ++i;
        }
        this.urlText.setText(url == null ? "" : url.trim());
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        ContextType context = (ContextType)element;
        AttributeUtil.setAttribute((IExtensibleElement)context, (String)HTML_PATH_ATT, (String)this.urlText.getText().trim());
    }

    @Override
    public Control createBody(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(3, false);
        composite.setLayout((Layout)compositeLayout);
        GridData compositeGridData = new GridData();
        compositeGridData.horizontalAlignment = 4;
        compositeGridData.verticalAlignment = 4;
        compositeGridData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)compositeGridData);
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(Diagram_Messages.LB_JSPURL);
        this.urlText = FormBuilder.createText((Composite)composite);
        this.testButton = new Button(composite, 0);
        this.testButton.setText(Diagram_Messages.B_Test);
        GridData testButtonGridData = new GridData(4);
        this.testButton.setLayoutData((Object)testButtonGridData);
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String u = JspPropertyPage.this.urlText.getText();
                try {
                    URL url = new URL(u);
                    url.openStream();
                    MessageDialog.openInformation((Shell)parent.getShell(), (String)Diagram_Messages.MSG_TestURL, (String)(String.valueOf(Diagram_Messages.MSG_SuccessfullyConnectedTo) + u));
                }
                catch (Exception exception) {
                    MessageDialog.openWarning((Shell)parent.getShell(), (String)Diagram_Messages.MSG_TestURL, (String)(String.valueOf(Diagram_Messages.MSG_ConnectionTo) + u + Diagram_Messages.MSG_Failed));
                }
            }
        });
        return composite;
    }

    @Override
    public void setDelegateContainer(AbstractModelElementPropertyPage page) {
    }
}

