/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.stardust.modeling.core.editors.figures.LaneFigure;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractConnectionSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;

public class LaneConnections {
    private LaneEditPart laneEP;
    private LaneFigure laneFigure;
    private boolean collapsed;
    private List childLaneEditParts = new ArrayList();
    private Set inConnections = new HashSet();
    private Set outConnections = new HashSet();
    private Set innerConnections = new HashSet();

    public LaneConnections(LaneEditPart laneEP, boolean collapsed) {
        this.laneEP = laneEP;
        this.laneFigure = laneEP.getLaneFigure();
        this.collapsed = collapsed;
    }

    public void handleConnections() {
        EditPart parentEP = this.laneEP.getParent();
        while (parentEP != null) {
            LaneFigure figure;
            if (parentEP instanceof LaneEditPart && (figure = ((LaneEditPart)parentEP).getLaneFigure()).isCollapsed()) {
                this.collapsed = true;
                break;
            }
            parentEP = parentEP.getParent();
        }
        this.collectAll(this.laneEP, true);
        this.collectInner();
        this.viewHideConnections();
        int i = 0;
        while (i < this.childLaneEditParts.size()) {
            LaneEditPart childLaneEP = (LaneEditPart)this.childLaneEditParts.get(i);
            LaneConnections laneConnections = new LaneConnections(childLaneEP, childLaneEP.getLaneFigure().isCollapsed());
            laneConnections.handleConnections();
            ++i;
        }
    }

    public void collectAll(LaneEditPart laneEditPart, boolean collect) {
        List childrenEP = laneEditPart.getChildren();
        int i = 0;
        while (i < childrenEP.size()) {
            AbstractNodeSymbolEditPart childEP = (AbstractNodeSymbolEditPart)childrenEP.get(i);
            if (childEP instanceof LaneEditPart) {
                if (!this.collapsed && collect) {
                    this.childLaneEditParts.add(childEP);
                }
                this.collectAll((LaneEditPart)childEP, false);
            }
            if (childEP.getSourceConnections().size() > 0) {
                this.outConnections.addAll(childEP.getSourceConnections());
            }
            if (childEP.getTargetConnections().size() > 0) {
                this.inConnections.addAll(childEP.getTargetConnections());
            }
            ++i;
        }
    }

    public void collectInner() {
        if (this.inConnections.size() > 0 && this.outConnections.size() > 0) {
            for (AbstractConnectionEditPart connectionEP : this.inConnections) {
                if (!this.outConnections.contains(connectionEP) || this.innerConnections.contains(connectionEP)) continue;
                this.innerConnections.add(connectionEP);
            }
        }
        if (this.innerConnections.size() > 0) {
            for (AbstractConnectionEditPart connectionEP : this.innerConnections) {
                this.outConnections.remove(connectionEP);
                this.inConnections.remove(connectionEP);
            }
        }
    }

    public void viewHideConnections() {
        ConnectionAnchor anchor;
        PolylineConnection connectionFigure;
        if (this.innerConnections.size() > 0) {
            for (AbstractConnectionEditPart connectionEP : this.innerConnections) {
                ConnectionAnchor sourceAnchor;
                connectionFigure = (PolylineConnection)connectionEP.getFigure();
                if (this.collapsed) {
                    connectionFigure.setVisible(false);
                    continue;
                }
                connectionFigure.setVisible(true);
                ConnectionAnchor targetAnchor = ((AbstractConnectionSymbolEditPart)connectionEP).getTargetConnectionAnchor();
                if (targetAnchor != null) {
                    connectionFigure.setTargetAnchor(targetAnchor);
                }
                if ((sourceAnchor = ((AbstractConnectionSymbolEditPart)connectionEP).getSourceConnectionAnchor()) == null) continue;
                connectionFigure.setSourceAnchor(sourceAnchor);
            }
        }
        if (this.inConnections.size() > 0) {
            for (AbstractConnectionEditPart connectionEP : this.inConnections) {
                connectionFigure = (PolylineConnection)connectionEP.getFigure();
                if (this.collapsed) {
                    anchor = new ChopboxAnchor((IFigure)this.laneFigure);
                    connectionFigure.setTargetAnchor(anchor);
                    continue;
                }
                anchor = ((AbstractConnectionSymbolEditPart)connectionEP).getTargetConnectionAnchor();
                if (anchor == null) continue;
                connectionFigure.setTargetAnchor(anchor);
            }
        }
        if (this.outConnections.size() > 0) {
            for (AbstractConnectionEditPart connectionEP : this.outConnections) {
                connectionFigure = (PolylineConnection)connectionEP.getFigure();
                if (this.collapsed) {
                    anchor = new ChopboxAnchor((IFigure)this.laneFigure);
                    connectionFigure.setSourceAnchor(anchor);
                    continue;
                }
                anchor = ((AbstractConnectionSymbolEditPart)connectionEP).getSourceConnectionAnchor();
                if (anchor == null) continue;
                connectionFigure.setSourceAnchor(anchor);
            }
        }
    }
}

