/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.annotations;

import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotBooleanEditor;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.data.structured.annotations.AnnotationCellEditor;
import org.eclipse.stardust.modeling.data.structured.annotations.AnnotationContentProvider;
import org.eclipse.stardust.modeling.data.structured.annotations.AnnotationLabelProvider;
import org.eclipse.stardust.modeling.data.structured.annotations.DefaultAnnotationModifier;
import org.eclipse.stardust.modeling.data.structured.annotations.IAnnotation;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;

public class AnnotationViewer {
    private static final String[] registryColumns = new String[]{Structured_Messages.COL_PROPERTY, Structured_Messages.COL_VALUE, Structured_Messages.COL_EDIT_IN_STRUCTURE, Structured_Messages.COL_CHANGE_ALL};
    private TreeViewer viewer;
    private boolean changeAllMode;
    private AnnotationCellEditor annotationEditor;
    private AnnotationContentProvider annotationContentProvider;
    private Map<IAnnotation, Boolean> changeAllValues = CollectionUtils.newMap();
    private Map<IAnnotation, AnnotationCellEditor> editorsMap = CollectionUtils.newMap();
    private CarnotBooleanEditor changeAll;
    private CarnotBooleanEditor editInStructure;

    public boolean isChangeAllMode() {
        return this.changeAllMode;
    }

    public AnnotationCellEditor getAnnotationEditor() {
        return this.annotationEditor;
    }

    public AnnotationContentProvider getAnnotationContentProvider() {
        return this.annotationContentProvider;
    }

    public Control createControl(Composite composite, final TreeViewer observed) {
        Tree tree = FormBuilder.createTree((Composite)composite, (int)67588);
        tree.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData((int)2));
        tree.setHeaderVisible(true);
        this.viewer = new TreeViewer(tree);
        int i = 0;
        while (i < registryColumns.length) {
            TreeColumn column = new TreeColumn(tree, 16384);
            column.setText(registryColumns[i]);
            column.setWidth(200);
            ++i;
        }
        this.viewer.setUseHashlookup(true);
        this.annotationContentProvider = new AnnotationContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.annotationContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new AnnotationLabelProvider());
        this.viewer.setColumnProperties(registryColumns);
        this.annotationEditor = new AnnotationCellEditor(this.viewer, 1, null){

            @Override
            public void updateViewer(IAnnotation annotation) {
                super.updateViewer(annotation);
                AnnotationViewer.this.propagate(observed, annotation);
                if (AnnotationViewer.this.editorsMap.containsKey(annotation)) {
                    observed.refresh(true);
                }
            }
        };
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = (TreeItem)e.item;
                if (item == null) {
                    return;
                }
                IAnnotation annotation = (IAnnotation)item.getData();
                AnnotationCellEditor editor = (AnnotationCellEditor)AnnotationViewer.this.editorsMap.get(annotation);
                if (editor != null) {
                    editor.stopEditing();
                    observed.refresh(true);
                }
                AnnotationViewer.this.annotationEditor.update(item);
            }
        });
        final Point position = new Point(0, 0);
        final Tree observedTree = (Tree)observed.getControl();
        observedTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                position.x = e.x;
                position.y = e.y;
            }
        });
        observedTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int x0;
                TreeColumn[] columns = observedTree.getColumns();
                int[] order = observedTree.getColumnOrder();
                int x1 = x0 = 0;
                int i = 0;
                while (i < order.length) {
                    TreeColumn column = columns[order[i]];
                    Object data = column.getData();
                    x1 += column.getWidth();
                    if (data instanceof IAnnotation) {
                        AnnotationCellEditor editor = (AnnotationCellEditor)AnnotationViewer.this.editorsMap.get(data);
                        if (position.x >= x0 && position.x < x1) {
                            editor.update((TreeItem)e.item);
                        } else {
                            editor.stopEditing();
                        }
                    }
                    x0 = x1;
                    ++i;
                }
            }
        });
        this.annotationContentProvider.setCurrentElement(null);
        this.viewer.setInput((Object)"dummy");
        this.viewer.expandAll();
        this.viewer.getControl().setVisible(false);
        MenuManager menuManager = this.createMenuManager(new Action[]{this.createDeleteAction()});
        tree.setMenu(menuManager.createContextMenu((Control)tree));
        this.changeAll = new CarnotBooleanEditor(3){

            public boolean canEdit(Object element) {
                IAnnotation annotation = (IAnnotation)element;
                return DefaultAnnotationModifier.canModifyAnnotation(annotation);
            }

            public Object getValue(Object element) {
                IAnnotation annotation = (IAnnotation)element;
                return AnnotationViewer.this.changeAllValues.containsKey(annotation);
            }

            public void setValue(Object element, Object value) {
                IAnnotation annotation = (IAnnotation)element;
                Boolean newValue = (Boolean)value;
                AnnotationViewer.this.changeAllMode = newValue;
                if (newValue.booleanValue()) {
                    AnnotationViewer.this.changeAllValues.put(annotation, newValue);
                } else {
                    AnnotationViewer.this.changeAllValues.remove(annotation);
                }
            }

            public void refresh(TreeEditor editor) {
                super.refresh(editor);
                Button button = (Button)editor.getEditor();
                TreeItem item = editor.getItem();
                IAnnotation annotation = (IAnnotation)item.getData();
                button.setVisible(AnnotationViewer.this.editorsMap.containsKey(annotation));
            }
        };
        this.changeAll.setTree(tree);
        this.changeAll.refresh();
        this.editInStructure = new CarnotBooleanEditor(2){

            public boolean canEdit(Object element) {
                IAnnotation annotation = (IAnnotation)element;
                return DefaultAnnotationModifier.canModifyAnnotation(annotation);
            }

            public Object getValue(Object element) {
                IAnnotation annotation = (IAnnotation)element;
                return AnnotationViewer.this.editorsMap.containsKey(annotation) ? Boolean.TRUE : Boolean.FALSE;
            }

            public void setValue(Object element, Object value) {
                IAnnotation annotation = (IAnnotation)element;
                if (((Boolean)value).booleanValue()) {
                    TreeColumn column = new TreeColumn(observedTree, 16384);
                    column.setText(annotation.getName());
                    column.setWidth(200);
                    column.setData((Object)annotation);
                    observedTree.showColumn(column);
                    observed.refresh(true);
                    int index = observedTree.indexOf(column);
                    AnnotationCellEditor editor = new AnnotationCellEditor(observed, index, annotation){

                        @Override
                        public void updateViewer(IAnnotation annotation) {
                            super.updateViewer(annotation);
                            if (AnnotationViewer.this.propagate(observed, annotation)) {
                                observed.refresh(true);
                            }
                            AnnotationViewer.this.viewer.refresh((Object)annotation, true);
                        }
                    };
                    AnnotationViewer.this.editorsMap.put(annotation, editor);
                } else {
                    TreeColumn column;
                    AnnotationCellEditor editor = (AnnotationCellEditor)AnnotationViewer.this.editorsMap.remove(annotation);
                    if (editor != null) {
                        editor.dispose();
                    }
                    if ((column = AnnotationViewer.this.findColumn(observedTree, annotation)) != null) {
                        column.dispose();
                    }
                }
                AnnotationViewer.this.changeAll.refresh();
            }
        };
        this.editInStructure.setTree(tree);
        return tree;
    }

    private boolean propagate(TreeViewer observed, IAnnotation annotation) {
        if (this.changeAllValues.containsKey(annotation)) {
            ITreeContentProvider provider = (ITreeContentProvider)observed.getContentProvider();
            Object[] elements = provider.getElements(observed.getInput());
            this.changeAll(annotation, provider, elements, annotation.getRawValue());
            return true;
        }
        return false;
    }

    private void changeAll(IAnnotation annotation, ITreeContentProvider provider, Object[] elements, String rawValue) {
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                XSDElementDeclaration element;
                if (elements[i] instanceof XSDElementDeclaration && (element = (XSDElementDeclaration)elements[i]).eContainer() != null && !(element.getType() instanceof XSDComplexTypeDefinition)) {
                    annotation.setRawValue(element, rawValue);
                }
                this.changeAll(annotation, provider, provider.getChildren(elements[i]), rawValue);
                ++i;
            }
        }
    }

    private MenuManager createMenuManager(final Action[] actions) {
        MenuManager menuManager = new MenuManager();
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                boolean enabled = true;
                IStructuredSelection selection = (IStructuredSelection)AnnotationViewer.this.viewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    for (IAnnotation annotation : selection) {
                        if (annotation.exists() && DefaultAnnotationModifier.canModifyAnnotation(annotation)) continue;
                        enabled = false;
                        break;
                    }
                }
                int i = 0;
                while (i < actions.length) {
                    actions[i].setEnabled(enabled);
                    ++i;
                }
            }
        });
        int i = 0;
        while (i < actions.length) {
            menuManager.add((IAction)actions[i]);
            ++i;
        }
        return menuManager;
    }

    private Action createDeleteAction() {
        return new Action(Structured_Messages.ACTION_DELETE){

            public void runWithEvent(Event event) {
                AnnotationViewer.this.annotationEditor.stopEditing();
                IStructuredSelection selection = (IStructuredSelection)AnnotationViewer.this.viewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    for (IAnnotation annotation : selection) {
                        IAnnotation parent = annotation.getParent();
                        DefaultAnnotationModifier.deleteAnnotation(annotation);
                        if (parent == null) {
                            AnnotationViewer.this.viewer.refresh();
                            continue;
                        }
                        AnnotationViewer.this.viewer.refresh((Object)parent);
                    }
                }
            }
        };
    }

    public void setInput(XSDElementDeclaration element) {
        this.annotationEditor.stopEditing();
        if (element != null && element.getType() instanceof XSDComplexTypeDefinition) {
            this.annotationContentProvider.removeIPPAnnotations(element);
        }
        this.annotationContentProvider.setCurrentElement(element);
        if (element == null) {
            this.viewer.getControl().setVisible(false);
        } else {
            this.viewer.refresh(true);
            this.viewer.expandAll();
            this.editInStructure.setTree(this.viewer.getTree());
            this.changeAll.setTree(this.viewer.getTree());
            this.viewer.getControl().setVisible(true);
        }
    }

    public void createDefaultAnnotations(XSDElementDeclaration xsdElement) {
    }

    public void setDeclaration(TypeDeclarationType declaration) {
        this.annotationContentProvider.setDeclaration(declaration);
    }

    private TreeColumn findColumn(Tree tree, IAnnotation annotation) {
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i].getData() == annotation) {
                return columns[i];
            }
            ++i;
        }
        return null;
    }
}

