/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.interpreter;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.eclipse.stardust.common.error.ValidationException;
import org.eclipse.stardust.engine.core.compatibility.gui.AbstractDialog;
import org.eclipse.stardust.engine.core.compatibility.gui.ByteEntry;
import org.eclipse.stardust.engine.core.compatibility.gui.GUI;
import org.eclipse.stardust.engine.core.compatibility.gui.LabeledComponentsPanel;
import org.eclipse.stardust.engine.core.compatibility.gui.TextEntry;
import org.eclipse.stardust.modeling.debug.interpreter.DataGroup;
import org.eclipse.stardust.modeling.debug.interpreter.MetadataEditor;

public class CreateSubGroupDialog
extends AbstractDialog {
    protected static CreateSubGroupDialog singleton = null;
    private DataGroup dataGroup;
    private boolean createSubgroup;
    private TextEntry idEntry;
    private TextEntry labelEntry;
    private ByteEntry columnEntry;
    private ByteEntry rowEntry;
    private TextEntry typeEntry;

    protected CreateSubGroupDialog() {
        this(null);
    }

    protected CreateSubGroupDialog(Frame parent) {
        super(parent);
    }

    public JComponent createContent() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(GUI.getEmptyPanelBorder());
        LabeledComponentsPanel components = new LabeledComponentsPanel();
        this.idEntry = new TextEntry(10);
        components.add((JComponent)this.idEntry, "ID:", 105);
        this.idEntry.setMandatory(true);
        this.labelEntry = new TextEntry(20);
        components.add((JComponent)this.labelEntry, "Label:", 108);
        this.typeEntry = new TextEntry(20);
        components.add((JComponent)this.typeEntry, "Type:", 116);
        JComponent[] jComponentArray = new JComponent[2];
        this.rowEntry = new ByteEntry();
        jComponentArray[0] = this.rowEntry;
        this.columnEntry = new ByteEntry();
        jComponentArray[1] = this.columnEntry;
        components.add(jComponentArray, new String[]{"Row:", "Column:"}, new int[]{114, 99});
        components.pack();
        panel.add((Component)components);
        return panel;
    }

    public void getData(DataGroup dataGroup) {
        dataGroup.setID(this.idEntry.getText());
        dataGroup.setLabel(this.labelEntry.getText());
        dataGroup.setType(this.typeEntry.getText());
        dataGroup.setRow(this.rowEntry.getValue());
        dataGroup.setColumn(this.columnEntry.getValue());
    }

    public void onOK() {
        if (this.createSubgroup) {
            this.dataGroup.createSubGroup(this.idEntry.getText());
        } else {
            this.getData(this.dataGroup);
        }
    }

    public void validateSettings() throws ValidationException {
    }

    public void setData(DataGroup dataGroup) {
        this.dataGroup = dataGroup;
        this.idEntry.setText(dataGroup.getID());
        this.labelEntry.setText(dataGroup.getLabel());
        this.typeEntry.setText(dataGroup.getType());
        this.rowEntry.setValue(dataGroup.getRow());
        this.columnEntry.setValue(dataGroup.getColumn());
    }

    public static boolean showDialog(MetadataEditor editor, DataGroup dataGroup) {
        return CreateSubGroupDialog.showDialog(editor, dataGroup, null);
    }

    public static boolean showDialog(MetadataEditor editor, DataGroup dataGroup, Frame parent) {
        if (singleton == null) {
            singleton = new CreateSubGroupDialog(parent);
        }
        CreateSubGroupDialog.singleton.createSubgroup = false;
        singleton.setData(dataGroup);
        return CreateSubGroupDialog.showDialog((String)"Modify Data Group", (AbstractDialog)singleton, (JDialog)((Object)editor));
    }

    public static boolean showDialog(MetadataEditor editor, DataGroup dataGroup, boolean createSubGroup) {
        return CreateSubGroupDialog.showDialog(editor, dataGroup, createSubGroup, null);
    }

    public static boolean showDialog(MetadataEditor editor, DataGroup dataGroup, boolean createSubGroup, Frame parent) {
        if (singleton == null) {
            singleton = new CreateSubGroupDialog(parent);
        }
        CreateSubGroupDialog.singleton.createSubgroup = true;
        CreateSubGroupDialog.singleton.dataGroup = dataGroup;
        return CreateSubGroupDialog.showDialog((String)"Create Subgroup", (AbstractDialog)singleton, (JDialog)((Object)editor));
    }
}

