/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.stardust.common.OneElementIterator;
import org.eclipse.stardust.common.Predicate;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.modeling.common.ui.ICWMDebugTarget;
import org.eclipse.stardust.modeling.common.ui.IWorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.highlighting.HighlightState;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.debugger.Debugger;
import org.eclipse.stardust.modeling.debug.debugger.types.AbstractJavaTypeValue;
import org.eclipse.stardust.modeling.debug.debugger.types.ActivityInstanceDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.DebugVariableUtils;
import org.eclipse.stardust.modeling.debug.debugger.types.JavaTypeValueFactory;
import org.eclipse.stardust.modeling.debug.debugger.types.ProcessInstanceDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.TransitionTokenDigest;
import org.eclipse.stardust.modeling.debug.engine.ManagedRunnerHelper;
import org.eclipse.stardust.modeling.debug.highlighting.HighlightManager;
import org.eclipse.stardust.modeling.debug.model.CWMDebugElement;
import org.eclipse.stardust.modeling.debug.model.CWMThread;
import org.eclipse.stardust.modeling.debug.util.CollectionUtils;
import org.eclipse.stardust.modeling.debug.views.WorklistView;

public class CWMDebugTarget
extends CWMDebugElement
implements ICWMDebugTarget,
IDebugTarget {
    private static final Logger trace = LogManager.getLogger(CWMDebugTarget.class);
    private IDebugTarget javaTarget;
    private String sourceName;
    private WorklistManager worklistManager;
    private List transTokens = new ArrayList();
    private List threadList = new ArrayList();
    private IJavaThread onCompletionThread = null;
    private IDebugEventSetListener workflowEventDelegater;
    private IDebugEventSetListener workflowThreadHandler;
    private WorkflowEventCallback workflowEventCallback;
    private WorkflowModelEditor editor;
    private boolean analystMode;

    public CWMDebugTarget(WorkflowModelEditor editor, IDebugTarget javaTarget, ProcessDefinitionType pd, boolean analystMode) throws CoreException {
        super(null);
        this.target = this;
        this.javaTarget = javaTarget;
        this.editor = editor;
        this.analystMode = analystMode;
        this.workflowEventDelegater = new WorkflowEventDelegater();
        this.workflowThreadHandler = new WorkflowThreadHandler();
        this.worklistManager = new WorklistManager(this);
        DebugPlugin.getDefault().addDebugEventListener(this.workflowEventDelegater);
        DebugPlugin.getDefault().addDebugEventListener(this.workflowThreadHandler);
        this.workflowEventCallback = new WorkflowEventCallback();
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public IProcess getProcess() {
        return this.javaTarget.getProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IThread[] getThreads() throws DebugException {
        ArrayList concatenatedThreads;
        List<IThread> javaThreads = Arrays.asList(this.javaTarget.getThreads());
        List list = this.threadList;
        synchronized (list) {
            concatenatedThreads = new ArrayList();
            CollectionUtils.copy(concatenatedThreads, javaThreads, new Predicate(){

                public boolean accept(Object o) {
                    try {
                        IJavaThread javaThread = (IJavaThread)o;
                        return !"Infinity Activity Thread".equals(javaThread.getThreadGroupName()) && !"Infinity Helper Thread".equals(javaThread.getThreadGroupName()) && !"Infinity On Completion Thread".equals(javaThread.getThreadGroupName());
                    }
                    catch (DebugException e) {
                        throw new InternalException((Throwable)e);
                    }
                }
            });
            CollectionUtils.copy(concatenatedThreads, this.threadList, null);
        }
        if (this.onCompletionThread != null && this.getWorkflowThread(this.onCompletionThread) != null) {
            CollectionUtils.copy(concatenatedThreads, (Iterator)new OneElementIterator((Object)this.onCompletionThread), null);
        }
        return concatenatedThreads.toArray(new IThread[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasThreads() throws DebugException {
        List list = this.threadList;
        synchronized (list) {
            return !this.threadList.isEmpty() || this.javaTarget.hasThreads();
        }
    }

    public String getName() throws DebugException {
        return Debug_Messages.CWM_DEBUG_NAME_CARNOTWorkflowDebugger;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return this.javaTarget.supportsBreakpoint(breakpoint);
    }

    @Override
    public ILaunch getLaunch() {
        return this.javaTarget.getLaunch();
    }

    public boolean canTerminate() {
        return this.javaTarget.canTerminate();
    }

    public boolean isTerminated() {
        return this.javaTarget.isTerminated();
    }

    public void terminate() throws DebugException {
        this.cleanup();
        this.javaTarget.terminate();
    }

    private void cleanup() {
        try {
            HighlightManager.getDefault().removeAllHighlightables();
            this.worklistManager.reset();
        }
        finally {
            DebugPlugin.getDefault().removeDebugEventListener(this.workflowEventDelegater);
            DebugPlugin.getDefault().removeDebugEventListener(this.workflowThreadHandler);
        }
    }

    public boolean canResume() {
        return this.javaTarget.canResume();
    }

    public boolean canSuspend() {
        return this.javaTarget.canSuspend();
    }

    public boolean isSuspended() {
        return this.javaTarget.isSuspended();
    }

    public void resume() throws DebugException {
        this.javaTarget.resume();
    }

    public void suspend() throws DebugException {
        this.javaTarget.suspend();
    }

    public boolean canDisconnect() {
        return this.javaTarget.canDisconnect();
    }

    public void disconnect() throws DebugException {
        this.javaTarget.disconnect();
    }

    public boolean isDisconnected() {
        return this.javaTarget.isDisconnected();
    }

    public boolean supportsStorageRetrieval() {
        return this.javaTarget.supportsStorageRetrieval();
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return this.javaTarget.getMemoryBlock(startAddress, length);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.javaTarget.breakpointAdded(breakpoint);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.javaTarget.breakpointChanged(breakpoint, delta);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.javaTarget.breakpointRemoved(breakpoint, delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CWMThread getWorkflowThread(IJavaThread javaThread) {
        List list = this.threadList;
        synchronized (list) {
            for (CWMThread thread : this.threadList) {
                if (!thread.getJavaThread().equals(javaThread)) continue;
                return thread;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSuspendedActivityInstances() {
        ArrayList<ActivityInstanceDigest> result = new ArrayList<ActivityInstanceDigest>();
        List list = this.threadList;
        synchronized (list) {
            for (CWMThread thread : this.threadList) {
                ActivityInstanceDigest activityInstance;
                if (!thread.isSuspended() || (activityInstance = thread.getCurrentActivityInstance()) == null) continue;
                activityInstance.setThread(thread);
                result.add(activityInstance);
            }
        }
        this.worklistManager.set(result);
    }

    public IWorkflowModelEditor getEditor() {
        return this.editor;
    }

    public boolean isAnalystMode() {
        return this.analystMode;
    }

    public WorklistManager getWorklistManager() {
        return this.worklistManager;
    }

    private class WorkflowEventCallback {
        private WorkflowEventCallback() {
        }

        public void performedTransition(TransitionTokenDigest details) {
            HighlightManager.getDefault().setHighlightState(details, details.isConsumed() ? HighlightState.DONE_LITERAL : HighlightState.ACTIVE_LITERAL);
            CWMDebugTarget.this.transTokens.add(details);
            trace.info((Object)MessageFormat.format(Debug_Messages.CWM_DEBUG_MSG_Performed, details));
        }

        public void startedActivityInstance(ActivityInstanceDigest details) {
            HighlightManager.getDefault().setHighlightState(details, HighlightState.ACTIVE_LITERAL);
            CWMDebugTarget.this.worklistManager.add(details);
            trace.info((Object)MessageFormat.format(Debug_Messages.CWM_DEBUG_MSG_Started, details));
        }

        public void completedActivityInstance(ActivityInstanceDigest details) {
            HighlightManager.getDefault().setHighlightState(details, HighlightState.DONE_LITERAL);
            CWMDebugTarget.this.worklistManager.remove(details);
            trace.info((Object)MessageFormat.format(Debug_Messages.CWM_DEBUG_MSG_Completed, details));
        }

        public void appendedToWorklist(ActivityInstanceDigest details) {
        }
    }

    private class WorkflowEventDelegater
    implements IDebugEventSetListener {
        private WorkflowEventDelegater() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            int eventIdx = 0;
            while (eventIdx < events.length) {
                int kind;
                DebugEvent event = events[eventIdx];
                Object source = event.getSource();
                if (source instanceof IJavaThread && ((kind = event.getKind()) & 0x12) != 0) {
                    IJavaThread javaThread = (IJavaThread)source;
                    IBreakpoint[] breakpoints = javaThread.getBreakpoints();
                    int bpIdx = 0;
                    while (bpIdx < breakpoints.length) {
                        block19: {
                            IBreakpoint bp = breakpoints[bpIdx];
                            if (bp instanceof IJavaMethodBreakpoint) {
                                IJavaMethodBreakpoint jmbp = (IJavaMethodBreakpoint)bp;
                                try {
                                    IStackFrame[] frames;
                                    String typeName = jmbp.getTypeName();
                                    if (!Debugger.WorkflowEventListenerImpl.class.getName().equals(typeName) || (frames = javaThread.getStackFrames()).length == 0) break block19;
                                    IJavaStackFrame currentStackFrame = (IJavaStackFrame)frames[0];
                                    try {
                                        IVariable[] vars = currentStackFrame.getVariables();
                                        String methodName = jmbp.getMethodName();
                                        try {
                                            AbstractJavaTypeValue details;
                                            if (Debugger.WorkflowEventListenerImpl.performedTransitionMethodName.equals(methodName)) {
                                                details = (TransitionTokenDigest)JavaTypeValueFactory.createInstance("transToken", vars);
                                                CWMDebugTarget.this.workflowEventCallback.performedTransition((TransitionTokenDigest)details);
                                            } else {
                                                CWMThread thread;
                                                details = null;
                                                if (Debugger.WorkflowEventListenerImpl.startedActivityInstanceMethodName.equals(methodName)) {
                                                    details = (ActivityInstanceDigest)JavaTypeValueFactory.createInstance("activityInstance", vars);
                                                    CWMDebugTarget.this.workflowEventCallback.startedActivityInstance((ActivityInstanceDigest)details);
                                                } else if (Debugger.WorkflowEventListenerImpl.completedActivityInstanceMethodName.equals(methodName)) {
                                                    details = (ActivityInstanceDigest)JavaTypeValueFactory.createInstance("activityInstance", vars);
                                                    CWMDebugTarget.this.workflowEventCallback.completedActivityInstance((ActivityInstanceDigest)details);
                                                } else if (Debugger.WorkflowEventListenerImpl.appendedToWorklistMethodName.equals(methodName)) {
                                                    details = (ActivityInstanceDigest)JavaTypeValueFactory.createInstance("activityInstance", vars);
                                                    CWMDebugTarget.this.workflowEventCallback.appendedToWorklist((ActivityInstanceDigest)details);
                                                }
                                                trace.info((Object)MessageFormat.format(Debug_Messages.CWM_DEBUG_MSG_CurrentActivityInstanceDigest, details));
                                                if (details != null && (thread = CWMDebugTarget.this.getWorkflowThread(javaThread)) != null) {
                                                    thread.setCurrentActivityInstance((ActivityInstanceDigest)details);
                                                }
                                            }
                                        }
                                        catch (RuntimeException e) {
                                            e.printStackTrace();
                                            throw e;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        trace.info((Object)MessageFormat.format(Debug_Messages.CWM_DEBUG_MSG_ResumeJavaThread, javaThread));
                                        javaThread.resume();
                                        throw throwable;
                                    }
                                    trace.info((Object)MessageFormat.format(Debug_Messages.CWM_DEBUG_MSG_ResumeJavaThread, javaThread));
                                    javaThread.resume();
                                }
                                catch (DebugException x) {
                                    throw new InternalException((Throwable)x);
                                }
                                catch (CoreException x) {
                                    throw new InternalException((Throwable)x);
                                }
                            }
                        }
                        ++bpIdx;
                    }
                }
                ++eventIdx;
            }
        }
    }

    private class WorkflowThreadHandler
    implements IDebugEventSetListener {
        IDebugTarget javaThreadTarget;

        private WorkflowThreadHandler() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            try {
                int eventIdx = 0;
                while (eventIdx < events.length) {
                    if (events[eventIdx].getSource() instanceof IJavaThread) {
                        IJavaThread javaThread = (IJavaThread)events[eventIdx].getSource();
                        if ("Infinity Activity Thread".equals(javaThread.getThreadGroupName())) {
                            switch (events[eventIdx].getKind()) {
                                case 4: {
                                    this.onCreate(javaThread, events[eventIdx]);
                                    break;
                                }
                                case 8: {
                                    this.onTerminate(javaThread, events[eventIdx]);
                                    break;
                                }
                                case 1: {
                                    this.onResume(javaThread, events[eventIdx]);
                                    break;
                                }
                                case 2: {
                                    this.onSuspend(javaThread, events[eventIdx]);
                                }
                            }
                        } else if ("Infinity On Completion Thread".equals(javaThread.getThreadGroupName())) {
                            switch (events[eventIdx].getKind()) {
                                case 4: {
                                    this.onCreateCompletionThread(javaThread, events[eventIdx]);
                                    break;
                                }
                                case 8: {
                                    this.onTerminate(javaThread, events[eventIdx]);
                                    break;
                                }
                                case 1: {
                                    this.onResume(javaThread, events[eventIdx]);
                                    break;
                                }
                                case 2: {
                                    this.onSuspend(javaThread, events[eventIdx]);
                                }
                            }
                        }
                    }
                    if (events[eventIdx].getKind() == 8 && CWMDebugTarget.this.isTerminated() && !CWMDebugTarget.this.hasThreads()) {
                        CWMDebugTarget.this.cleanup();
                    }
                    ++eventIdx;
                }
            }
            catch (DebugException x) {
                throw new InternalException((Throwable)x);
            }
        }

        private void onCreateCompletionThread(IJavaThread javaThread, DebugEvent event) {
            if (CWMDebugTarget.this.onCompletionThread != null) {
                CWMDebugTarget.this.onCompletionThread = javaThread;
                this.onCreate(javaThread, event);
                CWMDebugTarget.this.onCompletionThread = null;
            } else {
                CWMDebugTarget.this.onCompletionThread = javaThread;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onCreate(IJavaThread javaThread, DebugEvent event) {
            if (this.javaThreadTarget == null) {
                this.javaThreadTarget = javaThread.getDebugTarget();
            }
            if (javaThread.getDebugTarget().equals(this.javaThreadTarget)) {
                CWMThread thread = new CWMThread(CWMDebugTarget.this, (IThread)javaThread, CWMDebugTarget.this.onCompletionThread == javaThread);
                List list = CWMDebugTarget.this.threadList;
                synchronized (list) {
                    CWMDebugTarget.this.threadList.add(thread);
                }
                thread.fireCreationEvent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onTerminate(IJavaThread javaThread, DebugEvent event) {
            try {
                List list = CWMDebugTarget.this.threadList;
                synchronized (list) {
                    CWMThread thread = CWMDebugTarget.this.getWorkflowThread(javaThread);
                    if (thread != null) {
                        CWMDebugTarget.this.threadList.remove((Object)thread);
                        thread.fireTerminateEvent();
                        if (CWMDebugTarget.this.threadList.isEmpty()) {
                            if (CWMDebugTarget.this.onCompletionThread != null) {
                                CWMDebugTarget.this.onCompletionThread.resume();
                            } else {
                                CWMDebugTarget.this.terminate();
                            }
                        }
                    }
                }
            }
            catch (DebugException e) {
                throw new InternalException((Throwable)e);
            }
        }

        private void onResume(IJavaThread javaThread, DebugEvent event) {
            CWMThread thread = CWMDebugTarget.this.getWorkflowThread(javaThread);
            if (thread != null) {
                thread.fireResumeEvent(event.getDetail());
                CWMDebugTarget.this.updateSuspendedActivityInstances();
            }
        }

        private void onSuspend(IJavaThread javaThread, DebugEvent event) {
            if (event.isEvaluation()) {
                return;
            }
            CWMThread thread = CWMDebugTarget.this.getWorkflowThread(javaThread);
            if (thread != null) {
                try {
                    IBreakpoint[] breakpoints = javaThread.getBreakpoints();
                    int idx = 0;
                    while (idx < breakpoints.length) {
                        IStackFrame[] frames;
                        IJavaMethodBreakpoint javaBreakpoint;
                        IBreakpoint breakpoint = breakpoints[idx];
                        if (breakpoint instanceof IJavaMethodBreakpoint && this.isSuspendThreadBreakpoint(javaBreakpoint = (IJavaMethodBreakpoint)breakpoint) && (frames = javaThread.getStackFrames()).length > 1) {
                            IJavaStackFrame currentStackFrame = (IJavaStackFrame)frames[1];
                            IVariable[] vars = currentStackFrame.getVariables();
                            if (thread != null && thread.isCompletionThread()) {
                                ProcessInstanceDigest processInstance = (ProcessInstanceDigest)JavaTypeValueFactory.createInstance("processInstance", vars);
                                thread.setRootProcessInstance(processInstance);
                            } else {
                                ActivityInstanceDigest activityInstance = (ActivityInstanceDigest)JavaTypeValueFactory.createInstance("activityInstance", vars);
                                IVariable reloadValues = DebugVariableUtils.findVariable("reloadValues", vars);
                                thread.setCurrentActivityInstance(activityInstance);
                                thread.setReloadValuesVariable(reloadValues);
                                CWMDebugTarget.this.updateSuspendedActivityInstances();
                            }
                        }
                        ++idx;
                    }
                    thread.fireSuspendEvent(32);
                }
                catch (CoreException e) {
                    throw new InternalException((Throwable)e);
                }
            }
        }

        private boolean isSuspendThreadBreakpoint(IJavaMethodBreakpoint javaBreakpoint) throws CoreException {
            String managedRunnerHelperClassName = ManagedRunnerHelper.class.getName();
            String suspendThreadMethodName = ManagedRunnerHelper.suspendThreadMethodName;
            return managedRunnerHelperClassName.equals(javaBreakpoint.getTypeName()) && suspendThreadMethodName.equals(javaBreakpoint.getMethodName());
        }
    }

    public static class WorklistManager {
        private Set worklist = new HashSet();
        private Set views = new HashSet();
        private CWMDebugTarget target;

        public WorklistManager(CWMDebugTarget target) {
            this.target = target;
        }

        private void reset() {
            this.worklist.clear();
            this.refreshViews();
            this.views.clear();
        }

        public void set(List result) {
            this.worklist.clear();
            this.worklist.addAll(result);
            this.refreshViews();
        }

        private void refreshViews() {
            for (WorklistView view : this.views) {
                view.refresh(this);
            }
        }

        public void add(ActivityInstanceDigest activityInstance) {
            if (activityInstance.isInteractive()) {
                this.worklist.remove(activityInstance);
                this.worklist.add(activityInstance);
                this.refreshViews();
            }
        }

        public void remove(ActivityInstanceDigest activityInstance) {
            if (this.worklist.remove(activityInstance)) {
                this.refreshViews();
            }
        }

        public Iterator getWorklist() {
            return this.worklist.iterator();
        }

        public void addWorklistView(WorklistView view) {
            this.views.add(view);
            view.refresh(this);
        }

        public void removeWorklistView(WorklistView view) {
            this.views.remove((Object)view);
        }

        public CWMDebugTarget getTarget() {
            return this.target;
        }
    }
}

