/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.stardust.modeling.modelimport.Import_Messages;
import org.eclipse.stardust.modeling.modelimport.ModelNode;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FileSystemStore {
    private static final String VALID_FROM_ATT = "validFrom";
    private static final String VALID_TO_ATT = "validTo";
    private static final String DEPLOYMENT_TIME_ATT = "deploymentTime";
    private static final String DEPLOYMENT_COMMENT_ATT = "comment";
    private static final String OID_ATT = "oid";
    private static final String PUBLIC = "public";
    private static final String NAME_ATT = "name";
    private static final String DESCRIPTION_ATT = "description";
    private static final String ID_ATT = "id";
    private static final String VERSION_COUNT_ATT = "versionCount";
    private static final String VERSION_ATT = "version";
    private static final String PRIVATE = "private";
    private static final String OWNER_ATT = "owner";
    private static final String RELEASED_ATT = "released";
    private static final String RELEASE_TIME_ATT = "releaseTime";
    private static final String BOOT_FILE = "repository.boot";
    private File repositoryDirectory;
    private ArrayList rootModels;
    private IImportStructureProvider provider;

    public FileSystemStore(File repositoryDirectory, IImportStructureProvider provider) {
        this.repositoryDirectory = repositoryDirectory;
        this.provider = provider;
    }

    public void loadRepository() throws IOException, ParserConfigurationException {
        if (this.rootModels == null) {
            this.rootModels = new ArrayList();
        } else {
            this.rootModels.clear();
        }
        File file = new File(this.repositoryDirectory, BOOT_FILE);
        if (file.exists()) {
            Document document = FileSystemStore.readDocument(file);
            Element documentElement = document.getDocumentElement();
            NodeList nodelist = documentElement.getChildNodes();
            int i = 0;
            while (i < nodelist.getLength()) {
                Node node = nodelist.item(i);
                if (PUBLIC.equals(node.getNodeName())) {
                    Element element = (Element)node;
                    ModelNode modelnode = this.attachRootModel(element.getAttribute(ID_ATT), element.getAttribute(NAME_ATT), element.getAttribute(VERSION_COUNT_ATT));
                    this.attachPublicAttributes(modelnode, element);
                    this.loadVersions(modelnode, (Element)node);
                }
                ++i;
            }
        }
    }

    public static Document readDocument(File file) throws ParserConfigurationException, IOException {
        DocumentBuilder documentbuilder = FileSystemStore.newDomBuilder();
        try {
            InputSource inputsource = new InputSource(new FileInputStream(file));
            return documentbuilder.parse(inputsource);
        }
        catch (SAXException saxexception) {
            throw new IOException(saxexception.getMessage());
        }
    }

    public static DocumentBuilder newDomBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        DocumentBuilder documentbuilder = factory.newDocumentBuilder();
        documentbuilder.setErrorHandler(new DefaultHandler());
        return documentbuilder;
    }

    public ModelNode attachRootModel(String id, String name, String versionCount) throws IOException {
        if (this.findRootModel(id) != null) {
            throw new IOException(String.valueOf(Import_Messages.MSG_RootModelWithId) + id + "'.");
        }
        ModelNode modelnodebean = new ModelNode(this, id, name, "1", versionCount);
        this.rootModels.add(modelnodebean);
        return modelnodebean;
    }

    public ModelNode findRootModel(String id) {
        for (ModelNode modelnode : this.rootModels) {
            if (!modelnode.getId().equals(id)) continue;
            return modelnode;
        }
        return null;
    }

    private void attachPublicAttributes(ModelNode modelnode, Element element) {
        modelnode.setDescription(element.getAttribute(DESCRIPTION_ATT));
        modelnode.setValidFrom(element.getAttribute(VALID_FROM_ATT));
        modelnode.setValidTo(element.getAttribute(VALID_TO_ATT));
        modelnode.setDeploymentComment(element.getAttribute(DEPLOYMENT_COMMENT_ATT));
        modelnode.setDeploymentTime(element.getAttribute(DEPLOYMENT_TIME_ATT));
        modelnode.setModelOID(element.getAttribute(OID_ATT));
        if ("true".equalsIgnoreCase(element.getAttribute(RELEASED_ATT))) {
            String releaseTime = element.getAttribute(RELEASE_TIME_ATT);
            modelnode.release(releaseTime);
        }
    }

    private void loadVersions(ModelNode modelnode, Element element) {
        NodeList nodelist = element.getChildNodes();
        int i = 0;
        while (i < nodelist.getLength()) {
            Element child;
            Node node = nodelist.item(i);
            if (PUBLIC.equals(node.getNodeName())) {
                child = (Element)node;
                ModelNode childnode = modelnode.attachPublicVersion(child.getAttribute(ID_ATT), child.getAttribute(NAME_ATT), child.getAttribute(VERSION_ATT), child.getAttribute(VERSION_COUNT_ATT));
                this.attachPublicAttributes(childnode, child);
                this.loadVersions(childnode, (Element)node);
            } else if (PRIVATE.equals(node.getNodeName())) {
                child = (Element)node;
                modelnode.attachPrivateVersion(child.getAttribute(OWNER_ATT), child.getAttribute(VERSION_ATT));
            }
            ++i;
        }
    }

    public Object[] getRootModels() {
        return this.rootModels.toArray();
    }

    public String getFullName(ModelNode modelnode) {
        return this.getFile(modelnode).toString();
    }

    public File getFile(ModelNode modelnode) {
        return new File(this.repositoryDirectory, String.valueOf(modelnode.getId()) + "_" + modelnode.getFullVersion() + ".mod");
    }
}

