/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.elements;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.CarnotWorkflowModelResourceFactoryImpl;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.modelimport.IImportModelWizardPage;
import org.eclipse.stardust.modeling.modelimport.ISourceGroupProvider;
import org.eclipse.stardust.modeling.modelimport.ImportPlugin;
import org.eclipse.stardust.modeling.modelimport.Import_Messages;
import org.eclipse.stardust.modeling.modelimport.elements.MergeEditorInput;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.WorkbenchImages;

public class ImportModelElementsWizardPage
extends WizardDataTransferPage
implements IImportModelWizardPage {
    private ISourceGroupProvider sourceGroupProvider;
    private Combo modelTypsCombo;
    private Map<String, Control> sourceGroupControls;
    private Map<String, Control> advancedExpandableControls;
    private StackLayout advancedExpandableGroupLayout;
    private StackLayout layout;
    protected CarnotWorkflowModelPackage carnotWorkflowModelPackage = CarnotWorkflowModelPackage.eINSTANCE;
    protected CarnotWorkflowModelFactory carnotWorkflowModelFactory = this.carnotWorkflowModelPackage.getCarnotWorkflowModelFactory();
    private MergeEditorInput input;
    private WorkflowModelManager target;

    public ImportModelElementsWizardPage(String pageId, Object selection) {
        super(pageId);
        if (selection instanceof WorkflowModelManager) {
            this.target = (WorkflowModelManager)selection;
        } else if (selection instanceof IResource) {
            IResource resource = (IResource)selection;
            IPath destinationPath = resource.getFullPath();
            Resource destination = new CarnotWorkflowModelResourceFactoryImpl().createResource(URI.createPlatformResourceURI((String)destinationPath.toString(), (boolean)false));
            this.target = new WorkflowModelManager(destination);
        }
    }

    public WorkflowModelManager getTarget() {
        return this.target;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        try {
            this.getInput();
        }
        catch (Exception exception) {
            return null;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, (IRunnableWithProgress)this.input);
        }
        catch (Exception exception) {}
        if ((dialog.getReturnCode() == 1 || dialog.getProgressMonitor().isCanceled()) && ((WizardDialog)this.getWizard().getContainer()).close()) {
            return null;
        }
        return super.getNextPage();
    }

    public void setVisible(boolean visible) {
        if (!super.getControl().isDisposed()) {
            super.setVisible(visible);
        }
    }

    @Override
    public void updateButtons() {
        if (this.getWizard().getContainer().getCurrentPage() != null) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    @Override
    public IDialogSettings getWizardSettings() {
        return this.getDialogSettings();
    }

    @Override
    public IProject getProjectContext() {
        URI modelURI;
        ModelType model;
        if (this.target != null && (model = this.target.getModel()) != null && (modelURI = model.eResource().getURI()).isPlatformResource()) {
            Path path = new Path(modelURI.toPlatformString(true));
            IFile modelResource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            return modelResource.getProject();
        }
        return null;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createSourceGroup(composite);
        this.createOptionsGroup(composite);
        this.createAdvancedExpandedComposite(composite);
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite);
    }

    protected IPath getResourcePath() {
        URI modelURI;
        ModelType model;
        if (this.target != null && (model = this.target.getModel()) != null && (modelURI = model.eResource().getURI()).isPlatformResource()) {
            Path path = new Path(modelURI.toPlatformString(true));
            return path.makeAbsolute();
        }
        return new Path("");
    }

    protected void createSourceGroup(Composite parent) {
        this.sourceGroupControls = new HashMap<String, Control>();
        Composite sgContainer = new Composite(parent, 0);
        GridData data = new GridData(0);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        sgContainer.setLayoutData((Object)data);
        this.layout = new StackLayout();
        sgContainer.setLayout((Layout)this.layout);
        Map sourceGroupProviders = ImportPlugin.getSourceGroupProviders();
        Set keys = sourceGroupProviders.keySet();
        for (String key : keys) {
            ISourceGroupProvider provider = (ISourceGroupProvider)sourceGroupProviders.get(key);
            Control control = provider.createSourceGroup(sgContainer, this);
            this.sourceGroupControls.put(key, control);
        }
        this.setPageComplete(false);
        this.setTitle(Import_Messages.LB_Select);
        this.setDescription(Import_Messages.DESC_CarnotFileImport);
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_IMPORT_WIZ"));
    }

    private void createAdvancedExpandedComposite(Composite parent) {
        Composite advancedComp = new Composite(parent, 0);
        GridData data = new GridData(0);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        advancedComp.setLayoutData((Object)data);
        this.advancedExpandableGroupLayout = new StackLayout();
        this.advancedExpandableGroupLayout.marginHeight = 5;
        advancedComp.setLayout((Layout)this.advancedExpandableGroupLayout);
        this.advancedExpandableControls = new HashMap<String, Control>();
        Map sourceGroupProviders = ImportPlugin.getSourceGroupProviders();
        Set keys = sourceGroupProviders.keySet();
        for (String key : keys) {
            ISourceGroupProvider provider = (ISourceGroupProvider)sourceGroupProviders.get(key);
            Control control = provider.createAdvancedExpandableControl(advancedComp, this);
            if (control == null) continue;
            this.advancedExpandableControls.put(key, control);
        }
        this.onModelTypeSelection();
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.createModelTypeOptions((Composite)optionsGroup);
    }

    private void createModelTypeOptions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label modelTypsComboLabel = new Label(composite, 0);
        modelTypsComboLabel.setText(Import_Messages.LB_ModelTypes);
        this.modelTypsCombo = new Combo(composite, 8);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                this.widgetDefaultSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ImportModelElementsWizardPage.this.onModelTypeSelection();
            }
        };
        this.modelTypsCombo.addSelectionListener(listener);
        Map extensions = ImportPlugin.getExtensions();
        IConfigurationElement firstConfig = (IConfigurationElement)extensions.get("File");
        this.modelTypsCombo.add(firstConfig.getAttribute("name"));
        for (IConfigurationElement config : extensions.values()) {
            if (config.equals((Object)firstConfig)) continue;
            this.modelTypsCombo.add(config.getAttribute("name"));
        }
        this.modelTypsCombo.select(0);
    }

    public boolean isPageComplete() {
        boolean pageIsValid = true;
        if (this.sourceGroupProvider != null && !this.sourceGroupProvider.isComplete()) {
            pageIsValid = false;
        }
        if (this.sourceGroupProvider != null && this.sourceGroupProvider.isComplete()) {
            pageIsValid = this.isValidResource();
        }
        if (this.getResourcePath() == null) {
            pageIsValid = false;
        }
        return pageIsValid;
    }

    private void onModelTypeSelection() {
        String selectionIds = this.modelTypsCombo.getText();
        for (String key : this.sourceGroupControls.keySet()) {
            Control sourceGroupControl = this.sourceGroupControls.get(key);
            Control advancedExpandableControl = this.advancedExpandableControls.get(key);
            if (key.equals(selectionIds)) {
                sourceGroupControl.setVisible(true);
                this.sourceGroupProvider = (ISourceGroupProvider)ImportPlugin.getSourceGroupProviders().get(key);
                this.layout.topControl = sourceGroupControl;
                if (advancedExpandableControl == null) continue;
                advancedExpandableControl.setVisible(true);
                this.advancedExpandableGroupLayout.topControl = advancedExpandableControl;
                continue;
            }
            sourceGroupControl.setVisible(false);
            if (advancedExpandableControl == null) continue;
            advancedExpandableControl.setVisible(false);
        }
        this.updateButtons();
    }

    public ISourceGroupProvider getSourceGroupProvider() {
        return this.sourceGroupProvider;
    }

    public MergeEditorInput getInput() {
        if (this.input == null) {
            this.input = new MergeEditorInput(this);
        }
        this.prepareInput();
        return this.input;
    }

    private boolean isValidResource() {
        WorkflowModelManager manager = new WorkflowModelManager();
        Resource resource = this.sourceGroupProvider.getExternalResource();
        try {
            manager.load(resource.getURI());
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void prepareInput() {
        Resource source = this.sourceGroupProvider.getExternalResource();
        this.input.setSource(new WorkflowModelManager(source));
        this.input.setTarget(this.target);
    }

    @Override
    public boolean performFinish() {
        return false;
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    public void handleEvent(Event event) {
    }
}

