/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.adapters;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.cap.NameIdDialog;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CommandUtils;
import org.eclipse.stardust.modeling.repository.common.ImportCancelledException;
import org.eclipse.stardust.modeling.templates.Templates_Messages;
import org.eclipse.stardust.modeling.templates.spi.ITemplate;

public class TemplateContentAdapter
extends EContentAdapter {
    private static CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private ModelType targetModel;
    private Map nameIdCache = new HashMap();
    private Map changedCache = new HashMap();
    private Map dataRefCache = new HashMap();
    private String templateID;
    private List symbols = new ArrayList();

    public TemplateContentAdapter(ModelType targetModel, ITemplate template) {
        this.targetModel = targetModel;
        this.templateID = String.valueOf(template.getId()) + "-" + ModelUtils.getMaxUsedOid((ModelType)targetModel);
        this.collectTargetData(this.targetModel);
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        EObject container = (EObject)notification.getNotifier();
        if (notification.getEventType() == 5) {
            List list = (List)notification.getNewValue();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this.performConsistencyCheck((EObject)i.next(), container);
            }
        }
        if (notification.getEventType() == 3 && notification.getNewValue() instanceof EObject) {
            EObject element = (EObject)notification.getNewValue();
            this.performConsistencyCheck(element, container);
        }
    }

    private void performConsistencyCheck(EObject element, EObject container) {
        RoleType roleType;
        ActivityType activityType;
        IModelParticipant performer;
        if (element instanceof INodeSymbol && !(container instanceof RoleType) && element.eContainer() != null) {
            this.symbols.add(element);
        }
        if (element instanceof ActivityType && (performer = (activityType = (ActivityType)element).getPerformer()) != null && (roleType = (RoleType)ModelUtils.findElementById((List)this.targetModel.getRole(), (String)performer.getId())) != null) {
            activityType.setPerformer((IModelParticipant)roleType);
        }
        if (this.checkElementInModel(container, element)) {
            if (element instanceof TransitionType) {
                EClass eClass = PKG.getTransitionType();
                IdFactory idFactory = new IdFactory(Diagram_Messages.ID_TransitionConnection, Diagram_Messages.BASENAME_Transition);
                List list = (List)container.eGet(this.getContainingFeature(eClass, container));
                idFactory.computeNames(list);
                ((IIdentifiableElement)element).setId(idFactory.getId());
                ((IIdentifiableElement)element).setName(idFactory.getName());
                if (idFactory.getReferingElement() == null) {
                    idFactory.setReferingElement((IIdentifiableModelElement)element);
                }
                return;
            }
            if (element instanceof TypeDeclarationType) {
                String orgName = ((TypeDeclarationType)element).getName();
                ((TypeDeclarationType)element).setName(MessageFormat.format(Templates_Messages.TXT_COPY_OF, orgName));
                ((TypeDeclarationType)element).setId(MessageFormat.format(Templates_Messages.TXT_COPY_OF, orgName));
                this.dataRefCache.put(orgName, ((TypeDeclarationType)element).getName());
            } else {
                this.openDialog(container, element);
                if (element instanceof DataType) {
                    String type = AttributeUtil.getAttributeValue((IExtensibleElement)((DataType)element), (String)"carnot:engine:dataType");
                    String newType = (String)this.dataRefCache.get(type);
                    AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:dataType", (String)newType);
                }
            }
        }
    }

    private void collectTargetData(ModelType model) {
        TreeIterator i = model.eAllContents();
        while (i.hasNext()) {
            String name;
            String id;
            EObject child = (EObject)i.next();
            EClass eClass = child.eClass();
            EObject parent = child.eContainer();
            HashMap eClassNameIdCache = new HashMap();
            Object localNameIdCache = null;
            if (this.nameIdCache.containsKey(parent) && (eClassNameIdCache = (HashMap)this.nameIdCache.get(parent)).containsKey(eClass)) {
                localNameIdCache = child instanceof DiagramType ? (List)eClassNameIdCache.get(eClass) : (HashMap)eClassNameIdCache.get(eClass);
            }
            if (localNameIdCache == null) {
                localNameIdCache = child instanceof DiagramType ? new ArrayList() : new HashMap();
            }
            if (child instanceof IIdentifiableElement) {
                id = ((IIdentifiableElement)child).getId();
                name = ((IIdentifiableElement)child).getName();
                ((HashMap)localNameIdCache).put(id, name);
                eClassNameIdCache.put(eClass, localNameIdCache);
            } else if (child instanceof IModelElement) {
                if (child instanceof DiagramType) {
                    name = ((DiagramType)child).getName();
                    ((ArrayList)localNameIdCache).add(name);
                    eClassNameIdCache.put(eClass, localNameIdCache);
                }
            } else if (child instanceof TypeDeclarationType) {
                id = ((TypeDeclarationType)child).getId();
                name = ((TypeDeclarationType)child).getName();
                ((HashMap)localNameIdCache).put(id, name);
                eClassNameIdCache.put(eClass, localNameIdCache);
            }
            this.nameIdCache.put(parent, eClassNameIdCache);
        }
    }

    private boolean checkElementInModel(EObject targetContainer, EObject element) {
        EClass eClass = element.eClass();
        EObject parent = targetContainer;
        EObject checkParent = (EObject)this.changedCache.get(parent);
        if (checkParent != null) {
            parent = checkParent;
        }
        HashMap eClassNameIdCache = new HashMap();
        HashMap localNameIdCache = null;
        if (this.nameIdCache.containsKey(parent) && (eClassNameIdCache = (HashMap)this.nameIdCache.get(parent)).containsKey(eClass)) {
            if (element instanceof IIdentifiableElement) {
                String id = ((IIdentifiableElement)element).getId();
                String name = ((IIdentifiableElement)element).getName();
                localNameIdCache = (HashMap)eClassNameIdCache.get(eClass);
                if (localNameIdCache.containsKey(id) || localNameIdCache.containsValue(name)) {
                    return true;
                }
            } else if (element instanceof TypeDeclarationType) {
                String id = ((TypeDeclarationType)element).getId();
                String name = ((TypeDeclarationType)element).getName();
                localNameIdCache = (HashMap)eClassNameIdCache.get(eClass);
                if (localNameIdCache.containsKey(id) || localNameIdCache.containsValue(name)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean openDialog(EObject parent, EObject element) {
        String name;
        EClass eClass = element.eClass();
        HashMap eClassNameIdCache = new HashMap();
        HashMap localNameIdCache = null;
        eClassNameIdCache = (HashMap)this.nameIdCache.get(parent);
        String id = ((IIdentifiableElement)element).getId();
        NameIdDialog nameIdDialog = new NameIdDialog(null, id, name = ((IIdentifiableElement)element).getName(), (Map)(localNameIdCache = (HashMap)eClassNameIdCache.get(eClass)));
        if (nameIdDialog.open() == 0) {
            ((IIdentifiableElement)element).setId(nameIdDialog.getId());
            ((IIdentifiableElement)element).setName(nameIdDialog.getName());
            localNameIdCache.put(nameIdDialog.getId(), nameIdDialog.getName());
            eClassNameIdCache.put(eClass, localNameIdCache);
            this.nameIdCache.put(parent, eClassNameIdCache);
            return true;
        }
        throw new ImportCancelledException();
    }

    private EStructuralFeature getContainingFeature(EClass eClass, EObject container) {
        EList containingFeatureList = container.eClass().getEStructuralFeatures();
        return CommandUtils.findContainmentFeature((List)containingFeatureList, (EClass)eClass);
    }

    public List getAddedSymbols() {
        return this.symbols;
    }
}

