/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.defaulttemplate;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CommandUtils;
import org.eclipse.stardust.modeling.templates.Templates_Messages;
import org.eclipse.stardust.modeling.templates.spi.ITemplateFactory;
import org.osgi.framework.Bundle;

public class TemplateHelper {
    private static CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private static CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
    private ModelType model;
    private DiagramType diagram;
    private ProcessDefinitionType process;
    private EditPart editPart;

    public TemplateHelper(ModelType model, DiagramType diagram, ProcessDefinitionType process, EditPart editPart) {
        this.model = model;
        this.diagram = diagram;
        this.process = process;
        this.editPart = editPart;
    }

    public TransitionType createTransition(String name) {
        IdFactory idFactory = new IdFactory(Diagram_Messages.ID_TransitionConnection, Diagram_Messages.BASENAME_Transition);
        EClass eClass = PKG.getTransitionType();
        TransitionType transition = (TransitionType)this.createModelElement(idFactory, eClass, (EObject)this.process);
        this.process.getTransition().add((Object)transition);
        this.addModelElement(this.getContainingFeature(eClass, (EObject)this.process), (IModelElement)transition, (EObject)this.process);
        return transition;
    }

    public ActivityType createActivity(String name, String kind) {
        IdFactory idFactory = null;
        ActivityImplementationType implType = null;
        if (kind.equals(Templates_Messages.ROUTE_ACTIVITY)) {
            implType = ActivityImplementationType.ROUTE_LITERAL;
        }
        if (kind.equals(Templates_Messages.APPLICATION_ACTIVITY)) {
            implType = ActivityImplementationType.APPLICATION_LITERAL;
        }
        if (kind.equals(Templates_Messages.MANUAL_ACTIVITY)) {
            implType = ActivityImplementationType.MANUAL_LITERAL;
        }
        idFactory = new IdFactory(Diagram_Messages.ID_Activity, String.valueOf(ModelUtils.getActivityImplementationTypeText((ActivityImplementationType)implType)) + Diagram_Messages.BASENAME_Activity);
        EClass eClass = PKG.getActivityType();
        ActivityType activity = (ActivityType)this.createModelElement(idFactory, eClass, (EObject)this.process);
        activity.setImplementation(implType);
        this.process.getActivity().add((Object)activity);
        this.addModelElement(this.getContainingFeature(eClass, (EObject)this.process), (IModelElement)activity, (EObject)this.process);
        return activity;
    }

    public IModelElement createModelElement(IdFactory idFactory, EClass eClass, EObject container) {
        IModelElement modelElement = (IModelElement)factory.create(eClass);
        modelElement.setElementOid(ModelUtils.getElementOid((IModelElement)modelElement, (ModelType)this.model));
        if (modelElement instanceof IIdentifiableModelElement && idFactory != null) {
            List list = (List)container.eGet(this.getContainingFeature(eClass, container));
            idFactory.computeNames(list);
            ((IIdentifiableElement)modelElement).setId(idFactory.getId());
            ((IIdentifiableElement)modelElement).setName(idFactory.getName());
            if (idFactory.getReferingElement() == null) {
                idFactory.setReferingElement((IIdentifiableModelElement)modelElement);
            }
        }
        return modelElement;
    }

    public EStructuralFeature getContainingFeature(EClass eClass, EObject container) {
        EList containingFeatureList = container.eClass().getEStructuralFeatures();
        return CommandUtils.findContainmentFeature((List)containingFeatureList, (EClass)eClass);
    }

    public void addModelElement(EStructuralFeature feature, IModelElement modelElement, EObject container) {
        List list = (List)container.eGet(feature);
        list.add(modelElement);
    }

    public ActivitySymbolType createActivitySymbol(ActivityType activity, int x, int y) {
        EClass eClass = PKG.getActivitySymbolType();
        PoolSymbol container = DiagramUtil.getDefaultPool((DiagramType)this.diagram);
        ActivitySymbolType symbol = (ActivitySymbolType)this.createModelElement(null, eClass, (EObject)container);
        symbol.setActivity(activity);
        this.addSymbol((ISymbolContainer)container, (IGraphicalObject)symbol);
        symbol.setXPos((long)x);
        symbol.setYPos((long)y);
        return symbol;
    }

    public TransitionConnectionType createTransitionSymbol(TransitionType transition) {
        EClass eClass = PKG.getTransitionConnectionType();
        PoolSymbol container = DiagramUtil.getDefaultPool((DiagramType)this.diagram);
        TransitionConnectionType symbol = (TransitionConnectionType)this.createModelElement(null, eClass, (EObject)container);
        if (transition != null) {
            symbol.setTransition(transition);
        }
        this.addTransitionSymbol((ISymbolContainer)container, (IGraphicalObject)symbol);
        return symbol;
    }

    public GatewaySymbol createGatewaySymbol(ActivitySymbolType activity, FlowControlType flowControlType) {
        EClass eClass = PKG.getGatewaySymbol();
        PoolSymbol container = DiagramUtil.getDefaultPool((DiagramType)this.diagram);
        GatewaySymbol symbol = (GatewaySymbol)this.createModelElement(null, eClass, (EObject)container);
        symbol.setFlowKind(flowControlType);
        symbol.setActivitySymbol(activity);
        this.addSymbol((ISymbolContainer)container, (IGraphicalObject)symbol);
        return symbol;
    }

    public void addSymbol(ISymbolContainer container, IGraphicalObject symbol) {
        if (this.editPart.getModel() != null && this.editPart.getModel() instanceof ISymbolContainer) {
            container = (ISymbolContainer)this.editPart.getModel();
        }
        EStructuralFeature feature = CommandUtils.findContainmentFeature((List)container.getNodeContainingFeatures(), (IGraphicalObject)symbol);
        EList symbolContainment = (EList)container.eGet(feature);
        if (!symbol.isSetElementOid()) {
            symbol.setElementOid(ModelUtils.getElementOid((IModelElement)symbol, (ModelType)this.model));
        }
        symbolContainment.add((Object)symbol);
    }

    public void addTransitionSymbol(ISymbolContainer container, IGraphicalObject symbol) {
        EStructuralFeature feature = CommandUtils.findContainmentFeature((List)container.getConnectionContainingFeatures(), (IGraphicalObject)symbol);
        EList symbolContainment = (EList)container.eGet(feature);
        if (!symbol.isSetElementOid()) {
            symbol.setElementOid(ModelUtils.getElementOid((IModelElement)symbol, (ModelType)this.model));
        }
        symbolContainment.add((Object)symbol);
    }

    public static String readDescriptionFromBundle(String nlBundleID, String htmlFileName, ITemplateFactory templateFactory) {
        try {
            InputStream in;
            String path;
            String nl = Platform.getNL();
            Bundle bundle = Platform.getBundle((String)nlBundleID);
            if (bundle != null && bundle.getEntry(path = "/html/" + nl + "/" + htmlFileName) != null && (in = bundle.getEntry(path).openStream()) != null) {
                return TemplateHelper.streamToText(in);
            }
            return TemplateHelper.readResourceToString("/html/" + htmlFileName, templateFactory);
        }
        catch (Throwable throwable) {
            return "No description provided.";
        }
    }

    public static String readResourceToString(String path, ITemplateFactory templateFactory) throws Throwable {
        InputStream in = templateFactory.getClass().getResourceAsStream(path);
        return TemplateHelper.streamToText(in);
    }

    public static String streamToText(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }
}

