/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.emf.template.impl;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.stardust.modeling.templates.Templates_Messages;
import org.eclipse.stardust.modeling.templates.emf.template.DocumentationType;
import org.eclipse.stardust.modeling.templates.emf.template.FeatureStyleType;
import org.eclipse.stardust.modeling.templates.emf.template.FeatureType;
import org.eclipse.stardust.modeling.templates.emf.template.ParameterType;
import org.eclipse.stardust.modeling.templates.emf.template.ReferenceType;
import org.eclipse.stardust.modeling.templates.emf.template.RootsType;
import org.eclipse.stardust.modeling.templates.emf.template.ScopeType;
import org.eclipse.stardust.modeling.templates.emf.template.StyleType;
import org.eclipse.stardust.modeling.templates.emf.template.TemplateFactory;
import org.eclipse.stardust.modeling.templates.emf.template.TemplateLibraryType;
import org.eclipse.stardust.modeling.templates.emf.template.TemplatePackage;
import org.eclipse.stardust.modeling.templates.emf.template.TemplateType;
import org.eclipse.stardust.modeling.templates.emf.template.TemplatesType;
import org.eclipse.stardust.modeling.templates.emf.template.impl.DocumentationTypeImpl;
import org.eclipse.stardust.modeling.templates.emf.template.impl.FeatureTypeImpl;
import org.eclipse.stardust.modeling.templates.emf.template.impl.ParameterTypeImpl;
import org.eclipse.stardust.modeling.templates.emf.template.impl.ReferenceTypeImpl;
import org.eclipse.stardust.modeling.templates.emf.template.impl.RootsTypeImpl;
import org.eclipse.stardust.modeling.templates.emf.template.impl.TemplateLibraryTypeImpl;
import org.eclipse.stardust.modeling.templates.emf.template.impl.TemplateTypeImpl;
import org.eclipse.stardust.modeling.templates.emf.template.impl.TemplatesTypeImpl;

public class TemplateFactoryImpl
extends EFactoryImpl
implements TemplateFactory {
    public static TemplateFactory init() {
        try {
            TemplateFactory theTemplateFactory = (TemplateFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.carnot.ag/workflowmodel/templates");
            if (theTemplateFactory != null) {
                return theTemplateFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new TemplateFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDocumentationType();
            }
            case 1: {
                return this.createFeatureType();
            }
            case 2: {
                return this.createParameterType();
            }
            case 3: {
                return this.createReferenceType();
            }
            case 4: {
                return this.createRootsType();
            }
            case 5: {
                return this.createTemplateType();
            }
            case 6: {
                return this.createTemplatesType();
            }
            case 7: {
                return this.createTemplateLibraryType();
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Templates_Messages.The_class_is_not_a_valid_classifier, eClass.getName()));
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.createFeatureStyleTypeFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createScopeTypeFromString(eDataType, initialValue);
            }
            case 10: {
                return this.createStyleTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Templates_Messages.The_datatype_is_not_a_valid_classifier, eDataType.getName()));
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.convertFeatureStyleTypeToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertScopeTypeToString(eDataType, instanceValue);
            }
            case 10: {
                return this.convertStyleTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Templates_Messages.The_datatype_is_not_a_valid_classifier, eDataType.getName()));
    }

    @Override
    public DocumentationType createDocumentationType() {
        DocumentationTypeImpl documentationType = new DocumentationTypeImpl();
        return documentationType;
    }

    @Override
    public FeatureType createFeatureType() {
        FeatureTypeImpl featureType = new FeatureTypeImpl();
        return featureType;
    }

    @Override
    public ParameterType createParameterType() {
        ParameterTypeImpl parameterType = new ParameterTypeImpl();
        return parameterType;
    }

    @Override
    public ReferenceType createReferenceType() {
        ReferenceTypeImpl referenceType = new ReferenceTypeImpl();
        return referenceType;
    }

    @Override
    public RootsType createRootsType() {
        RootsTypeImpl rootsType = new RootsTypeImpl();
        return rootsType;
    }

    @Override
    public TemplateType createTemplateType() {
        TemplateTypeImpl templateType = new TemplateTypeImpl();
        return templateType;
    }

    @Override
    public TemplatesType createTemplatesType() {
        TemplatesTypeImpl templatesType = new TemplatesTypeImpl();
        return templatesType;
    }

    @Override
    public TemplateLibraryType createTemplateLibraryType() {
        TemplateLibraryTypeImpl templateLibraryType = new TemplateLibraryTypeImpl();
        return templateLibraryType;
    }

    public FeatureStyleType createFeatureStyleTypeFromString(EDataType eDataType, String initialValue) {
        FeatureStyleType result = FeatureStyleType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException(MessageFormat.format(Templates_Messages.The_value_is_not_a_valid_enumerator_of, initialValue, eDataType.getName()));
        }
        return result;
    }

    public String convertFeatureStyleTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ScopeType createScopeTypeFromString(EDataType eDataType, String initialValue) {
        ScopeType result = ScopeType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException(MessageFormat.format(Templates_Messages.The_value_is_not_a_valid_enumerator_of, initialValue, eDataType.getName()));
        }
        return result;
    }

    public String convertScopeTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public StyleType createStyleTypeFromString(EDataType eDataType, String initialValue) {
        StyleType result = StyleType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException(MessageFormat.format(Templates_Messages.The_value_is_not_a_valid_enumerator_of, initialValue, eDataType.getName()));
        }
        return result;
    }

    public String convertStyleTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public TemplatePackage getTemplatePackage() {
        return (TemplatePackage)this.getEPackage();
    }

    @Deprecated
    public static TemplatePackage getPackage() {
        return TemplatePackage.eINSTANCE;
    }
}

