/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets;

import java.util.Map;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.FieldMapping;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.MessageTransformationModelingPlugin;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.breakpoints.MessageBreakpointManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class IndexingLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final Image primitiveImage = MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/primitive_data.gif").createImage();
    private static final Image legoImage = MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/lego_icon.gif").createImage();
    private static final Image primitiveBpImage = MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/primitive_data_bp.png").createImage();
    private static final Image legoBpImage = MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/lego_icon_bp.png").createImage();
    private static final Image errorImage = MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/error_tsk.gif").createImage();
    private static final Image serializableImage = MessageTransformationModelingPlugin.getDefault().getImageDescriptor("icons/serializable_data.gif").createImage();
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_INDEX = 1;
    private static final int COLUMN_MAPPING = 2;
    private static final int COLUMN_ERROR_IMAGE = 3;
    private FontRegistry fontRegistry = new FontRegistry();
    private MessageTransformationController controller;
    private final MessageBreakpointManager breakpointManager;
    private Map<String, String> indexMap;
    private String xPath;

    public IndexingLabelProvider(MessageTransformationController controller, Map<String, String> indexMap, String xPath) {
        this.controller = controller;
        this.breakpointManager = new MessageBreakpointManager();
        this.indexMap = indexMap;
        this.xPath = xPath;
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof AccessPointType) {
            boolean valid;
            FieldMapping fm;
            AccessPointType messageType;
            if (columnIndex == 0) {
                boolean breakpointAvailable;
                AccessPointType messageType2 = (AccessPointType)element;
                FieldMapping fm2 = this.controller.getFieldMappings().get(this.controller.getXPathFor(messageType2));
                boolean bl = breakpointAvailable = fm2 == null ? false : this.breakpointManager.isBreakpointAvailable(fm2.getFieldPath());
                if (this.controller.isSerializable(messageType2)) {
                    return breakpointAvailable ? legoBpImage : serializableImage;
                }
                if (this.controller.isRoot(messageType2) && this.controller.isSerializable(messageType2)) {
                    return breakpointAvailable ? legoBpImage : serializableImage;
                }
                if ((this.controller.isRoot(messageType2) || this.controller.isComplexType(messageType2)) & !this.controller.isPrimitive(messageType2)) {
                    return breakpointAvailable ? legoBpImage : legoImage;
                }
                return breakpointAvailable ? primitiveBpImage : primitiveImage;
            }
            if (!(3 != columnIndex || this.controller.isRoot(messageType = (AccessPointType)element) && !this.controller.isPrimitive(messageType) || (fm = this.controller.getFieldMappings().get(this.controller.getXPathFor(messageType))) == null || (valid = this.controller.validateMapping(fm, false)))) {
                return errorImage;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (element instanceof AccessPointType) {
                    AccessPointType messageType = (AccessPointType)element;
                    String displayString = messageType.getId();
                    if (displayString.startsWith("@")) {
                        displayString = displayString.replace("@", "");
                    }
                    return displayString;
                }
            }
            case 1: {
                AccessPointType messageElement = (AccessPointType)element;
                if (this.controller.isList(messageElement)) {
                    AccessPointType apt = messageElement;
                    String xPath = this.controller.getXPathFor(apt);
                    String index = this.indexMap.get(xPath);
                    if (index != null) {
                        return "[" + index + "]";
                    }
                    return "[0]";
                }
                return "";
            }
            case 2: {
                if (!(element instanceof AccessPointType)) break;
                AccessPointType messageType = (AccessPointType)element;
                String xPath = this.controller.getXPathFor(messageType);
                FieldMapping fieldMapping = this.controller.getFieldMappings().get(xPath);
                if (fieldMapping == null || fieldMapping.getMappingExpression() == null) break;
                String text = fieldMapping.getMappingExpression();
                text = text.replace('\n', ' ');
                return text;
            }
        }
        return "";
    }

    public Font getFont(Object element, int columnIndex) {
        AccessPointType messageType;
        Font font = Display.getCurrent().getSystemFont();
        if (element instanceof AccessPointType && this.xPath.startsWith(this.controller.getXPathFor(messageType = (AccessPointType)element))) {
            font = this.fontRegistry.getBold(Display.getCurrent().getSystemFont().getFontData()[0].getName());
        }
        return font;
    }
}

