/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.modeling.externalwebapp.spi.context;

import org.eclipse.stardust.engine.extensions.transformation.model.mapping.FieldMapping;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IApplicationPropertyPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationApplicationControlsManager;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class InputOutputApplicationPropertyPage
extends AbstractModelElementPropertyPage
implements IApplicationPropertyPage {
    IModelElementNodeSymbol defaultSymbol;
    IModelElement defaultModelElement;
    private final MessageTransformationApplicationControlsManager controlsManager = new MessageTransformationApplicationControlsManager();

    public void dispose() {
        this.controlsManager.dispose();
        super.dispose();
    }

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        IEditorPart currentEditor;
        this.defaultSymbol = symbol;
        this.defaultModelElement = element;
        ModelType model = null;
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (currentEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) instanceof WorkflowModelEditor) {
            model = ((WorkflowModelEditor)currentEditor).getWorkflowModel();
        }
        MessageTransformationController controller = this.controlsManager.getController();
        controller.intializeModel(model, symbol, element);
        this.controlsManager.refreshModel();
        controller.initializeMappings(element);
        this.controlsManager.getSourceMessageTreeViewer().refresh(true);
        this.controlsManager.getTargetMessageTreeViewer().refresh(true);
        this.controlsManager.refreshDocument();
        if (controller.getAvailableMessageTypes().isEmpty()) {
            this.setErrorMessage(Modeling_Messages.ERR_MODEL_DOES_NOT_CONTAIN_ANY_STRUCT_DATA);
        }
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        this.controlsManager.getController().saveFields(symbol, element);
    }

    public Control createBody(Composite parent) {
        return this.controlsManager.create(parent, (IModelElement)this.getModelElement(), true, true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.clearMappingStatements();
        this.controlsManager.getController().reset();
        this.loadFieldsFromElement(this.defaultSymbol, this.defaultModelElement);
    }

    private void clearMappingStatements() {
        for (FieldMapping fm : this.controlsManager.getController().getFieldMappings().values()) {
            fm.setMappingExpression("");
        }
        this.controlsManager.getTargetMessageTreeViewer().refresh(true);
    }
}

