/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.engine.core.model.utils.ExclusionComputer;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class DefaultProcessDefinitionValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        List result = CollectionUtils.newList();
        if (element instanceof ProcessDefinitionType) {
            AttributeType auditTrailPersistenceAttribute;
            ProcessDefinitionType proc = (ProcessDefinitionType)element;
            if (this.findDuplicateId(proc)) {
                result.add(Issue.error((EObject)proc, Validation_Messages.MSG_DuplicateProcessDefinitionId, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
            }
            ActivityType startActivity = null;
            String otherStartActivities = null;
            for (ActivityType activity : proc.getActivity()) {
                if (!activity.getInTransitions().isEmpty()) continue;
                if (startActivity == null) {
                    startActivity = activity;
                    continue;
                }
                otherStartActivities = otherStartActivities == null ? MessageFormat.format("\"{0}\", \"{1}\"", startActivity.getId(), activity.getId()) : MessageFormat.format(", \"{0}\"", activity.getId());
            }
            if (startActivity == null) {
                result.add(Issue.error((EObject)proc, Validation_Messages.MSG_NoStartActivity));
            }
            if (otherStartActivities != null) {
                result.add(Issue.error((EObject)proc, MessageFormat.format(Validation_Messages.MSG_MultipleSartActivities, otherStartActivities)));
            }
            if (proc.getActivity().isEmpty()) {
                result.add(Issue.error((EObject)proc, Validation_Messages.MSG_NoActivity));
            }
            if (startActivity != null) {
                Set allActivities = CollectionUtils.newSet();
                allActivities.addAll(proc.getActivity());
                LinkedList reachedActivities = CollectionUtils.newLinkedList();
                Set visitedActivities = CollectionUtils.newSet();
                reachedActivities.add(startActivity);
                while (!reachedActivities.isEmpty()) {
                    ActivityType activity = (ActivityType)reachedActivities.remove(0);
                    if (visitedActivities.contains(activity)) continue;
                    visitedActivities.add(activity);
                    for (TransitionType transition : activity.getOutTransitions()) {
                        if (visitedActivities.contains(transition.getTo())) continue;
                        reachedActivities.add(transition.getTo());
                    }
                }
                allActivities.removeAll(visitedActivities);
                if (!allActivities.isEmpty()) {
                    result.add(Issue.error((EObject)proc, MessageFormat.format(Validation_Messages.MSG_PROCDEF_DisconnectedActivityGraph, new Integer(allActivities.size()))));
                } else {
                    this.checkForDeadlocks(result, proc);
                }
            }
            if ((auditTrailPersistenceAttribute = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:auditTrailPersistence")) != null) {
                String auditTrailPersistence = auditTrailPersistenceAttribute.getValue();
                ArrayList options = ModelUtils.getPersistenceOptions((ProcessDefinitionType)((ProcessDefinitionType)element));
                if (!options.contains(auditTrailPersistence)) {
                    result.add(Issue.warning((EObject)proc, MessageFormat.format(Validation_Messages.MSG_PERSISTENCE_OPTION_NOT_ALLOWED, ModelUtils.getPersistenceOptionsText((String)auditTrailPersistence))));
                }
            }
            ValidationService vs = ValidationService.getInstance();
            result.addAll(Arrays.asList(vs.validateModelElements((List<?>)proc.getTrigger())));
            result.addAll(Arrays.asList(vs.validateModelElements((List<?>)proc.getActivity())));
            result.addAll(Arrays.asList(vs.validateModelElements((List<?>)proc.getTransition())));
            result.addAll(Arrays.asList(vs.validateModelElements((List<?>)proc.getEventHandler())));
            result.addAll(Arrays.asList(vs.validateModelElements((List<?>)proc.getDataPath())));
            result.addAll(Arrays.asList(vs.validateModelElements((List<?>)proc.getDiagram())));
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private void checkForDeadlocks(List<Issue> result, ProcessDefinitionType proc) {
        ExclusionComputer<ActivityType, TransitionType> computer = new ExclusionComputer<ActivityType, TransitionType>(){

            protected ActivityType getFrom(TransitionType transition) {
                return transition.getFrom();
            }

            protected ActivityType getTo(TransitionType transition) {
                return transition.getTo();
            }

            protected Iterable<TransitionType> getIn(ActivityType activity) {
                return activity.getInTransitions();
            }

            protected boolean isInclusiveJoin(ActivityType activity) {
                return activity.getJoin() == JoinSplitType.AND_LITERAL || activity.getJoin() == JoinSplitType.OR_LITERAL;
            }
        };
        for (ActivityType activity : proc.getActivity()) {
            ActivityType blockingActivity = (ActivityType)computer.getBlockingActivity((Object)activity);
            if (blockingActivity == null || activity.getId().compareTo(blockingActivity.getId()) >= 0) continue;
            result.add(Issue.warning((EObject)proc, MessageFormat.format(Validation_Messages.Msg_PotentialDeadlock, activity.getName(), blockingActivity.getName()), ValidationService.PKG_CWM.getProcessDefinitionType()));
        }
    }

    private boolean findDuplicateId(ProcessDefinitionType proc) {
        ModelType model = ModelUtils.findContainingModel((EObject)proc);
        for (ProcessDefinitionType otherProc : model.getProcessDefinition()) {
            if (!otherProc.getId().equals(proc.getId()) || proc.equals(otherProc)) continue;
            return true;
        }
        return false;
    }
}

