/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.services.filetransfer;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.interfaces.filetransfer.IFileTransferItem;

public class FileTransferItem
extends PropertiesContainer
implements IFileTransferItem {
    public FileTransferItem() {
        this.setProperty("enabled", true);
        this.setProperty("direction", "1");
    }

    public FileTransferItem(IPath fromHost, boolean enabled) {
        this();
        if (fromHost != null) {
            this.setProperty("host", fromHost.toPortableString());
        }
        this.setProperty("enabled", enabled);
    }

    public FileTransferItem(IPath fromHost, IPath toTarget) {
        this();
        if (fromHost != null) {
            this.setProperty("host", fromHost.toPortableString());
        }
        if (toTarget != null) {
            this.setProperty("target", toTarget.toPortableString());
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getBooleanProperty("enabled");
    }

    @Override
    public IPath getHostPath() {
        return this.getStringProperty("host") != null ? new Path(this.getStringProperty("host")) : null;
    }

    @Override
    public IPath getTargetPath() {
        return this.getStringProperty("target") != null ? new Path(this.getStringProperty("target")) : null;
    }

    @Override
    public int getDirection() {
        int direction = this.getIntProperty("direction");
        return direction == 2 ? 2 : 1;
    }

    @Override
    public String getOptions() {
        return this.getStringProperty("options");
    }

    public int hashCode() {
        int hc = this.getHostPath() != null ? this.getHostPath().hashCode() : 0;
        hc <<= 8 + (this.getTargetPath() != null ? this.getTargetPath().hashCode() : 0);
        return hc <<= 8 + this.getDirection();
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (!equals && obj instanceof IFileTransferItem) {
            boolean directionEqual;
            boolean hostPathEqual;
            boolean bl = this.getHostPath() != null ? this.getHostPath().equals((Object)((IFileTransferItem)obj).getHostPath()) : (hostPathEqual = ((IFileTransferItem)obj).getHostPath() == null);
            boolean targetPathEqual = this.getTargetPath() != null ? this.getTargetPath().equals((Object)((IFileTransferItem)obj).getTargetPath()) : ((IFileTransferItem)obj).getTargetPath() == null;
            boolean bl2 = directionEqual = this.getDirection() == ((IFileTransferItem)obj).getDirection();
            return hostPathEqual && targetPathEqual && directionEqual;
        }
        return equals;
    }
}

