/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper.steps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtension;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStep;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.nls.Messages;

public abstract class AbstractStep
extends ExecutableExtension
implements IStep {
    private final List<String> dependencies = new ArrayList<String>();
    private Map<String, String> parameters = new HashMap<String, String>();

    @Override
    public boolean isSingleton() {
        return false;
    }

    public void doSetInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        IConfigurationElement[] requires;
        super.doSetInitializationData(config, propertyName, data);
        this.dependencies.clear();
        IConfigurationElement[] iConfigurationElementArray = requires = config.getChildren("requires");
        int n = requires.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement require = iConfigurationElementArray[n2];
            String value = require.getAttribute("id");
            if (value == null || value.trim().length() == 0) {
                throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), 0, NLS.bind((String)Messages.AbstractStep_error_missingRequiredAttribute, (Object)"dependency id (requires)", (Object)this.getLabel()), null));
            }
            if (!this.dependencies.contains(value.trim())) {
                this.dependencies.add(value.trim());
            }
            ++n2;
        }
    }

    @Override
    public void initializeFrom(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        Assert.isNotNull((Object)monitor);
    }

    @Override
    public void cleanup(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) {
    }

    @Override
    public void rollback(IStepContext context, IPropertiesContainer data, IStatus status, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, ICallback callback) {
        if (callback != null) {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    @Override
    public int getTotalWork(IStepContext context, IPropertiesContainer data) {
        return 100;
    }

    @Override
    public String[] getDependencies() {
        return this.dependencies.toArray(new String[this.dependencies.size()]);
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters != null ? parameters : Collections.EMPTY_MAP;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public final void callback(IPropertiesContainer data, IFullQualifiedId fullQualifiedId, ICallback callback, IStatus status, Object callbackData) {
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        Assert.isNotNull((Object)callback);
        Assert.isNotNull((Object)status);
        callback.setProperty("data", callbackData);
        callback.done((Object)this, status);
    }

    protected Object getActiveContext(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId) {
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        Object activeContext = StepperAttributeUtil.getProperty("org.eclipse.tcf.te.runtime.stepper.active_context", fullQualifiedId, data);
        if (activeContext == null) {
            activeContext = context.getContextObject();
        }
        return activeContext;
    }

    @Override
    public int getCancelTimeout() {
        return 10000;
    }

    @Override
    public void cancel(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) {
    }
}

