/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.properties;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;

public class PropertiesContainer
extends PlatformObject
implements IPropertiesContainer {
    private static volatile UUID LAST_UUID_GENERATED = null;
    private final UUID uniqueId;
    private boolean changeEventsEnabled = false;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public PropertiesContainer() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        UUID uuid = UUID.randomUUID();
        while (LAST_UUID_GENERATED != null && LAST_UUID_GENERATED.equals(uuid)) {
            uuid = UUID.randomUUID();
        }
        this.uniqueId = LAST_UUID_GENERATED = uuid;
    }

    @Override
    public final UUID getUUID() {
        return this.uniqueId;
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (!equals && obj instanceof PropertiesContainer) {
            return this.uniqueId.equals(((PropertiesContainer)obj).uniqueId);
        }
        return equals;
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("UUID=" + this.uniqueId.toString());
        buffer.append(", properties={");
        for (String key : this.properties.keySet()) {
            buffer.append(key);
            buffer.append("=");
            Object value = this.properties.get(key);
            if (value instanceof Map || value instanceof IPropertiesContainer) {
                buffer.append("{...}");
            } else {
                buffer.append(value);
            }
            buffer.append(", ");
        }
        if (buffer.toString().endsWith(", ")) {
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public final boolean setChangeEventsEnabled(boolean enabled) {
        boolean changed = this.changeEventsEnabled ^ enabled;
        if (changed) {
            this.changeEventsEnabled = enabled;
        }
        return changed;
    }

    @Override
    public final boolean changeEventsEnabled() {
        return this.changeEventsEnabled;
    }

    @Override
    public void fireChangeEvent(String key, Object oldValue, Object newValue) {
        Assert.isNotNull((Object)key);
        EventObject event = this.newEvent(this, key, oldValue, newValue);
        if (event != null) {
            EventManager.getInstance().fireEvent(event);
        }
    }

    private final EventObject newEvent(Object source, String key, Object oldValue, Object newValue) {
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)key);
        if (this.dropEvent(source, key, oldValue, newValue)) {
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/events")) {
                CoreBundleActivator.getTraceHandler().trace("Drop event notification (not created change event)\n\t\tfor eventId  = " + key + ",\n\t\t" + "currentValue = " + oldValue + ",\n\t\t" + "newValue     = " + newValue, 0, "trace/events", 2, this);
            }
            return null;
        }
        return this.newEventDelegate(source, key, oldValue, newValue);
    }

    protected EventObject newEventDelegate(Object source, String key, Object oldValue, Object newValue) {
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)key);
        return new ChangeEvent(source, key, oldValue, newValue);
    }

    protected boolean dropEvent(Object source, String key, Object oldValue, Object newValue) {
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)key);
        return !this.changeEventsEnabled || key.endsWith(".silent");
    }

    protected boolean checkThreadAccess() {
        return true;
    }

    @Override
    public Map<String, Object> getProperties() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return Collections.unmodifiableMap(new HashMap<String, Object>(this.properties));
    }

    @Override
    public Object getProperty(String key) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.properties.get(key);
    }

    @Override
    public final boolean getBooleanProperty(String key) {
        Object value = this.getProperty(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String val = ((String)value).trim();
            return "TRUE".equalsIgnoreCase(val) || "1".equals(val) || "Y".equalsIgnoreCase(val) || "JA".equalsIgnoreCase(val) || "YES".equalsIgnoreCase(val);
        }
        return false;
    }

    @Override
    public final long getLongProperty(String key) {
        Object value = this.getProperty(key);
        try {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value != null) {
                return Long.decode(value.toString());
            }
        }
        catch (Exception exception) {}
        return -1L;
    }

    @Override
    public final int getIntProperty(String key) {
        Object value = this.getProperty(key);
        try {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value != null) {
                return Integer.decode(value.toString());
            }
        }
        catch (Exception exception) {}
        return -1;
    }

    @Override
    public final String getStringProperty(String key) {
        Object value = this.getProperty(key);
        return value instanceof String ? (String)value : (value != null ? value.toString() : null);
    }

    @Override
    public final float getFloatProperty(String key) {
        Object value = this.getProperty(key);
        try {
            if (value instanceof Float) {
                return ((Float)value).floatValue();
            }
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            if (value != null) {
                return Float.parseFloat(value.toString());
            }
        }
        catch (Exception exception) {}
        return Float.NaN;
    }

    @Override
    public final double getDoubleProperty(String key) {
        Object value = this.getProperty(key);
        try {
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value != null) {
                return Double.parseDouble(value.toString());
            }
        }
        catch (Exception exception) {}
        return Double.NaN;
    }

    @Override
    public final void setProperties(Map<String, Object> properties) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        Assert.isNotNull(properties);
        if (this.properties.equals(properties)) {
            return;
        }
        this.properties.clear();
        this.properties.putAll(properties);
        this.postSetProperties(properties);
    }

    protected void postSetProperties(Map<String, ?> properties) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        Assert.isNotNull(properties);
        this.fireChangeEvent("properties", null, properties);
    }

    @Override
    public final void addProperties(Map<String, ?> properties) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        Assert.isNotNull(properties);
        this.properties.putAll(properties);
        this.postSetProperties(properties);
    }

    @Override
    public final boolean setProperty(String key, boolean value) {
        boolean oldValue = this.getBooleanProperty(key);
        if (oldValue != value) {
            return this.setProperty(key, (Object)value);
        }
        return false;
    }

    @Override
    public final boolean setProperty(String key, long value) {
        long oldValue = this.getLongProperty(key);
        if (oldValue != value) {
            return this.setProperty(key, (Object)value);
        }
        return false;
    }

    @Override
    public final boolean setProperty(String key, int value) {
        int oldValue = this.getIntProperty(key);
        if (oldValue != value) {
            return this.setProperty(key, (Object)value);
        }
        return false;
    }

    @Override
    public final boolean setProperty(String key, float value) {
        float oldValue = this.getFloatProperty(key);
        if (oldValue != value) {
            return this.setProperty(key, Float.valueOf(value));
        }
        return false;
    }

    @Override
    public final boolean setProperty(String key, double value) {
        double oldValue = this.getDoubleProperty(key);
        if (oldValue != value) {
            return this.setProperty(key, (Object)value);
        }
        return false;
    }

    @Override
    public boolean setProperty(String key, Object value) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)key);
        Object oldValue = this.properties.get(key);
        if (oldValue == null && value != null || oldValue != null && !oldValue.equals(value)) {
            if (value != null) {
                this.properties.put(key, value);
            } else {
                this.properties.remove(key);
            }
            this.postSetProperty(key, value, oldValue);
            return true;
        }
        return false;
    }

    public void postSetProperty(String key, Object value, Object oldValue) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)key);
        this.fireChangeEvent(key, oldValue, value);
    }

    @Override
    public final void clearProperties() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        this.properties.clear();
    }

    @Override
    public boolean isEmpty() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)key);
        return this.properties.containsKey(key);
    }

    @Override
    public final boolean isProperty(String key, long value) {
        return this.getLongProperty(key) == value;
    }

    @Override
    public final boolean isProperty(String key, boolean value) {
        return this.getBooleanProperty(key) == value;
    }

    @Override
    public final boolean isProperty(String key, int value) {
        return this.getIntProperty(key) == value;
    }

    @Override
    public final boolean isProperty(String key, float value) {
        return (double)Math.abs(this.getFloatProperty(key) - value) < 1.0E-7;
    }

    @Override
    public final boolean isProperty(String key, double value) {
        return Math.abs(this.getDoubleProperty(key) - value) < 1.0E-7;
    }

    @Override
    public final boolean isPropertyIgnoreCase(String key, String value) {
        String property = this.getStringProperty(key);
        return property == null && value == null || property != null && property.equalsIgnoreCase(value);
    }

    @Override
    public final boolean isProperty(String key, Object value) {
        Object property = this.getProperty(key);
        return property == null && value == null || property != null && property.equals(value);
    }

    public Object getAdapter(Class adapter) {
        Object adapted = super.getAdapter(adapter);
        return adapted != null ? adapted : Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }
}

