/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.core.AbstractPeer;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapService;
import org.eclipse.tcf.te.tcf.core.nls.Messages;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.core.va.ValueAddManager;
import org.eclipse.tcf.te.tcf.core.va.interfaces.IValueAdd;

public final class ChannelManager
extends PlatformObject
implements IChannelManager {
    final Map<String, AtomicInteger> refCounters = new HashMap<String, AtomicInteger>();
    final Map<String, IChannel> channels = new HashMap<String, IChannel>();
    final List<IChannel> forcedChannels = new ArrayList<IChannel>();
    final Map<IChannel, List<StreamListenerProxy>> streamProxies = new HashMap<IChannel, List<StreamListenerProxy>>();
    final Map<String, List<DoneHandleValueAdds>> inProgress = new HashMap<String, List<DoneHandleValueAdds>>();

    @Override
    public void openChannel(final IPeer peer, final Map<String, Boolean> flags, final IChannelManager.DoneOpenChannel done) {
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            try {
                throw new Throwable();
            }
            catch (Throwable e) {
                CoreBundleActivator.getTraceHandler().trace("ChannelManager#openChannel called from:", 0, "trace/channelManager", 1, (Object)this);
                e.printStackTrace();
            }
        }
        IChannelManager.DoneOpenChannel innerDone = null;
        boolean noPathMap = flags != null && flags.containsKey("channel.noPathMap") ? flags.get("channel.noPathMap") : false;
        innerDone = noPathMap ? done : new IChannelManager.DoneOpenChannel(){

            @Override
            public void doneOpenChannel(final Throwable error, final IChannel channel) {
                if (error != null || channel == null || channel.getState() != 1) {
                    done.doneOpenChannel(error, channel);
                } else {
                    final IPathMapService service = (IPathMapService)ServiceManager.getInstance().getService((Object)peer, IPathMapService.class);
                    IPathMap svc = (IPathMap)channel.getRemoteService(IPathMap.class);
                    if (service != null && svc != null) {
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                service.applyPathMap(peer, true, (ICallback)new Callback(){

                                    protected void internalDone(Object caller, IStatus status) {
                                        done.doneOpenChannel(error, channel);
                                    }
                                });
                            }
                        });
                        thread.start();
                    } else {
                        done.doneOpenChannel(null, channel);
                    }
                }
            }
        };
        final IChannelManager.DoneOpenChannel finInnerDone = innerDone;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ChannelManager.this.internalHandleValueAdds(peer, flags, new DoneHandleValueAdds(){

                    @Override
                    public void doneHandleValueAdds(Throwable error, IValueAdd[] valueAdds) {
                        if (error == null) {
                            if (valueAdds != null && valueAdds.length > 0) {
                                ChannelManager.this.internalChainValueAdds(valueAdds, peer, flags, finInnerDone);
                            } else {
                                ChannelManager.this.internalOpenChannel(peer, (Map<String, Boolean>)flags, finInnerDone);
                            }
                        } else {
                            ChannelManager.this.internalShutdownValueAdds(peer, valueAdds);
                            finInnerDone.doneOpenChannel(error, null);
                        }
                    }
                });
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    void internalOpenChannel(IPeer peer, Map<String, Boolean> flags, final IChannelManager.DoneOpenChannel done) {
        block19: {
            IChannel finChannel;
            boolean noValueAdd;
            Assert.isNotNull((Object)peer);
            Assert.isNotNull((Object)done);
            Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
            IChannel channel = null;
            final String id = peer.getID();
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_message, (Object)id, flags), 0, "trace/channelManager", 1, (Object)this);
            }
            boolean forceNew = flags != null && flags.containsKey("channel.forceNew") ? flags.get("channel.forceNew") : false;
            boolean bl = noValueAdd = flags != null && flags.containsKey("channel.noValueAdd") ? flags.get("channel.noValueAdd") : false;
            if (noValueAdd) {
                forceNew = true;
            }
            final boolean finForceNew = forceNew;
            IChannel iChannel = channel = !forceNew ? this.channels.get(id) : null;
            if (channel != null && (channel.getState() == 1 || channel.getState() == 0)) {
                AtomicInteger counter = this.refCounters.get(id);
                if (counter == null) {
                    counter = new AtomicInteger(0);
                    this.refCounters.put(id, counter);
                }
                counter.incrementAndGet();
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_reuse_message, (Object)id, (Object)counter.toString()), 0, "trace/channelManager", 1, (Object)this);
                }
            } else if (channel != null) {
                channel = null;
                this.channels.remove(id);
                this.refCounters.remove(id);
            }
            if (channel == null) {
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_new_message, (Object)id), 0, "trace/channelManager", 1, (Object)this);
                }
                try {
                    channel = peer.openChannel();
                    if (channel != null) {
                        if (!forceNew) {
                            this.channels.put(id, channel);
                        }
                        if (!forceNew) {
                            this.refCounters.put(id, new AtomicInteger(1));
                        }
                        if (forceNew) {
                            this.forcedChannels.add(channel);
                        }
                        finChannel = channel;
                        channel.addChannelListener(new IChannel.IChannelListener(){

                            public void onChannelOpened() {
                                finChannel.removeChannelListener((IChannel.IChannelListener)this);
                                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_success_message, (Object)id), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                                }
                                done.doneOpenChannel(null, finChannel);
                            }

                            public void onChannelClosed(Throwable error) {
                                finChannel.removeChannelListener((IChannel.IChannelListener)this);
                                if (!finForceNew) {
                                    ChannelManager.this.channels.remove(id);
                                }
                                if (!finForceNew) {
                                    ChannelManager.this.refCounters.remove(id);
                                }
                                if (finForceNew) {
                                    ChannelManager.this.forcedChannels.remove(finChannel);
                                }
                                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_failed_message, (Object)id, (Object)error), 0, "trace/channelManager", 1, (Object)this);
                                }
                                done.doneOpenChannel(error != null ? error : new OperationCanceledException(), finChannel);
                            }

                            public void congestionLevel(int level) {
                            }
                        });
                        break block19;
                    }
                    done.doneOpenChannel(new Exception("Unexpected null return value from IPeer#openChannel()!"), null);
                }
                catch (Throwable e) {
                    if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                        CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_failed_message, (Object)id, (Object)e), 0, "trace/channelManager", 1, (Object)this);
                    }
                    done.doneOpenChannel(e, channel);
                }
            } else if (channel.getState() == 0) {
                finChannel = channel;
                channel.addChannelListener(new IChannel.IChannelListener(){

                    public void onChannelOpened() {
                        done.doneOpenChannel(null, finChannel);
                    }

                    public void onChannelClosed(Throwable error) {
                        done.doneOpenChannel(error != null ? error : new OperationCanceledException(), finChannel);
                    }

                    public void congestionLevel(int level) {
                    }
                });
            } else {
                done.doneOpenChannel(null, channel);
            }
        }
    }

    @Override
    public void openChannel(final Map<String, String> peerAttributes, final Map<String, Boolean> flags, final IChannelManager.DoneOpenChannel done) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ChannelManager.this.internalOpenChannel(peerAttributes, (Map<String, Boolean>)flags, done);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    void internalOpenChannel(Map<String, String> peerAttributes, Map<String, Boolean> flags, IChannelManager.DoneOpenChannel done) {
        Assert.isNotNull(peerAttributes);
        Assert.isNotNull((Object)done);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        this.openChannel(this.getOrCreatePeerInstance(peerAttributes), flags, done);
    }

    private IPeer getOrCreatePeerInstance(Map<String, String> peerAttributes) {
        Assert.isNotNull(peerAttributes);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        String peerId = peerAttributes.get("ID");
        Assert.isNotNull((Object)peerId);
        boolean isTransient = peerAttributes.containsKey("transient") ? Boolean.parseBoolean(peerAttributes.remove("transient")) : false;
        Object peer = (IPeer)Protocol.getLocator().getPeers().get(peerId);
        if (peer == null) {
            Peer peer2 = peer = isTransient ? new Peer(peerAttributes) : new AbstractPeer(peerAttributes);
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_createPeer_new_message, (Object)peerId, (Object)isTransient), 0, "trace/channelManager", 1, (Object)this);
            }
        }
        return peer;
    }

    @Override
    public IChannel getChannel(final IPeer peer) {
        final AtomicReference channel = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                channel.set(ChannelManager.this.internalGetChannel(peer));
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return (IChannel)channel.get();
    }

    public IChannel internalGetChannel(IPeer peer) {
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        String id = peer.getID();
        IChannel channel = this.channels.get(id);
        if (channel != null && channel.getState() != 1 && channel.getState() != 0) {
            channel = null;
            this.channels.remove(id);
            this.refCounters.remove(id);
        }
        return channel;
    }

    @Override
    public void closeChannel(final IChannel channel) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ChannelManager.this.internalCloseChannel(channel);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    void internalCloseChannel(IChannel channel) {
        AtomicInteger counter;
        Assert.isNotNull((Object)channel);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IPeer peer = channel.getRemotePeer();
        String id = peer.getID();
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_closeChannel_message, (Object)id), 0, "trace/channelManager", 1, (Object)this);
        }
        boolean isRefCounted = !this.forcedChannels.contains(channel);
        AtomicInteger atomicInteger = counter = isRefCounted ? this.refCounters.get(id) : null;
        if (counter == null || counter.decrementAndGet() == 0) {
            IValueAdd[] valueAdds;
            channel.close();
            if (counter != null && counter.get() == 0 && (valueAdds = ValueAddManager.getInstance().getValueAdd(peer)) != null && valueAdds.length > 0) {
                this.internalShutdownValueAdds(peer, valueAdds);
            }
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_closeChannel_closed_message, (Object)id), 0, "trace/channelManager", 1, (Object)this);
            }
            if (isRefCounted) {
                this.refCounters.remove(id);
            }
            if (isRefCounted) {
                this.channels.remove(id);
            }
            if (!isRefCounted) {
                this.forcedChannels.remove(channel);
            }
        } else if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_closeChannel_inuse_message, (Object)id, (Object)counter.toString()), 0, "trace/channelManager", 1, (Object)this);
        }
        ListIterator<IChannel> iter = this.forcedChannels.listIterator();
        while (iter.hasNext()) {
            IChannel c = iter.next();
            if (c.getState() != 2) continue;
            iter.remove();
        }
    }

    @Override
    public void shutdown(final IPeer peer) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ChannelManager.this.internalShutdown(peer);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    void internalShutdown(IPeer peer) {
        IValueAdd[] valueAdds;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)peer);
        String id = peer.getID();
        ListIterator<IChannel> iter = this.forcedChannels.listIterator();
        while (iter.hasNext()) {
            IChannel c = iter.next();
            if (!id.equals(c.getRemotePeer().getID())) continue;
            c.close();
            iter.remove();
        }
        IChannel channel = this.internalGetChannel(peer);
        if (channel != null) {
            this.refCounters.remove(id);
            this.internalCloseChannel(channel);
        }
        if ((valueAdds = ValueAddManager.getInstance().getValueAdd(peer)) != null && valueAdds.length > 0) {
            this.internalShutdownValueAdds(peer, valueAdds);
        }
    }

    @Override
    public void closeAll(boolean wait) {
        if (wait) {
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ChannelManager.this.internalCloseAll();
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else if (wait) {
            Protocol.invokeAndWait((Runnable)runnable);
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    void internalCloseAll() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IChannel[] openChannels = this.channels.values().toArray(new IChannel[this.channels.values().size()]);
        this.refCounters.clear();
        this.channels.clear();
        IChannel[] iChannelArray = openChannels;
        int n = openChannels.length;
        int n2 = 0;
        while (n2 < n) {
            IChannel channel = iChannelArray[n2];
            this.internalCloseChannel(channel);
            ++n2;
        }
        this.internalShutdownAllValueAdds();
    }

    void internalShutdownValueAdds(IPeer peer, IValueAdd[] valueAdds) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)valueAdds);
        String id = peer.getID();
        if (valueAdds.length > 0) {
            this.doShutdownValueAdds(id, valueAdds);
        }
    }

    void doShutdownValueAdds(String id, IValueAdd[] valueAdds) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)valueAdds);
        IValueAdd[] iValueAddArray = valueAdds;
        int n = valueAdds.length;
        int n2 = 0;
        while (n2 < n) {
            IValueAdd valueAdd = iValueAddArray[n2];
            valueAdd.shutdown(id, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                }
            });
            ++n2;
        }
    }

    void internalShutdownAllValueAdds() {
        IValueAdd[] valueAdds;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IValueAdd[] iValueAddArray = valueAdds = ValueAddManager.getInstance().getValueAdds(false);
        int n = valueAdds.length;
        int n2 = 0;
        while (n2 < n) {
            IValueAdd valueAdd = iValueAddArray[n2];
            valueAdd.shutdownAll((ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                }
            });
            ++n2;
        }
    }

    void internalHandleValueAdds(IPeer peer, Map<String, Boolean> flags, DoneHandleValueAdds done) {
        IChannel channel;
        boolean noValueAdd;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)done);
        String id = peer.getID();
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_check, (Object)id), 0, "trace/channelManager", 1, (Object)this);
        }
        boolean forceNew = flags != null && flags.containsKey("channel.forceNew") ? flags.get("channel.forceNew") : false;
        boolean bl = noValueAdd = flags != null && flags.containsKey("channel.noValueAdd") ? flags.get("channel.noValueAdd") : false;
        if (noValueAdd) {
            forceNew = true;
        }
        IChannel iChannel = channel = !forceNew ? this.channels.get(id) : null;
        if (noValueAdd || channel != null && (channel.getState() == 1 || channel.getState() == 0)) {
            done.doneHandleValueAdds(null, null);
            return;
        }
        this.internalHandleValueAdds(peer, done);
    }

    void internalHandleValueAdds(IPeer peer, DoneHandleValueAdds done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)done);
        final String id = peer.getID();
        if (this.inProgress.containsKey(id)) {
            List<DoneHandleValueAdds> dones = this.inProgress.get(id);
            Assert.isNotNull(dones);
            dones.add(done);
            return;
        }
        ArrayList<DoneHandleValueAdds> dones = new ArrayList<DoneHandleValueAdds>();
        dones.add(done);
        this.inProgress.put(id, dones);
        final DoneHandleValueAdds myDone = new DoneHandleValueAdds(){

            @Override
            public void doneHandleValueAdds(Throwable error, IValueAdd[] valueAdds) {
                List<DoneHandleValueAdds> dones = ChannelManager.this.inProgress.remove(id);
                for (DoneHandleValueAdds done : dones) {
                    done.doneHandleValueAdds(error, valueAdds);
                }
            }
        };
        IValueAdd[] valueAdds = ValueAddManager.getInstance().getValueAdd(peer);
        if (valueAdds.length == 0) {
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_noneApplicable, (Object)id), 0, "trace/channelManager", 1, (Object)this);
            }
            myDone.doneHandleValueAdds(null, valueAdds);
            return;
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_numApplicable, (Object)valueAdds.length, (Object)id), 0, "trace/channelManager", 1, (Object)this);
        }
        ArrayList<IValueAdd> available = new ArrayList<IValueAdd>();
        DoneLaunchValueAdd innerDone = new DoneLaunchValueAdd(){

            @Override
            public void doneLaunchValueAdd(Throwable error, List<IValueAdd> available) {
                myDone.doneHandleValueAdds(error, available.toArray(new IValueAdd[available.size()]));
            }
        };
        this.doLaunchValueAdd(id, valueAdds, 0, available, innerDone);
    }

    void doLaunchValueAdd(final String id, final IValueAdd[] valueAdds, final int i, final List<IValueAdd> available, final DoneLaunchValueAdd done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)valueAdds);
        Assert.isTrue((valueAdds.length > 0 ? 1 : 0) != 0);
        Assert.isNotNull(available);
        Assert.isNotNull((Object)done);
        final IValueAdd valueAdd = valueAdds[i];
        valueAdd.isAlive(id, (ICallback)new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                boolean alive = (Boolean)this.getResult();
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_isAlive, (Object[])new Object[]{i, valueAdd.getLabel(), alive, id}), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                }
                if (!alive) {
                    valueAdd.launch(id, (ICallback)new Callback(){

                        protected void internalDone(Object caller, IStatus status) {
                            Throwable error = status.getException();
                            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_launch, (Object[])new Object[]{i, valueAdd.getLabel(), error == null ? "success" : "failed", error != null ? error.getLocalizedMessage() : null, id}), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                            }
                            if (error != null && valueAdd.isOptional()) {
                                error = null;
                            } else if (error == null) {
                                available.add(valueAdd);
                            }
                            if (error != null) {
                                done.doneLaunchValueAdd(error, available);
                            } else if (i + 1 < valueAdds.length) {
                                DoneLaunchValueAdd innerDone = new DoneLaunchValueAdd(){

                                    @Override
                                    public void doneLaunchValueAdd(Throwable error, List<IValueAdd> available) {
                                        done.doneLaunchValueAdd(error, available);
                                    }
                                };
                                ChannelManager.this.doLaunchValueAdd(id, valueAdds, i + 1, available, innerDone);
                            } else {
                                done.doneLaunchValueAdd(null, available);
                            }
                        }
                    });
                } else {
                    available.add(valueAdd);
                    if (i + 1 < valueAdds.length) {
                        DoneLaunchValueAdd innerDone = new DoneLaunchValueAdd(){

                            @Override
                            public void doneLaunchValueAdd(Throwable error, List<IValueAdd> available) {
                                done.doneLaunchValueAdd(error, available);
                            }
                        };
                        ChannelManager.this.doLaunchValueAdd(id, valueAdds, i + 1, available, innerDone);
                    } else {
                        done.doneLaunchValueAdd(null, available);
                    }
                }
            }
        });
    }

    void internalChainValueAdds(IValueAdd[] valueAdds, IPeer peer, Map<String, Boolean> flags, final IChannelManager.DoneOpenChannel done) {
        IChannel channel;
        boolean noPathMap;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)valueAdds);
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)done);
        String id = peer.getID();
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_startChaining, (Object)id), 0, "trace/channelManager", 1, (Object)this);
        }
        boolean forceNew = flags != null && flags.containsKey("channel.forceNew") ? flags.get("channel.forceNew") : false;
        boolean noValueAdd = flags != null && flags.containsKey("channel.noValueAdd") ? flags.get("channel.noValueAdd") : false;
        boolean bl = noPathMap = flags != null && flags.containsKey("channel.noPathMap") ? flags.get("channel.noPathMap") : false;
        if (noValueAdd || noPathMap) {
            forceNew = true;
        }
        IChannel iChannel = channel = !forceNew ? this.channels.get(id) : null;
        if (channel != null && (channel.getState() == 1 || channel.getState() == 0)) {
            AtomicInteger counter = this.refCounters.get(id);
            if (counter == null) {
                counter = new AtomicInteger(0);
                this.refCounters.put(id, counter);
            }
            counter.incrementAndGet();
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_reuse_message, (Object)id, (Object)counter.toString()), 0, "trace/channelManager", 1, (Object)this);
            }
            if (channel.getState() == 0) {
                final IChannel finChannel = channel;
                channel.addChannelListener(new IChannel.IChannelListener(){

                    public void onChannelOpened() {
                        done.doneOpenChannel(null, finChannel);
                    }

                    public void onChannelClosed(Throwable error) {
                        done.doneOpenChannel(error != null ? error : new OperationCanceledException(), finChannel);
                    }

                    public void congestionLevel(int level) {
                    }
                });
            } else {
                done.doneOpenChannel(null, channel);
            }
            return;
        }
        if (channel != null) {
            this.channels.remove(id);
            this.refCounters.remove(id);
        }
        DoneChainValueAdd innerDone = new DoneChainValueAdd(){

            @Override
            public void doneChainValueAdd(Throwable error, IChannel channel) {
                done.doneOpenChannel(error, channel);
            }
        };
        this.doChainValueAdd(id, peer.getAttributes(), forceNew, valueAdds, innerDone);
    }

    void doChainValueAdd(final String id, final Map<String, String> attrs, final boolean forceNew, final IValueAdd[] valueAdds, final DoneChainValueAdd done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull(attrs);
        Assert.isNotNull((Object)valueAdds);
        Assert.isNotNull((Object)done);
        final AtomicInteger index = new AtomicInteger(0);
        final AtomicReference<IValueAdd> valueAdd = new AtomicReference<IValueAdd>();
        valueAdd.set(valueAdds[index.get()]);
        Assert.isNotNull(valueAdd.get());
        final AtomicReference<IValueAdd> nextValueAdd = new AtomicReference<IValueAdd>();
        nextValueAdd.set(index.get() + 1 < valueAdds.length ? valueAdds[index.get() + 1] : null);
        final AtomicReference<IPeer> valueAddPeer = new AtomicReference<IPeer>();
        valueAddPeer.set(((IValueAdd)valueAdd.get()).getPeer(id));
        if (valueAddPeer.get() == null) {
            done.doneChainValueAdd(new IllegalStateException("Invalid value-add peer."), null);
            return;
        }
        final AtomicReference<IPeer> nextValueAddPeer = new AtomicReference<IPeer>();
        nextValueAddPeer.set(nextValueAdd.get() != null ? ((IValueAdd)nextValueAdd.get()).getPeer(id) : null);
        if (nextValueAdd.get() != null && nextValueAddPeer.get() == null) {
            done.doneChainValueAdd(new IllegalStateException("Invalid value-add peer."), null);
            return;
        }
        IChannel channel = null;
        try {
            channel = ((IPeer)valueAddPeer.get()).openChannel();
            if (channel != null) {
                if (!forceNew) {
                    this.channels.put(id, channel);
                }
                if (!forceNew) {
                    this.refCounters.put(id, new AtomicInteger(1));
                }
                if (forceNew) {
                    this.forcedChannels.add(channel);
                }
                final IChannel finChannel = channel;
                channel.addChannelListener(new IChannel.IChannelListener(){

                    public void onChannelOpened() {
                        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_redirect_succeeded, (Object[])new Object[]{((IPeer)valueAddPeer.get()).getID(), finChannel.getRemotePeer().getID(), index.get()}), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                        }
                        if (nextValueAdd.get() == null) {
                            finChannel.removeChannelListener((IChannel.IChannelListener)this);
                            done.doneChainValueAdd(null, finChannel);
                        } else {
                            index.incrementAndGet();
                            valueAdd.set((IValueAdd)nextValueAdd.get());
                            valueAddPeer.set((IPeer)nextValueAddPeer.get());
                            if (valueAddPeer.get() == null) {
                                finChannel.removeChannelListener((IChannel.IChannelListener)this);
                                finChannel.close();
                                done.doneChainValueAdd(new IllegalStateException("Invalid value-add peer."), null);
                                return;
                            }
                            nextValueAdd.set(index.get() + 1 < valueAdds.length ? valueAdds[index.get() + 1] : null);
                            nextValueAddPeer.set(nextValueAdd.get() != null ? ((IValueAdd)nextValueAdd.get()).getPeer(id) : null);
                            if (nextValueAdd.get() != null && nextValueAddPeer.get() == null) {
                                finChannel.removeChannelListener((IChannel.IChannelListener)this);
                                finChannel.close();
                                done.doneChainValueAdd(new IllegalStateException("Invalid value-add peer."), null);
                                return;
                            }
                            finChannel.redirect(nextValueAddPeer.get() != null ? ((IPeer)nextValueAddPeer.get()).getAttributes() : attrs);
                        }
                    }

                    public void onChannelClosed(Throwable error) {
                        finChannel.removeChannelListener((IChannel.IChannelListener)this);
                        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_valueAdd_redirect_failed, (Object)((IPeer)valueAddPeer.get()).getID(), (Object)(nextValueAddPeer.get() != null ? ((IPeer)nextValueAddPeer.get()).getID() : id)), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                        }
                        if (!forceNew) {
                            ChannelManager.this.channels.remove(id);
                        }
                        if (!forceNew) {
                            ChannelManager.this.refCounters.remove(id);
                        }
                        if (forceNew) {
                            ChannelManager.this.forcedChannels.remove(finChannel);
                        }
                        done.doneChainValueAdd(error, finChannel);
                    }

                    public void congestionLevel(int level) {
                    }
                });
                channel.redirect(nextValueAddPeer.get() != null ? ((IPeer)nextValueAddPeer.get()).getAttributes() : attrs);
            } else {
                done.doneChainValueAdd(new Exception("Unexpected null return value from IPeer#openChannel()!"), null);
            }
        }
        catch (Throwable e) {
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_failed_message, (Object)id, (Object)e), 0, "trace/channelManager", 1, (Object)this);
            }
            done.doneChainValueAdd(e, channel);
        }
    }

    @Override
    public void subscribeStream(final IChannel channel, String streamType, final IChannelManager.IStreamsListener listener, final IChannelManager.DoneSubscribeStream done) {
        Assert.isNotNull((Object)channel);
        Assert.isNotNull((Object)streamType);
        Assert.isNotNull((Object)listener);
        Assert.isNotNull((Object)done);
        if (channel.getState() != 1) {
            done.doneSubscribeStream(new Exception(Messages.ChannelManager_stream_closed_message));
            return;
        }
        StreamListenerProxy proxy = null;
        List<StreamListenerProxy> proxies = this.streamProxies.get(channel);
        if (proxies != null) {
            for (StreamListenerProxy candidate : proxies) {
                if (!streamType.equals(candidate.getStreamType())) continue;
                proxy = candidate;
                break;
            }
        }
        if (proxy != null) {
            proxy.addListener(listener);
            done.doneSubscribeStream(null);
        } else {
            proxy = new StreamListenerProxy(channel, streamType);
            if (proxies == null) {
                proxies = new ArrayList<StreamListenerProxy>();
                this.streamProxies.put(channel, proxies);
            }
            proxies.add(proxy);
            proxy.addListener(listener);
            IStreams service = (IStreams)channel.getRemoteService(IStreams.class);
            if (service != null) {
                final StreamListenerProxy finProxy = proxy;
                final List<StreamListenerProxy> finProxies = proxies;
                service.subscribe(streamType, (IStreams.StreamsListener)proxy, new IStreams.DoneSubscribe(){

                    public void doneSubscribe(IToken token, Exception error) {
                        if (error != null) {
                            finProxy.removeListener(listener);
                            if (finProxy.isEmpty()) {
                                finProxies.remove(finProxy);
                            }
                            if (finProxies.isEmpty()) {
                                ChannelManager.this.streamProxies.remove(channel);
                            }
                        } else {
                            finProxy.addListener(listener);
                        }
                        done.doneSubscribeStream(error);
                    }
                });
            } else {
                proxy.removeListener(listener);
                if (proxy.isEmpty()) {
                    proxies.remove(proxy);
                }
                if (proxies.isEmpty()) {
                    this.streamProxies.remove(channel);
                }
                done.doneSubscribeStream(new Exception(Messages.ChannelManager_stream_missing_service_message));
            }
        }
    }

    @Override
    public void unsubscribeStream(final IChannel channel, String streamType, IChannelManager.IStreamsListener listener, final IChannelManager.DoneUnsubscribeStream done) {
        Assert.isNotNull((Object)channel);
        Assert.isNotNull((Object)streamType);
        Assert.isNotNull((Object)listener);
        Assert.isNotNull((Object)done);
        if (channel.getState() != 1) {
            done.doneUnsubscribeStream(new Exception(Messages.ChannelManager_stream_closed_message));
            return;
        }
        StreamListenerProxy proxy = null;
        List<StreamListenerProxy> proxies = this.streamProxies.get(channel);
        if (proxies != null) {
            for (StreamListenerProxy candidate : proxies) {
                if (!streamType.equals(candidate.getStreamType())) continue;
                proxy = candidate;
                break;
            }
        }
        if (proxy != null) {
            proxy.removeListener(listener);
            if (proxy.isEmpty()) {
                IStreams service = (IStreams)channel.getRemoteService(IStreams.class);
                if (service != null) {
                    final StreamListenerProxy finProxy = proxy;
                    final List<StreamListenerProxy> finProxies = proxies;
                    service.unsubscribe(streamType, (IStreams.StreamsListener)proxy, new IStreams.DoneUnsubscribe(){

                        public void doneUnsubscribe(IToken token, Exception error) {
                            finProxies.remove(finProxy);
                            if (finProxies.isEmpty()) {
                                ChannelManager.this.streamProxies.remove(channel);
                            }
                            done.doneUnsubscribeStream(error);
                        }
                    });
                } else {
                    done.doneUnsubscribeStream(new Exception(Messages.ChannelManager_stream_missing_service_message));
                }
            }
        }
    }

    static interface DoneChainValueAdd {
        public void doneChainValueAdd(Throwable var1, IChannel var2);
    }

    static interface DoneHandleValueAdds {
        public void doneHandleValueAdds(Throwable var1, IValueAdd[] var2);
    }

    static interface DoneLaunchValueAdd {
        public void doneLaunchValueAdd(Throwable var1, List<IValueAdd> var2);
    }

    private static final class StreamListenerProxy
    implements IStreams.StreamsListener,
    IChannelManager.IStreamsListenerProxy {
        private final IChannel channel;
        private final String streamType;
        ListenerList listeners = new ListenerList();
        private final List<StreamCreatedEvent> delayedCreatedEvents = new ArrayList<StreamCreatedEvent>();

        public StreamListenerProxy(final IChannel channel, String streamType) {
            Assert.isNotNull((Object)channel);
            Assert.isNotNull((Object)streamType);
            this.channel = channel;
            this.channel.addChannelListener(new IChannel.IChannelListener(){

                public void onChannelOpened() {
                }

                public void onChannelClosed(Throwable error) {
                    channel.removeChannelListener((IChannel.IChannelListener)this);
                    Object[] candidates = StreamListenerProxy.this.listeners.getListeners();
                    StreamListenerProxy.this.listeners.clear();
                    Object[] objectArray = candidates;
                    int n = candidates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object listener = objectArray[n2];
                        if (listener instanceof IDisposable) {
                            ((IDisposable)listener).dispose();
                        }
                        ++n2;
                    }
                }

                public void congestionLevel(int level) {
                }
            });
            this.streamType = streamType;
        }

        public String getStreamType() {
            return this.streamType;
        }

        public void addListener(IChannelManager.IStreamsListener listener) {
            Assert.isNotNull((Object)listener);
            listener.setProxy(this);
            this.listeners.add((Object)listener);
        }

        public void removeListener(IChannelManager.IStreamsListener listener) {
            Assert.isNotNull((Object)listener);
            listener.setProxy(null);
            this.listeners.remove((Object)listener);
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processDelayedCreatedEvents() {
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager/streamsListenerProxy")) {
                CoreBundleActivator.getTraceHandler().trace("StreamListenerProxy: processDelayedCreatedEvents()", 0, "trace/channelManager/streamsListenerProxy", 1, this.getClass());
            }
            List<StreamCreatedEvent> list = this.delayedCreatedEvents;
            synchronized (list) {
                StreamCreatedEvent[] events = this.delayedCreatedEvents.toArray(new StreamCreatedEvent[this.delayedCreatedEvents.size()]);
                this.delayedCreatedEvents.clear();
                StreamCreatedEvent[] streamCreatedEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    StreamCreatedEvent event = streamCreatedEventArray[n2];
                    this.created(event.streamType, event.streamId, event.contextId);
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void created(String stream_type, String stream_id, String context_id) {
            IStreams service;
            Assert.isNotNull((Object)stream_type);
            Assert.isNotNull((Object)stream_id);
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager/streamsListenerProxy")) {
                CoreBundleActivator.getTraceHandler().trace("StreamListenerProxy: created(" + stream_type + ", " + stream_id + ", " + context_id + ")", 0, "trace/channelManager/streamsListenerProxy", 1, this.getClass());
            }
            if (context_id == null) {
                IStreams service2 = (IStreams)this.channel.getRemoteService(IStreams.class);
                if (service2 != null) {
                    service2.disconnect(stream_id, new IStreams.DoneDisconnect(){

                        public void doneDisconnect(IToken token, Exception error) {
                            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager/streamsListenerProxy")) {
                                CoreBundleActivator.getTraceHandler().trace("StreamListenerProxy: disconnect -> context id must be not null.", 0, "trace/channelManager/streamsListenerProxy", 1, this.getClass());
                            }
                        }
                    });
                }
                return;
            }
            boolean delayed = false;
            boolean disconnect = true;
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object l = objectArray[n2];
                IChannelManager.IStreamsListener listener = (IChannelManager.IStreamsListener)l;
                if (!listener.hasContext()) {
                    delayed |= true;
                } else {
                    boolean consume = listener.isCreatedConsumed(stream_type, stream_id, context_id);
                    if (consume) {
                        listener.created(stream_type, stream_id, context_id);
                    }
                    disconnect &= !consume;
                }
                ++n2;
            }
            if (delayed) {
                StreamCreatedEvent event = new StreamCreatedEvent(stream_type, stream_id, context_id);
                List<StreamCreatedEvent> list = this.delayedCreatedEvents;
                synchronized (list) {
                    if (!this.delayedCreatedEvents.contains(event)) {
                        this.delayedCreatedEvents.add(event);
                        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager/streamsListenerProxy")) {
                            CoreBundleActivator.getTraceHandler().trace("StreamListenerProxy: delayed -> at least one listener does not have a context set", 0, "trace/channelManager/streamsListenerProxy", 1, this.getClass());
                        }
                    }
                }
                return;
            }
            if (disconnect && (service = (IStreams)this.channel.getRemoteService(IStreams.class)) != null) {
                service.disconnect(stream_id, new IStreams.DoneDisconnect(){

                    public void doneDisconnect(IToken token, Exception error) {
                        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager/streamsListenerProxy")) {
                            CoreBundleActivator.getTraceHandler().trace("StreamListenerProxy: disconnect -> not interested in context id", 0, "trace/channelManager/streamsListenerProxy", 1, this.getClass());
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disposed(String stream_type, String stream_id) {
            Assert.isNotNull((Object)stream_type);
            Assert.isNotNull((Object)stream_id);
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager/streamsListenerProxy")) {
                CoreBundleActivator.getTraceHandler().trace("StreamListenerProxy: disposed(" + stream_type + ", " + stream_id + ")", 0, "trace/channelManager/streamsListenerProxy", 1, this.getClass());
            }
            List<StreamCreatedEvent> list = this.delayedCreatedEvents;
            synchronized (list) {
                Iterator<StreamCreatedEvent> iterator = this.delayedCreatedEvents.iterator();
                while (iterator.hasNext()) {
                    StreamCreatedEvent event = iterator.next();
                    if (!stream_type.equals(event.streamType) || !stream_id.equals(event.streamId)) continue;
                    iterator.remove();
                }
            }
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object l = objectArray[n2];
                ((IChannelManager.IStreamsListener)l).disposed(stream_type, stream_id);
                ++n2;
            }
        }

        private static final class StreamCreatedEvent {
            public final String streamType;
            public final String streamId;
            public final String contextId;
            private final String toString;

            public StreamCreatedEvent(String streamType, String streamId, String contextId) {
                this.streamType = streamType;
                this.streamId = streamId;
                this.contextId = contextId;
                this.toString = this.toString();
            }

            public boolean equals(Object obj) {
                return obj instanceof StreamCreatedEvent && this.toString().equals(((StreamCreatedEvent)obj).toString());
            }

            public int hashCode() {
                return this.toString().hashCode();
            }

            public String toString() {
                if (this.toString != null) {
                    return this.toString;
                }
                StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
                builder.append(": streamType = ");
                builder.append(this.streamType);
                builder.append("; streamId = ");
                builder.append(this.streamId);
                builder.append("; contextId = ");
                builder.append(this.contextId);
                return builder.toString();
            }
        }
    }
}

