/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.search;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.search.FSTreeNodeMatcher;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.search.NameValidator;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.interfaces.ISearchMatcher;
import org.eclipse.tcf.te.ui.search.TreeViewerSearchDialog;
import org.eclipse.tcf.te.ui.utils.AbstractSearchable;

public class FSGeneralSearchable
extends AbstractSearchable {
    private static final String INCLUDE_HIDDEN = "FS.IncludeHidden";
    private static final String INCLUDE_SYSTEM = "FS.IncludeSystem";
    private static final String TARGET_NAME = "FS.TargetName";
    private static final String TARGET_TYPE = "FS.TargetType";
    private static final String MATCH_PRECISE = "FS.MatchPrecise";
    private static final String CASE_SENSITIVE = "FS.CaseSensitive";
    private Button fBtnSystem;
    private Button fBtnHidden;
    private Button fBtnCase;
    private Button fBtnMatch;
    private BaseEditBrowseTextControl fSearchField;
    private String fTargetName;
    private boolean fCaseSensitive;
    private boolean fMatchPrecise;
    private boolean fIncludeSystem = true;
    private boolean fIncludeHidden = true;
    private Combo fCmbTypes;
    private int fTargetType;
    private FSTreeNode rootNode;

    public FSGeneralSearchable(FSTreeNode node) {
        this.rootNode = node;
    }

    public void createCommonPart(TreeViewerSearchDialog dialog, Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout glayout = new GridLayout(3, false);
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        composite.setLayout((Layout)glayout);
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(Messages.FSGeneralSearchable_Find);
        this.fSearchField = new BaseEditBrowseTextControl(null);
        this.fSearchField.setIsGroup(false);
        this.fSearchField.setHasHistory(false);
        this.fSearchField.setHideBrowseButton(true);
        this.fSearchField.setParentControlIsInnerPanel(true);
        this.fSearchField.setupPanel(composite);
        this.fSearchField.setEditFieldValidator((Validator)new NameValidator());
        Text text = (Text)this.fSearchField.getEditFieldControl();
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FSGeneralSearchable.this.searchTextModified();
            }
        });
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSGeneralSearchable.this.optionChecked(e);
            }
        };
        Group group = new Group(parent, 0);
        group.setText(Messages.FSGeneralSearchable_GeneralOptionText);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        Composite cmpType = new Composite((Composite)group, 0);
        GridData data = new GridData(768);
        cmpType.setLayoutData((Object)data);
        cmpType.setLayout((Layout)new GridLayout(2, false));
        label = new Label(cmpType, 0);
        label.setText(Messages.FSGeneralSearchable_FileType);
        this.fCmbTypes = new Combo(cmpType, 2056);
        this.fCmbTypes.setItems(new String[]{Messages.FSTreeNodeSearchable_FilesAndFolders, Messages.FSTreeNodeSearchable_FilesOnly, Messages.FSTreeNodeSearchable_FoldersOnly});
        this.fCmbTypes.setLayoutData((Object)new GridData());
        this.fCmbTypes.addSelectionListener((SelectionListener)l);
        Composite compOptions = new Composite((Composite)group, 0);
        data = new GridData(768);
        compOptions.setLayoutData((Object)data);
        compOptions.setLayout((Layout)new GridLayout(3, true));
        this.fBtnCase = new Button(compOptions, 32);
        this.fBtnCase.setText(Messages.TreeViewerSearchDialog_BtnCaseText);
        data = new GridData(768);
        this.fBtnCase.setLayoutData((Object)data);
        this.fBtnCase.addSelectionListener((SelectionListener)l);
        this.fBtnMatch = new Button(compOptions, 32);
        this.fBtnMatch.setText(Messages.TreeViewerSearchDialog_BtnPreciseText);
        data = new GridData(768);
        this.fBtnMatch.setLayoutData((Object)data);
        this.fBtnMatch.addSelectionListener((SelectionListener)l);
        dialog.createSearchDirectionOptions(compOptions);
        if (this.rootNode.isWindowsNode()) {
            this.fBtnSystem = new Button(compOptions, 32);
            this.fBtnSystem.setText(Messages.FSGeneralSearchable_SearchSystemFiles);
            data = new GridData(768);
            this.fBtnSystem.setLayoutData((Object)data);
            this.fBtnSystem.addSelectionListener((SelectionListener)l);
            this.fBtnHidden = new Button(compOptions, 32);
            this.fBtnHidden.setText(Messages.FSGeneralSearchable_SearchHiddenFiles);
            data = new GridData(768);
            this.fBtnHidden.setLayoutData((Object)data);
            this.fBtnHidden.addSelectionListener((SelectionListener)l);
        }
    }

    protected void searchTextModified() {
        this.fireOptionChanged();
        this.fTargetName = this.fSearchField.getEditFieldControlText().trim();
    }

    protected void optionChecked(SelectionEvent e) {
        Object src = e.getSource();
        if (src == this.fBtnCase) {
            this.fCaseSensitive = this.fBtnCase.getSelection();
        } else if (src == this.fBtnMatch) {
            this.fMatchPrecise = this.fBtnMatch.getSelection();
        } else if (src == this.fCmbTypes) {
            this.fTargetType = this.fCmbTypes.getSelectionIndex();
        } else if (src == this.fBtnSystem) {
            this.fIncludeSystem = this.fBtnSystem.getSelection();
        } else if (src == this.fBtnHidden) {
            this.fIncludeHidden = this.fBtnHidden.getSelection();
        }
    }

    public void restoreValues(IDialogSettings settings) {
        if (settings != null) {
            this.fCaseSensitive = settings.getBoolean(CASE_SENSITIVE);
            this.fBtnCase.setSelection(this.fCaseSensitive);
            this.fMatchPrecise = settings.getBoolean(MATCH_PRECISE);
            this.fBtnMatch.setSelection(this.fMatchPrecise);
            try {
                this.fTargetType = settings.getInt(TARGET_TYPE);
                this.fCmbTypes.select(this.fTargetType);
            }
            catch (NumberFormatException numberFormatException) {
                this.fTargetType = 0;
            }
            this.fTargetName = settings.get(TARGET_NAME);
            if (this.fTargetName != null) {
                this.fSearchField.setEditFieldControlText(this.fTargetName);
            }
            if (this.rootNode.isWindowsNode()) {
                this.fIncludeSystem = settings.get(INCLUDE_SYSTEM) == null ? true : settings.getBoolean(INCLUDE_SYSTEM);
                this.fIncludeHidden = settings.get(INCLUDE_HIDDEN) == null ? true : settings.getBoolean(INCLUDE_HIDDEN);
            }
        } else {
            this.fCaseSensitive = false;
            this.fMatchPrecise = false;
            this.fTargetType = 0;
            this.fTargetName = null;
            if (this.rootNode.isWindowsNode()) {
                this.fIncludeHidden = true;
                this.fIncludeSystem = true;
            }
        }
        this.fBtnCase.setSelection(this.fCaseSensitive);
        this.fBtnMatch.setSelection(this.fMatchPrecise);
        this.fCmbTypes.select(this.fTargetType);
        if (this.fTargetName != null) {
            this.fSearchField.setEditFieldControlText(this.fTargetName);
        }
        if (this.rootNode.isWindowsNode()) {
            this.fBtnSystem.setSelection(this.fIncludeSystem);
            this.fBtnHidden.setSelection(this.fIncludeHidden);
        }
    }

    public void persistValues(IDialogSettings settings) {
        if (settings != null) {
            settings.put(CASE_SENSITIVE, this.fCaseSensitive);
            settings.put(MATCH_PRECISE, this.fMatchPrecise);
            settings.put(TARGET_TYPE, this.fTargetType);
            settings.put(TARGET_NAME, this.fTargetName);
            if (this.rootNode.isWindowsNode()) {
                settings.put(INCLUDE_SYSTEM, this.fIncludeSystem);
                settings.put(INCLUDE_HIDDEN, this.fIncludeHidden);
            }
        }
    }

    public ISearchMatcher getMatcher() {
        return new FSTreeNodeMatcher(this.fCaseSensitive, this.fMatchPrecise, this.fTargetType, this.fTargetName, this.fIncludeSystem, this.fIncludeHidden);
    }

    public boolean isInputValid() {
        return this.fSearchField.isValid();
    }

    public Point getPreferredSize() {
        return new Point(400, this.rootNode.isWindowsNode() ? 200 : 180);
    }
}

