/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.cdt.tabs;

import org.eclipse.cdt.dsf.gdb.internal.ui.launching.CMainTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.dialogs.FSOpenFileDialog;
import org.eclipse.tcf.te.tcf.launch.cdt.controls.TCFPeerSelector;
import org.eclipse.tcf.te.tcf.launch.cdt.interfaces.IRemoteTEConfigurationConstants;
import org.eclipse.tcf.te.tcf.launch.cdt.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public class TECDSFMainTab
extends CMainTab {
    private static final String REMOTE_PROG_LABEL_TEXT = Messages.RemoteCMainTab_Program;
    private static final String SKIP_DOWNLOAD_BUTTON_TEXT = Messages.RemoteCMainTab_SkipDownload;
    private static final String REMOTE_PROG_TEXT_ERROR = Messages.RemoteCMainTab_ErrorNoProgram;
    private static final String CONNECTION_TEXT_ERROR = Messages.RemoteCMainTab_ErrorNoConnection;
    private static final String PRE_RUN_LABEL_TEXT = Messages.RemoteCMainTab_Prerun;
    private static final String REMOTE_PATH_DEFAULT = "";
    private static final boolean SKIP_DOWNLOAD_TO_REMOTE_DEFAULT = false;
    protected Button remoteBrowseButton;
    protected TCFPeerSelector peerSelector;
    protected Label remoteProgLabel;
    protected Text remoteProgText;
    protected Button skipDownloadButton;
    private Text preRunText;
    private Label preRunLabel;

    public TECDSFMainTab() {
        super(8);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = (Composite)this.getControl();
        this.createVerticalSpacer(comp, 1);
        this.createRemoteConnectionGroup(comp);
        this.createVerticalSpacer(comp, 1);
        this.createTargetExePathGroup(comp);
        this.createDownloadOption(comp);
        this.fProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TECDSFMainTab.this.setLocalPathForRemotePath();
            }
        });
    }

    public boolean isValid(ILaunchConfiguration config) {
        boolean retVal = super.isValid(config);
        if (retVal) {
            String name;
            this.setErrorMessage(null);
            if (this.peerSelector.getPeerId() == null) {
                this.setErrorMessage(CONNECTION_TEXT_ERROR);
                retVal = false;
            }
            if (retVal && (name = this.remoteProgText.getText().trim()).length() == 0) {
                this.setErrorMessage(REMOTE_PROG_TEXT_ERROR);
                retVal = false;
            }
        }
        return retVal;
    }

    protected void createRemoteConnectionGroup(Composite parent) {
        this.peerSelector = new TCFPeerSelector(parent, 0, 2);
        this.peerSelector.setLayoutData(new GridData(768));
        this.peerSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TECDSFMainTab.this.setDirty(true);
                TECDSFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createTargetExePathGroup(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        this.remoteProgLabel = new Label(mainComp, 0);
        this.remoteProgLabel.setText(REMOTE_PROG_LABEL_TEXT);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.remoteProgLabel.setLayoutData((Object)gd);
        this.remoteProgText = new Text(mainComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.remoteProgText.setLayoutData((Object)gd);
        this.remoteProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TECDSFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.remoteBrowseButton = this.createPushButton(mainComp, Messages.RemoteCMainTab_Remote_Path_Browse_Button, null);
        this.remoteBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TECDSFMainTab.this.handleRemoteBrowseSelected();
                TECDSFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.preRunLabel = new Label(mainComp, 0);
        this.preRunLabel.setText(PRE_RUN_LABEL_TEXT);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.preRunLabel.setLayoutData((Object)gd);
        this.preRunText = new Text(mainComp, 2050);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.preRunText.setLayoutData((Object)gd);
        this.preRunText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TECDSFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createDownloadOption(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        this.skipDownloadButton = this.createCheckButton(mainComp, SKIP_DOWNLOAD_BUTTON_TEXT);
        this.skipDownloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TECDSFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.skipDownloadButton.setEnabled(true);
    }

    protected void handleRemoteBrowseSelected() {
        IPeerNode connection = this.peerSelector.getPeerNode();
        if (connection != null) {
            String absPath;
            Object candidate;
            FSOpenFileDialog dialog = new FSOpenFileDialog(this.getShell());
            dialog.setInput((Object)connection);
            if (dialog.open() == 0 && (candidate = dialog.getFirstResult()) instanceof FSTreeNode && (absPath = ((FSTreeNode)candidate).getLocation()) != null) {
                this.remoteProgText.setText(absPath);
            }
        }
    }

    protected void updateTargetProgFromConfig(ILaunchConfiguration config) {
        String targetPath = null;
        try {
            targetPath = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PATH, REMOTE_PATH_DEFAULT);
        }
        catch (CoreException coreException) {}
        this.remoteProgText.setText(targetPath);
        String prelaunchCmd = null;
        try {
            prelaunchCmd = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_PRERUN_COMMANDS, REMOTE_PATH_DEFAULT);
        }
        catch (CoreException coreException) {}
        this.preRunText.setText(prelaunchCmd);
    }

    protected void updateSkipDownloadFromConfig(ILaunchConfiguration config) {
        boolean downloadToTarget = true;
        try {
            downloadToTarget = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, this.getDefaultSkipDownload());
        }
        catch (CoreException coreException) {}
        this.skipDownloadButton.setSelection(downloadToTarget);
    }

    private void setLocalPathForRemotePath() {
        String programName = this.fProgText.getText().trim();
        boolean bUpdateRemote = false;
        String remoteName = this.remoteProgText.getText().trim();
        String remoteWsRoot = this.getRemoteWSRoot();
        if (remoteName.length() == 0) {
            bUpdateRemote = true;
        } else if (remoteWsRoot.length() != 0) {
            bUpdateRemote = remoteName.equals(remoteWsRoot);
        }
        if (programName.length() != 0 && bUpdateRemote) {
            Path exePath = new Path(programName);
            if (!exePath.isAbsolute()) {
                IProject project = this.getCProject().getProject();
                exePath = project.getFile(programName).getLocation();
                IPath wsRoot = project.getWorkspace().getRoot().getLocation();
                exePath = this.makeRelativeToWSRootLocation((IPath)exePath, remoteWsRoot, wsRoot);
            }
            String path = exePath.toString();
            this.remoteProgText.setText(path);
        }
    }

    private IPath makeRelativeToWSRootLocation(IPath exePath, String remoteWsRoot, IPath wsRoot) {
        if (remoteWsRoot.length() != 0 && wsRoot.isPrefixOf(exePath)) {
            return new Path(remoteWsRoot).append(exePath.removeFirstSegments(wsRoot.segmentCount()).setDevice(null));
        }
        return exePath;
    }

    private String getRemoteWSRoot() {
        return REMOTE_PATH_DEFAULT;
    }

    private boolean getDefaultSkipDownload() {
        return false;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        String remoteConnection = null;
        try {
            remoteConnection = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_CONNECTION, REMOTE_PATH_DEFAULT);
        }
        catch (CoreException coreException) {}
        this.peerSelector.updateSelectionFrom(remoteConnection);
        super.initializeFrom(config);
        this.updateTargetProgFromConfig(config);
        this.updateSkipDownloadFromConfig(config);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        String currentSelection = this.peerSelector.getPeerId();
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_CONNECTION, currentSelection != null ? currentSelection : null);
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PATH, this.remoteProgText.getText());
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, this.skipDownloadButton.getSelection());
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_PRERUN_COMMANDS, this.preRunText.getText());
        super.performApply(config);
    }

    public String getId() {
        return "org.eclipse.tcf.te.remotecdt.dsf.gdb.mainTab";
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_CONNECTION, REMOTE_PATH_DEFAULT);
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PATH, REMOTE_PATH_DEFAULT);
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, false);
        config.setAttribute(IRemoteTEConfigurationConstants.ATTR_PRERUN_COMMANDS, REMOTE_PATH_DEFAULT);
    }
}

