/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.delegates;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapGeneratorService;
import org.eclipse.tcf.te.tcf.launch.core.internal.services.PathMapService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public final class Launch
extends TCFLaunch {
    private ICallback callback = null;
    private final IPropertiesContainer properties = new PropertiesContainer(){

        public Object getAdapter(Class adapter) {
            if (ILaunch.class.equals((Object)adapter)) {
                return Launch.this;
            }
            return super.getAdapter(adapter);
        }
    };

    public Launch(ILaunchConfiguration configuration, String mode) {
        super(configuration, mode);
    }

    public void setCallback(ICallback callback) {
        this.callback = callback;
    }

    public ICallback getCallback() {
        return this.callback;
    }

    public void attachDebugger(IPeerNode node, final ICallback callback) {
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)callback);
        final String name = node.getPeer().getName();
        HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        flags.put("channel.forceNew", Boolean.TRUE);
        Tcf.getChannelManager().openChannel(node.getPeer(), flags, new IChannelManager.DoneOpenChannel(){

            public void doneOpenChannel(Throwable error, IChannel channel) {
                if (error == null && channel != null) {
                    TCFLaunch.LaunchListener listener = new TCFLaunch.LaunchListener(){

                        public void onProcessStreamError(TCFLaunch launch, String process_id, int stream_id, Exception error, int lost_size) {
                        }

                        public void onProcessOutput(TCFLaunch launch, String process_id, int stream_id, byte[] data) {
                        }

                        public void onDisconnected(TCFLaunch launch) {
                            callback.done((Object)Launch.this, StatusHelper.getStatus((Throwable)Launch.this.getError()));
                            Launch.removeListener((TCFLaunch.LaunchListener)this);
                        }

                        public void onCreated(TCFLaunch launch) {
                        }

                        public void onConnected(TCFLaunch launch) {
                            callback.done((Object)Launch.this, Status.OK_STATUS);
                            Launch.removeListener((TCFLaunch.LaunchListener)this);
                        }
                    };
                    Launch.addListener((TCFLaunch.LaunchListener)listener);
                    Launch.this.launchTCF(Launch.this.getLaunchMode(), name, channel);
                } else {
                    callback.done((Object)Launch.this, StatusHelper.getStatus((Throwable)error));
                }
            }
        });
    }

    protected void readCustomPathMapConfiguration(IChannel channel, ILaunchConfiguration cfg, List<IPathMap.PathMapRule> host_path_map) {
        IPathMap.PathMapRule[] generatedRules;
        Assert.isNotNull((Object)channel);
        Assert.isNotNull((Object)cfg);
        Assert.isNotNull(host_path_map);
        IPathMapGeneratorService generator = (IPathMapGeneratorService)ServiceManager.getInstance().getService((Object)channel.getRemotePeer(), IPathMapGeneratorService.class);
        if (generator != null && (generatedRules = generator.getPathMap((Object)channel.getRemotePeer())) != null && generatedRules.length > 0) {
            host_path_map.addAll(Arrays.asList(generatedRules));
        }
    }

    protected void applyPathMap(IChannel channel, final IPathMap.PathMapRule[] configuredMap, final IPathMap.DoneSet done) {
        final String clientID = this.getClientID();
        if (clientID != null) {
            final IPathMap svc = (IPathMap)this.getService(IPathMap.class);
            if (svc != null) {
                svc.get(new IPathMap.DoneGet(){

                    public void doneGet(IToken token, Exception error, IPathMap.PathMapRule[] map) {
                        List<IPathMap.PathMapRule> rules = PathMapService.mergePathMaps(clientID, map, configuredMap);
                        if (PathMapService.isDifferent(rules, map)) {
                            PathMapService.set(rules, svc, done);
                        } else {
                            done.doneSet(null, null);
                        }
                    }
                });
            } else {
                done.doneSet(null, null);
            }
        } else {
            super.applyPathMap(channel, configuredMap, done);
        }
    }

    public Object getAdapter(Class adapter) {
        if (IPropertiesContainer.class.equals((Object)adapter)) {
            return this.properties;
        }
        Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        return super.getAdapter(adapter);
    }
}

