/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.internal.services;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.te.runtime.persistence.PersistenceManager;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistenceDelegate;
import org.eclipse.tcf.te.runtime.persistence.services.URIPersistenceService;
import org.eclipse.tcf.te.tcf.core.interfaces.IExportPersistenceService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public class ExportPersistenceService
extends URIPersistenceService
implements IExportPersistenceService {
    public void write(Object context, URI uri) throws IOException {
        Assert.isNotNull((Object)context);
        uri = uri != null ? uri : this.getURI(context);
        IPersistenceDelegate delegate = PersistenceManager.getInstance().getDelegate(context, (Object)uri);
        if (delegate == null) {
            throw new IOException("The persistence delegate for context '" + context.getClass().getName() + "' cannot be determined.");
        }
        if (context instanceof IPeerNode) {
            IPersistenceDelegate launchDelegate;
            IPeerNode node = (IPeerNode)context;
            ILaunchConfiguration launchConfig = (ILaunchConfiguration)Platform.getAdapterManager().getAdapter((Object)node, ILaunchConfiguration.class);
            if (launchConfig != null && (launchDelegate = PersistenceManager.getInstance().getDelegate((Object)launchConfig, String.class)) != null) {
                String launchConfigString = (String)launchDelegate.write((Object)launchConfig, String.class);
                HashMap<String, String> attrs = new HashMap<String, String>(node.getPeer().getAttributes());
                attrs.put("org.eclipse.tcf.te.tcf.launch.type.attach", launchConfigString);
                delegate.write((Object)new TransientPeer(attrs), (Object)uri);
                return;
            }
        }
        delegate.write(context, (Object)uri);
    }
}

