/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.ILocatorModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.services.AbstractLocatorModelService;

public class LocatorModelUpdateService
extends AbstractLocatorModelService
implements ILocatorModelUpdateService {
    public LocatorModelUpdateService(ILocatorModel parentModel) {
        super(parentModel);
    }

    @Override
    public void add(final IPeer peer) {
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Map peers = (Map)this.getLocatorModel().getAdapter(Map.class);
        Assert.isNotNull((Object)peers);
        peers.put(peer.getID(), peer);
        final ILocatorModelListener[] listeners = this.getLocatorModel().getListener();
        if (listeners.length > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ILocatorModelListener[] iLocatorModelListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILocatorModelListener listener = iLocatorModelListenerArray[n2];
                        listener.modelChanged(LocatorModelUpdateService.this.getLocatorModel(), peer, true);
                        ++n2;
                    }
                }
            });
        }
    }

    @Override
    public void remove(final IPeer peer) {
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Map peers = (Map)this.getLocatorModel().getAdapter(Map.class);
        Assert.isNotNull((Object)peers);
        peers.remove(peer.getID());
        final ILocatorModelListener[] listeners = this.getLocatorModel().getListener();
        if (listeners.length > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ILocatorModelListener[] iLocatorModelListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILocatorModelListener listener = iLocatorModelListenerArray[n2];
                        listener.modelChanged(LocatorModelUpdateService.this.getLocatorModel(), peer, false);
                        ++n2;
                    }
                }
            });
        }
    }

    @Override
    public void update(final IPeer oldPeer, final IPeer newPeer) {
        Assert.isNotNull((Object)oldPeer);
        Assert.isNotNull((Object)newPeer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Map peers = (Map)this.getLocatorModel().getAdapter(Map.class);
        Assert.isNotNull((Object)peers);
        peers.remove(oldPeer.getID());
        peers.put(newPeer.getID(), newPeer);
        final ILocatorModelListener[] listeners = this.getLocatorModel().getListener();
        if (listeners.length > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ILocatorModelListener[] iLocatorModelListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILocatorModelListener listener = iLocatorModelListenerArray[n2];
                        if (!oldPeer.getID().equals(newPeer.getID())) {
                            listener.modelChanged(LocatorModelUpdateService.this.getLocatorModel(), oldPeer, false);
                            listener.modelChanged(LocatorModelUpdateService.this.getLocatorModel(), newPeer, true);
                        } else {
                            listener.modelChanged(LocatorModelUpdateService.this.getLocatorModel(), newPeer, false);
                        }
                        ++n2;
                    }
                }
            });
        }
    }
}

