/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.log.core.internal.listener;

import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.core.AbstractChannel;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.te.tcf.core.util.JSONUtils;
import org.eclipse.tcf.te.tcf.log.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.log.core.events.MonitorEvent;
import org.eclipse.tcf.te.tcf.log.core.internal.LogManager;
import org.eclipse.tcf.te.tcf.log.core.internal.nls.Messages;

public class ChannelTraceListener
implements AbstractChannel.TraceListener {
    public final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    public final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final IChannel channel;
    private final boolean reverseReceived;

    public ChannelTraceListener(IChannel channel) {
        Assert.isNotNull((Object)channel);
        this.channel = channel;
        this.reverseReceived = channel.getRemotePeer().getName() != null && channel.getRemotePeer().getName().endsWith("Command Server");
    }

    protected final IChannel getChannel() {
        return this.channel;
    }

    public void onChannelClosed(Throwable error) {
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelTraceListener")) {
            CoreBundleActivator.getTraceHandler().trace("TraceListener.onChannelClosed ( " + error + " )", "trace/channelTraceListener", (Object)this);
        }
        String date = this.DATE_FORMAT.format(new Date(System.currentTimeMillis()));
        String message = NLS.bind((String)Messages.ChannelTraceListener_channelClosed_message, (Object[])new Object[]{date, Integer.toHexString(this.channel.hashCode()), error});
        LogManager.getInstance().closeWriter(this.channel, message);
        LogManager.getInstance().monitor(this.channel, MonitorEvent.Type.CLOSE, new MonitorEvent.Message('F', message));
    }

    public void onMessageReceived(char type, String token, String service, String name, byte[] data) {
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelTraceListener")) {
            CoreBundleActivator.getTraceHandler().trace("TraceListener.onMessageReceived ( " + type + ", " + token + ", " + service + ", " + name + ", ... )", "trace/channelTraceListener", (Object)this);
        }
        this.doLogMessage(type, token, service, name, data, !this.reverseReceived);
    }

    public void onMessageSent(char type, String token, String service, String name, byte[] data) {
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelTraceListener")) {
            CoreBundleActivator.getTraceHandler().trace("TraceListener.onMessageSent ( " + type + ", " + token + ", " + service + ", " + name + ", ... )", "trace/channelTraceListener", (Object)this);
        }
        this.doLogMessage(type, token, service, name, data, this.reverseReceived);
    }

    private void doLogMessage(char type, String token, String service, String name, byte[] data, boolean received) {
        boolean locatorEvents = CoreBundleActivator.getScopedPreferences().getBoolean("te.tcf.log.core.show.locatorEvents");
        if (!locatorEvents && service != null && service.toLowerCase().equals("locator")) {
            return;
        }
        boolean showHeartbeats = CoreBundleActivator.getScopedPreferences().getBoolean("te.tcf.log.core.show.heartbeats");
        if (!showHeartbeats && name != null && name.toLowerCase().contains("heartbeat")) {
            return;
        }
        boolean frameworkEvents = CoreBundleActivator.getScopedPreferences().getBoolean("te.tcf.log.core.show.frameworkEvents");
        if (!frameworkEvents && type == 'F') {
            return;
        }
        String message = this.formatMessage(type, token, service, name, data, received);
        FileWriter writer = LogManager.getInstance().getWriter(this.channel);
        if (writer != null) {
            try {
                writer.write(message);
                writer.write("\n");
                writer.flush();
            }
            catch (IOException iOException) {}
        }
        LogManager.getInstance().monitor(this.channel, MonitorEvent.Type.ACTIVITY, new MonitorEvent.Message(type, message));
    }

    protected String formatMessage(char type, String token, String service, String name, byte[] data, boolean received) {
        String time = this.TIME_FORMAT.format(new Date(System.currentTimeMillis()));
        String args = JSONUtils.decodeStringFromByteArray((byte[])data);
        StringBuilder message = new StringBuilder();
        message.append(time).append(":");
        message.append(" ").append(received ? "<---" : "--->");
        message.append(" ").append(Character.valueOf(type));
        if (token != null) {
            message.append(" ").append(token);
        }
        if (service != null) {
            message.append(" ").append(service);
        }
        if (name != null) {
            message.append(" ").append(name);
        }
        if (args != null && args.trim().length() > 0) {
            message.append(" ").append(args.trim());
        }
        return message.toString();
    }
}

