/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.log.core.internal.listener;

import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.core.AbstractChannel;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.log.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.log.core.events.MonitorEvent;
import org.eclipse.tcf.te.tcf.log.core.internal.LogManager;
import org.eclipse.tcf.te.tcf.log.core.internal.listener.ChannelTraceListener;
import org.eclipse.tcf.te.tcf.log.core.internal.nls.Messages;

public class ChannelTraceListenerManager {
    public final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final Map<IChannel, AbstractChannel.TraceListener> listeners = new HashMap<IChannel, AbstractChannel.TraceListener>();

    public static ChannelTraceListenerManager getInstance() {
        return LazyInstanceHolder.instance;
    }

    ChannelTraceListenerManager() {
    }

    public void onChannelOpened(IChannel channel) {
        boolean isValueAdd;
        Assert.isNotNull((Object)channel);
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelTraceListener")) {
            CoreBundleActivator.getTraceHandler().trace("TraceListener.onChannelOpened ( " + channel + " )", "trace/channelTraceListener", (Object)this);
        }
        if (!(channel instanceof AbstractChannel)) {
            return;
        }
        String value = (String)channel.getRemotePeer().getAttributes().get("ValueAdd");
        boolean bl = isValueAdd = value != null && ("1".equals(value.trim()) || Boolean.parseBoolean(value.trim()));
        if (isValueAdd) {
            return;
        }
        boolean loggingEnabled = CoreBundleActivator.getScopedPreferences().getBoolean("te.tcf.log.core.enabled");
        if (!loggingEnabled) {
            return;
        }
        AbstractChannel.TraceListener traceListener = this.listeners.remove(channel);
        if (traceListener != null) {
            ((AbstractChannel)channel).removeTraceListener(traceListener);
        }
        traceListener = new ChannelTraceListener(channel);
        ((AbstractChannel)channel).addTraceListener(traceListener);
        this.listeners.put(channel, traceListener);
        String date = this.DATE_FORMAT.format(new Date(System.currentTimeMillis()));
        String message = NLS.bind((String)Messages.ChannelTraceListener_channelOpened_message, (Object[])new Object[]{date, Integer.toHexString(channel.hashCode())});
        FileWriter writer = LogManager.getInstance().getWriter(channel);
        if (writer != null) {
            try {
                writer.write("\n\n\n");
                writer.write(message);
                writer.write("\n");
                writer.flush();
            }
            catch (IOException iOException) {}
        }
        LogManager.getInstance().monitor(channel, MonitorEvent.Type.OPEN, new MonitorEvent.Message('F', message));
    }

    public void onChannelClosed(final IChannel channel) {
        Assert.isNotNull((Object)channel);
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        if (!(channel instanceof AbstractChannel)) {
            return;
        }
        final AbstractChannel.TraceListener traceListener = this.listeners.remove(channel);
        if (traceListener != null) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((AbstractChannel)channel).removeTraceListener(traceListener);
                }
            });
        }
    }

    private static class LazyInstanceHolder {
        public static ChannelTraceListenerManager instance = new ChannelTraceListenerManager();

        private LazyInstanceHolder() {
        }
    }
}

