/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.editor.tree.columns;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IUIService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IPendingOperationNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.ui.interfaces.IProcessMonitorUIDelegate;
import org.eclipse.tcf.te.tcf.processes.ui.navigator.runtime.AbstractLabelProviderDelegate;

public class PIDLabelProvider
extends AbstractLabelProviderDelegate {
    public String getText(Object element) {
        if (element instanceof IRuntimeModel || element instanceof IPendingOperationNode) {
            return "";
        }
        if (element instanceof IProcessContextNode) {
            IPeerNode peerNode;
            String id;
            final IProcessContextNode node = (IProcessContextNode)element;
            final AtomicLong pid = new AtomicLong();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (node.getSysMonitorContext() != null) {
                        pid.set(node.getSysMonitorContext().getPID());
                    }
                }
            };
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            Protocol.invokeAndWait((Runnable)runnable);
            String string = id = pid.get() >= 0L ? Long.toString(pid.get()) : "";
            if (id.startsWith("P")) {
                id = id.substring(1);
            }
            IUIService service = (peerNode = (IPeerNode)node.getAdapter(IPeerNode.class)) != null ? (IUIService)ServiceManager.getInstance().getService((Object)peerNode, IUIService.class) : null;
            IProcessMonitorUIDelegate delegate = service != null ? (IProcessMonitorUIDelegate)service.getDelegate((Object)peerNode, IProcessMonitorUIDelegate.class) : null;
            String newId = delegate != null ? delegate.getText(element, "PID", id) : null;
            return newId != null ? newId : id;
        }
        return "";
    }
}

