/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.editor;

import java.io.IOException;
import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.ISimulatorService;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerUtil;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.ui.editor.AbstractCustomFormToolkitEditorPage;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.sections.SimulatorTypeSelectionSection;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class AbstractConfigurationEditorPage
extends AbstractCustomFormToolkitEditorPage {
    SimulatorTypeSelectionSection simulatorTypeSelectionSection = null;
    private IEventListener listener = null;

    protected void setInput(IEditorInput input) {
        IEditorInput oldInput = this.getEditorInput();
        if (oldInput != null && oldInput.equals(input)) {
            return;
        }
        super.setInput(input);
        if (this.listener == null) {
            this.listener = new IEventListener(){

                public void eventFired(EventObject event) {
                    ChangeEvent changeEvent = (ChangeEvent)event;
                    if (("connectState".equals(changeEvent.getEventId()) || "valid".equals(changeEvent.getEventId())) && event.getSource() == AbstractConfigurationEditorPage.this.getEditorInputNode()) {
                        ExecutorsUtil.executeInUI((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (!AbstractConfigurationEditorPage.this.getManagedForm().getForm().isDisposed()) {
                                    AbstractConfigurationEditorPage.this.getManagedForm().getForm().setImage(AbstractConfigurationEditorPage.this.getFormImage());
                                }
                            }
                        });
                    }
                }
            };
            EventManager.getInstance().addEventListener(this.listener, ChangeEvent.class);
        }
    }

    protected void addTargetSelectorSection(IManagedForm form, Composite parent) {
        ISimulatorService service = (ISimulatorService)ServiceManager.getInstance().getService(this.getEditorInputNode(), ISimulatorService.class);
        if (service != null) {
            this.simulatorTypeSelectionSection = this.doCreateTargetSelectorSection(form, parent);
            if (this.simulatorTypeSelectionSection != null) {
                this.simulatorTypeSelectionSection.getSection().setLayoutData((Object)new TableWrapData(256, 16));
                this.getManagedForm().addPart((IFormPart)this.simulatorTypeSelectionSection);
            }
        }
    }

    protected SimulatorTypeSelectionSection getTargetSelectorSection() {
        return this.simulatorTypeSelectionSection;
    }

    protected SimulatorTypeSelectionSection doCreateTargetSelectorSection(IManagedForm form, Composite parent) {
        return new SimulatorTypeSelectionSection(this.getManagedForm(), parent);
    }

    public void dispose() {
        if (this.simulatorTypeSelectionSection != null) {
            this.simulatorTypeSelectionSection.dispose();
            this.simulatorTypeSelectionSection = null;
        }
        if (this.listener != null) {
            EventManager.getInstance().removeEventListener(this.listener);
            this.listener = null;
        }
        super.dispose();
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (this.simulatorTypeSelectionSection != null) {
            this.simulatorTypeSelectionSection.setActive(active);
        }
    }

    protected IValidatingContainer.ValidationResult doValidate() {
        IValidatingContainer.ValidationResult result = super.doValidate();
        if (this.simulatorTypeSelectionSection != null) {
            this.simulatorTypeSelectionSection.isValid();
            result.setResult((IMessageProvider)this.simulatorTypeSelectionSection);
        }
        return result;
    }

    public void postDoSave(IProgressMonitor monitor) {
        super.postDoSave(monitor);
        final Object input = this.getEditorInputNode();
        if (input instanceof IPeerNode) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                        if (uRIPersistenceService == null) {
                            throw new IOException("Persistence service instance unavailable.");
                        }
                        uRIPersistenceService.write((Object)((IPeerNode)input).getPeer(), null);
                    }
                    catch (IOException e) {
                        String template = NLS.bind((String)Messages.AbstractConfigurationEditorPage_error_save, (Object)((IPeerNode)input).getName(), (Object)Messages.AbstractConfigurationEditorPage_error_possibleCause);
                        StatusHandlerUtil.handleStatus((IStatus)StatusHelper.getStatus((Throwable)e), (Object)input, (String)template, null, (String)IContextHelpIds.MESSAGE_SAVE_FAILED, (Object)((Object)AbstractConfigurationEditorPage.this), null);
                    }
                }
            };
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            Protocol.invokeAndWait((Runnable)runnable);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((IPeerNode)input).fireChangeEvent("properties", null, (Object)((IPeerNode)input).getProperties());
                }
            });
        }
    }
}

