/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.ui.wizards.newWizard.NewWizard;
import org.eclipse.tcf.te.ui.wizards.newWizard.NewWizardRegistry;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.internal.navigator.wizards.CommonWizardDescriptor;
import org.eclipse.ui.internal.navigator.wizards.CommonWizardDescriptorManager;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class ConnectPeerCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object element;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window == null) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        Assert.isNotNull((Object)window);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IPeer) {
            System.setProperty("NewWizard_autoConnect", Boolean.TRUE.toString());
            IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
            if (part instanceof CommonNavigator) {
                CommonWizardDescriptor[] wizards = CommonWizardDescriptorManager.getInstance().getEnabledCommonWizardDescriptors(element, "new", ((CommonNavigator)part).getNavigatorContentService());
                if (wizards.length > 1) {
                    NewWizard wizard = new NewWizard("org.eclipse.tcf.te.tcf.ui.newWizards.category.configurations");
                    wizard.setWindowTitle(Messages.NewTargetWizardPage_title);
                    wizard.init(window.getWorkbench(), (IStructuredSelection)selection);
                    WizardDialog dialog = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IWizard)wizard);
                    dialog.create();
                    dialog.getShell().setSize(Math.max(400, dialog.getShell().getSize().x), 500);
                    window.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), IContextHelpIds.NEW_TARGET_WIZARD);
                    dialog.open();
                } else if (wizards.length == 1) {
                    IWizardDescriptor wizardDesc = NewWizardRegistry.getInstance().findWizard(wizards[0].getWizardId());
                    new NewWizardShortcutAction(window, wizardDesc).run();
                }
            }
            System.clearProperty("NewWizard_autoConnect");
        }
        return null;
    }
}

