/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.services.interfaces.delegates.ILabelProviderDelegate;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelLookupService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.navigator.images.PeerNodeImageDescriptor;
import org.eclipse.tcf.te.tcf.ui.navigator.nodes.PeerRedirectorGroupNode;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;

public class PeerLabelProviderDelegate
extends LabelProvider
implements ILabelDecorator,
ILabelProviderDelegate {
    public String getText(final Object element) {
        if (element instanceof IPeerNode || element instanceof IPeer) {
            String label;
            StringBuilder builder = new StringBuilder();
            final HashMap attrs = new HashMap();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (element instanceof IPeerNode) {
                        attrs.putAll(((IPeerNode)element).getProperties());
                        attrs.putAll(((IPeerNode)element).getPeer().getAttributes());
                    } else if (element instanceof IPeer) {
                        attrs.putAll(((IPeer)element).getAttributes());
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            builder.append((String)attrs.get("Name"));
            if (this.isAppendAddressText(builder.toString())) {
                String dnsName = (String)attrs.get("dns.name.transient");
                String ip = (String)attrs.get("Host");
                String port = (String)attrs.get("Port");
                if (ip != null && !"".equals(ip.trim())) {
                    builder.append(" ");
                    if (!IPAddressUtil.getInstance().isLocalHost(ip)) {
                        builder.append(dnsName != null && !"".equals(dnsName.trim()) ? dnsName.trim() : ip.trim());
                    }
                    if (port != null && !"".equals(port.trim()) && !"1534".equals(port.trim())) {
                        builder.append(":");
                        builder.append(port.trim());
                    }
                }
            }
            if (!"".equals((label = builder.toString()).trim())) {
                return label;
            }
        } else if (element instanceof PeerRedirectorGroupNode) {
            return Messages.RemotePeerDiscoveryRootNode_label;
        }
        return null;
    }

    protected boolean isAppendAddressText(final String label) {
        boolean append;
        Assert.isNotNull((Object)label);
        boolean bl = append = "TCF Agent".equals(label) || "TCF Proxy".equals(label);
        if (!append) {
            final AtomicInteger count = new AtomicInteger();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    count.set(((IPeerModelLookupService)ModelManager.getPeerModel().getService(IPeerModelLookupService.class)).lkupPeerModelByName(label).length);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            append = count.get() > 1;
        }
        return append;
    }

    public Image getImage(Object element) {
        if (element instanceof IPeerNode) {
            return UIPlugin.getImage("ConnectionObject");
        }
        if (element instanceof IPeer) {
            return UIPlugin.getImage("PeerObjectDiscovered");
        }
        if (element instanceof PeerRedirectorGroupNode) {
            return UIPlugin.getImage("RemotePeerDiscoverRootNodeObject");
        }
        return super.getImage(element);
    }

    public Image decorateImage(Image image, Object element) {
        Image decoratedImage = image;
        if (image != null && element instanceof IPeerNode) {
            PeerNodeImageDescriptor descriptor = new PeerNodeImageDescriptor(UIPlugin.getDefault().getImageRegistry(), image, (IPeerNode)element);
            decoratedImage = UIPlugin.getSharedImage(descriptor);
        }
        return decoratedImage;
    }

    public String decorateText(String text, Object element) {
        return null;
    }
}

