/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.sections;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;
import org.eclipse.tcf.te.tcf.ui.controls.SimulatorTypeSelectionControl;
import org.eclipse.tcf.te.tcf.ui.dialogs.PeerSelectionDialog;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SimulatorTypeSelectionSection
extends AbstractSection
implements IDataExchangeNode {
    BaseEditBrowseTextControl target;
    SimulatorTypeSelectionControl simulator;
    IPeerNode od;
    final IPropertiesContainer odc = new PropertiesContainer();
    final IPropertiesContainer wc = new PropertiesContainer();
    protected static final int SELECTION_REAL = 0;
    protected static final int SELECTION_SIM = 1;
    protected String selectedPeerId = null;

    public SimulatorTypeSelectionSection(IManagedForm form, Composite parent) {
        super(form, parent, 0);
        this.createClient(this.getSection(), form.getToolkit());
    }

    public SimulatorTypeSelectionSection(IManagedForm form, Composite parent, int style) {
        super(form, parent, style);
        this.createClient(this.getSection(), form.getToolkit());
    }

    public Object getOriginalData() {
        return this.od;
    }

    public void dispose() {
        if (this.simulator != null) {
            this.simulator.dispose();
            this.simulator = null;
        }
        super.dispose();
    }

    public IValidatingContainer getValidatingContainer() {
        Object container = this.getManagedForm().getContainer();
        return container instanceof IValidatingContainer ? (IValidatingContainer)container : null;
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.TargetSelectorSection_title);
        if (section.getParent().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        Composite client = this.createClientContainer((Composite)section, 3, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        this.target = new BaseEditBrowseTextControl(null){

            public IValidatingContainer getValidatingContainer() {
                return SimulatorTypeSelectionSection.this.getValidatingContainer();
            }

            protected void onLabelControlSelectedChanged() {
                super.onLabelControlSelectedChanged();
                if (SimulatorTypeSelectionSection.this.target.isLabelControlSelected()) {
                    SimulatorTypeSelectionSection.this.onSelectionChanged(0);
                    if (!SimulatorTypeSelectionSection.this.isUpdating()) {
                        SimulatorTypeSelectionSection.this.onPeerChanged(false, true, SimulatorTypeSelectionSection.this.selectedPeerId, SimulatorTypeSelectionSection.this.selectedPeerId);
                    }
                }
            }

            protected void onButtonControlSelected() {
                ISelection selection;
                PeerSelectionDialog dialog = new PeerSelectionDialog(null){

                    @Override
                    protected String getDialogTitle() {
                        return Messages.NewTargetWizardPage_PeerSelectionDialog_dialogTitle;
                    }

                    @Override
                    protected String getTitle() {
                        return Messages.NewTargetWizardPage_PeerSelectionDialog_title;
                    }

                    @Override
                    protected String getDefaultMessage() {
                        return Messages.NewTargetWizardPage_PeerSelectionDialog_message;
                    }

                    @Override
                    protected void configureTableViewer(TableViewer viewer) {
                        super.configureTableViewer(viewer);
                        viewer.setFilters(SimulatorTypeSelectionSection.this.getViewerFilters());
                    }
                };
                if (dialog.open() == 0 && (selection = dialog.getSelection()) instanceof IStructuredSelection && !selection.isEmpty() && ((IStructuredSelection)selection).getFirstElement() instanceof IPeer) {
                    String oldPeerId = SimulatorTypeSelectionSection.this.selectedPeerId;
                    IPeer selectedPeer = (IPeer)((IStructuredSelection)selection).getFirstElement();
                    SimulatorTypeSelectionSection.this.selectedPeerId = selectedPeer != null ? selectedPeer.getID() : null;
                    SimulatorTypeSelectionSection.this.dataChanged(null);
                    SimulatorTypeSelectionSection.this.onPeerChanged(this.isLabelControlSelected(), this.isLabelControlSelected(), oldPeerId, SimulatorTypeSelectionSection.this.selectedPeerId);
                }
            }
        };
        this.target.setLabelIsButton(true);
        this.target.setLabelButtonStyle(16);
        this.target.setParentControlIsInnerPanel(true);
        this.target.setEditFieldLabel(Messages.TargetSelectorSection_button_enableReal);
        this.target.setHasHistory(false);
        this.target.setHideEditFieldControl(true);
        this.target.setReadOnly(true);
        this.target.setupPanel(client);
        this.simulator = new SimulatorTypeSelectionControl(this){

            @Override
            protected void onLabelControlSelectedChanged() {
                super.onLabelControlSelectedChanged();
                if (SimulatorTypeSelectionSection.this.simulator.isLabelControlSelected()) {
                    SimulatorTypeSelectionSection.this.onSelectionChanged(1);
                    if (!SimulatorTypeSelectionSection.this.isUpdating()) {
                        SimulatorTypeSelectionSection.this.onSimulatorChanged(false, true, this.getSelectedSimulatorId(), this.getSelectedSimulatorId(), this.getSimulatorConfig(), this.getSimulatorConfig());
                    }
                }
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                String newId = this.getSelectedSimulatorId();
                SimulatorTypeSelectionSection.this.onSimulatorChanged(this.isLabelControlSelected(), this.isLabelControlSelected(), null, newId, this.getSimulatorConfig(), this.getSimulatorConfig());
            }

            @Override
            protected void onButtonControlSelected() {
                String oldConfig = this.getSimulatorConfig();
                super.onButtonControlSelected();
                String newConfig = this.getSimulatorConfig();
                if (newConfig != null && !newConfig.equals(oldConfig) || newConfig == null && oldConfig != null) {
                    SimulatorTypeSelectionSection.this.onSimulatorChanged(this.isLabelControlSelected(), this.isLabelControlSelected(), this.getSelectedSimulatorId(), this.getSelectedSimulatorId(), oldConfig, newConfig);
                }
            }
        };
        this.simulator.setLabelIsButton(true);
        this.simulator.setLabelButtonStyle(16);
        this.simulator.setEditFieldLabel(Messages.TargetSelectorSection_button_enableSimulator);
        this.simulator.setParentControlIsInnerPanel(true);
        this.simulator.setupPanel(client);
        this.updateEnablement();
        this.setIsUpdating(false);
    }

    protected void onSelectionChanged(int selectionType) {
    }

    protected void onSimulatorChanged(boolean oldEnabled, boolean newEnabled, String oldType, String newType, String oldConfig, String newConfig) {
    }

    protected void onPeerChanged(boolean oldEnabled, boolean newEnabled, String oldPeerId, String newPeerId) {
    }

    public void setActive(boolean active) {
        if (active) {
            Object node;
            if (this.getManagedForm().getContainer() instanceof AbstractEditorPage && !((AbstractEditorPage)this.getManagedForm().getContainer()).isDirty() && (node = ((AbstractEditorPage)this.getManagedForm().getContainer()).getEditorInputNode()) instanceof IPeerNode) {
                this.setupData((IPeerNode)node);
            }
        } else {
            this.dataChanged(null);
        }
    }

    public void setupData(IPropertiesContainer data) {
        this.setIsUpdating(true);
        if (this.simulator != null) {
            this.simulator.initialize(this.od);
            this.simulator.setSelectedSimulatorId(data.getStringProperty("SimulatorType"));
            this.simulator.setSimulatorConfig(data.getStringProperty("SimulatorProperties"));
            this.simulator.setLabelControlSelection(data.getBooleanProperty("SimulatorEnabled"));
        }
        if (this.target != null) {
            this.target.setLabelControlSelection(!data.getBooleanProperty("SimulatorEnabled"));
            this.selectedPeerId = data.getStringProperty("PeerId");
        }
        this.onSelectionChanged(data.getBooleanProperty("SimulatorEnabled") ? 1 : 0);
        this.setIsUpdating(false);
        this.dataChanged(null);
    }

    public void setupData(final IPeerNode node) {
        if (this.isDirty()) {
            return;
        }
        boolean updateWidgets = true;
        if (node == null && this.od == null || node != null && node.equals(this.od)) {
            updateWidgets = false;
        }
        PropertiesContainer previousOdc = new PropertiesContainer();
        previousOdc.setProperties(this.odc.getProperties());
        this.od = node;
        this.odc.clearProperties();
        this.wc.clearProperties();
        if (node == null) {
            return;
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                SimulatorTypeSelectionSection.this.odc.setProperty("SimulatorEnabled", node.getPeer().getAttributes().get("SimulatorEnabled"));
                SimulatorTypeSelectionSection.this.odc.setProperty("SimulatorProperties", node.getPeer().getAttributes().get("SimulatorProperties"));
                SimulatorTypeSelectionSection.this.odc.setProperty("SimulatorType", node.getPeer().getAttributes().get("SimulatorType"));
                SimulatorTypeSelectionSection.this.odc.setProperty("PeerId", node.getPeer().getAttributes().get("PeerId"));
                SimulatorTypeSelectionSection.this.wc.setProperties(SimulatorTypeSelectionSection.this.odc.getProperties());
            }
        });
        if (!previousOdc.getProperties().equals(this.odc.getProperties())) {
            updateWidgets = true;
        }
        if (updateWidgets) {
            this.setupData(this.wc);
        } else {
            this.dataChanged(null);
        }
    }

    public void extractData(IPropertiesContainer data) {
        Assert.isNotNull((Object)data);
        if (this.target != null) {
            data.setProperty("SimulatorEnabled", this.target.isLabelControlSelected());
        }
        data.setProperty("PeerId", (Object)this.selectedPeerId);
        if (this.simulator != null) {
            data.setProperty("SimulatorEnabled", this.simulator.isLabelControlSelected());
            data.setProperty("SimulatorType", (Object)this.simulator.getSelectedSimulatorId());
            data.setProperty("SimulatorProperties", (Object)this.simulator.getSimulatorConfig());
        }
    }

    public void extractData(final IPeerNode node) {
        if (node == null) {
            return;
        }
        this.extractData(this.wc);
        if (this.odc.equals(this.wc)) {
            return;
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean isSimEnabled = SimulatorTypeSelectionSection.this.wc.getBooleanProperty("SimulatorEnabled");
                String configs = SimulatorTypeSelectionSection.this.wc.getStringProperty("SimulatorProperties");
                String type = SimulatorTypeSelectionSection.this.wc.getStringProperty("SimulatorType");
                IPeer oldPeer = node.getPeer();
                HashMap<String, String> attributes = new HashMap<String, String>(oldPeer.getAttributes());
                if (isSimEnabled) {
                    attributes.put("SimulatorEnabled", Boolean.toString(isSimEnabled));
                } else {
                    attributes.remove("SimulatorEnabled");
                    attributes.put("PeerId", SimulatorTypeSelectionSection.this.selectedPeerId);
                }
                if (SimulatorTypeSelectionSection.this.selectedPeerId != null) {
                    attributes.put("PeerId", SimulatorTypeSelectionSection.this.selectedPeerId);
                } else {
                    attributes.remove("PeerId");
                }
                if (configs != null) {
                    attributes.put("SimulatorProperties", configs);
                } else {
                    attributes.remove("SimulatorProperties");
                }
                if (type != null) {
                    attributes.put("SimulatorType", type);
                } else {
                    attributes.remove("SimulatorType");
                }
                if (oldPeer instanceof TransientPeer && !(oldPeer instanceof PeerRedirector) && !(oldPeer instanceof Peer)) {
                    Peer newPeer = new Peer(attributes);
                    node.setProperty("instance", (Object)newPeer);
                } else if (oldPeer instanceof PeerRedirector) {
                    ((PeerRedirector)oldPeer).updateAttributes(attributes);
                } else if (oldPeer instanceof Peer) {
                    ((Peer)oldPeer).updateAttributes(attributes);
                }
            }
        });
    }

    public boolean isValid() {
        if (this.isUpdating()) {
            return true;
        }
        boolean valid = super.isValid();
        if (this.simulator != null && this.simulator.isLabelControlSelected()) {
            valid &= this.simulator.isValid();
            if (this.simulator.getMessageType() > this.getMessageType()) {
                this.setMessage(this.simulator.getMessage(), this.simulator.getMessageType());
            }
        }
        return valid;
    }

    public void commit(boolean onSave) {
        boolean needsSaving = this.isDirty();
        super.commit(onSave);
        if (!onSave || !needsSaving) {
            return;
        }
        this.extractData((IPeerNode)this.getManagedForm().getInput());
    }

    public void dataChanged(TypedEvent e) {
        if (this.isUpdating()) {
            return;
        }
        boolean isDirty = false;
        if (this.target != null) {
            boolean oldEnabled = !this.odc.getBooleanProperty("SimulatorEnabled");
            isDirty |= oldEnabled ^ this.target.isLabelControlSelected();
        }
        String oldPeerId = this.odc.getStringProperty("PeerId");
        String newPeerId = this.selectedPeerId;
        isDirty = newPeerId == null || "".equals(newPeerId) ? (isDirty |= oldPeerId != null && !"".equals(oldPeerId)) : (isDirty |= !newPeerId.equals(oldPeerId));
        if (this.simulator != null && this.simulator.isLabelControlSelected()) {
            String newType = this.simulator.getSelectedSimulatorId();
            String oldType = this.odc.getStringProperty("SimulatorType");
            isDirty = newType == null || "".equals(newType) ? (isDirty |= oldType != null && !"".equals(oldType)) : (isDirty |= !newType.equals(oldType));
            String newConfig = this.simulator.getSimulatorConfig();
            String oldConfig = this.odc.getStringProperty("SimulatorProperties");
            isDirty = newConfig == null || "".equals(newConfig) ? (isDirty |= oldConfig != null && !"".equals(oldConfig)) : (isDirty |= !newConfig.equals(oldConfig));
        }
        this.markDirty(isDirty);
        this.updateEnablement();
    }

    public Object getAdapter(Class adapter) {
        if (SimulatorTypeSelectionControl.class.equals((Object)adapter)) {
            return this.simulator;
        }
        return super.getAdapter(adapter);
    }

    protected void updateEnablement() {
        boolean enabled;
        boolean bl = enabled = this.od == null || this.od.getConnectState() == 1;
        if (this.target != null) {
            SWTControlUtil.setEnabled((Control)this.target.getLabelControl(), (boolean)enabled);
            SWTControlUtil.setEnabled((Control)this.target.getEditFieldControl(), (this.target.isLabelControlSelected() && enabled ? 1 : 0) != 0);
            SWTControlUtil.setEnabled((Control)this.target.getButtonControl(), (this.target.isLabelControlSelected() && enabled ? 1 : 0) != 0);
        }
        if (this.simulator != null) {
            SWTControlUtil.setEnabled((Control)this.simulator.getLabelControl(), (boolean)enabled);
            SWTControlUtil.setEnabled((Control)this.simulator.getEditFieldControl(), (this.simulator.isLabelControlSelected() && enabled ? 1 : 0) != 0);
        }
    }

    protected ViewerFilter[] getViewerFilters() {
        return new ViewerFilter[0];
    }
}

