/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.local.launcher;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.ITerminalService;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.terminals.interfaces.IConfigurationPanel;
import org.eclipse.tcf.te.ui.terminals.interfaces.IMementoHandler;
import org.eclipse.tcf.te.ui.terminals.launcher.AbstractLauncherDelegate;
import org.eclipse.tcf.te.ui.terminals.local.controls.LocalWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.terminals.local.launcher.LocalMementoHandler;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;

public class LocalLauncherDelegate
extends AbstractLauncherDelegate {
    private final IMementoHandler mementoHandler = new LocalMementoHandler();

    public boolean needsUserConfiguration() {
        return false;
    }

    public IConfigurationPanel getPanel(BaseDialogPageControl parentControl) {
        return new LocalWizardConfigurationPanel(parentControl);
    }

    public void execute(IPropertiesContainer properties, ICallback callback) {
        ITerminalService terminal;
        ISelection selection;
        ISelectionService service;
        String home;
        Assert.isNotNull((Object)properties);
        String terminalTitle = this.getTerminalTitle(properties);
        if (terminalTitle != null) {
            properties.setProperty("title", (Object)terminalTitle);
        }
        if (!properties.containsKey("encoding")) {
            String encoding = null;
            encoding = "macosx".equals(Platform.getOS()) ? "UTF-8" : WorkbenchEncoding.getWorkbenchDefaultEncoding();
            if (encoding != null && !"".equals(encoding)) {
                properties.setProperty("encoding", (Object)encoding);
            }
        }
        if (!properties.containsKey("terminal.forceNew")) {
            properties.setProperty("terminal.forceNew", true);
        }
        if ((home = System.getProperty("user.home")) != null && !"".equals(home)) {
            properties.setProperty("process.working_dir", (Object)home);
        }
        if ((service = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService()) != null && service.getSelection() != null && (selection = service.getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
            String dir = null;
            for (Object element : (IStructuredSelection)selection) {
                IPath location;
                if (!(element instanceof IResource) || !((IResource)element).exists() || (location = ((IResource)element).getLocation()) == null) continue;
                if (location.toFile().isFile()) {
                    location = location.removeLastSegments(1);
                }
                if (!location.toFile().isDirectory() || !location.toFile().canRead()) continue;
                dir = location.toFile().getAbsolutePath();
                break;
            }
            if (dir != null) {
                properties.setProperty("process.working_dir", dir);
                String basename = new Path(dir).lastSegment();
                properties.setProperty("title", (Object)(String.valueOf(basename) + " (" + terminalTitle + ")"));
            }
        }
        if ((terminal = (ITerminalService)ServiceManager.getInstance().getService(ITerminalService.class)) != null) {
            terminal.openConsole(properties, callback);
        }
    }

    private String getTerminalTitle(IPropertiesContainer properties) {
        String[] hostNames = IPAddressUtil.getInstance().getCanonicalHostNames();
        if (hostNames.length != 0) {
            return hostNames[0];
        }
        return "Local";
    }

    public Object getAdapter(Class adapter) {
        if (IMementoHandler.class.equals((Object)adapter)) {
            return this.mementoHandler;
        }
        return super.getAdapter(adapter);
    }
}

