/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.local.types;

import java.io.File;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.services.interfaces.ITerminalServiceOutputStreamMonitorListener;
import org.eclipse.tcf.te.runtime.utils.Host;
import org.eclipse.tcf.te.ui.terminals.internal.SettingsStore;
import org.eclipse.tcf.te.ui.terminals.process.ProcessSettings;
import org.eclipse.tcf.te.ui.terminals.types.AbstractConnectorType;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;

public class LocalConnectorType
extends AbstractConnectorType {
    private final File defaultShell() {
        String shell = null;
        if (Host.isWindowsHost()) {
            shell = System.getenv("ComSpec") != null && !"".equals(System.getenv("ComSpec").trim()) ? System.getenv("ComSpec").trim() : "cmd.exe";
        }
        if (shell == null) {
            shell = System.getenv("SHELL") != null && !"".equals(System.getenv("SHELL").trim()) ? System.getenv("SHELL").trim() : "/bin/sh";
        }
        return new File(shell);
    }

    public ITerminalConnector createTerminalConnector(IPropertiesContainer properties) {
        File defaultShell;
        Assert.isNotNull((Object)properties);
        String connectorId = properties.getStringProperty("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.tcf.te.ui.terminals.local.LocalConnector";
        }
        String image = !properties.containsKey("process.path") || properties.getStringProperty("process.path") == null ? ((defaultShell = this.defaultShell()).isAbsolute() ? defaultShell.getAbsolutePath() : defaultShell.getPath()) : properties.getStringProperty("process.path");
        boolean isUsingPTY = properties.getProperty("process") == null && PTY.isSupported((PTY.Mode)PTY.Mode.TERMINAL) || properties.getProperty("pty") instanceof PTY;
        boolean localEcho = false;
        if (!properties.containsKey("localEcho") || properties.getStringProperty("localEcho") == null) {
            if (Host.isWindowsHost()) {
                localEcho = !isUsingPTY;
            }
        } else {
            localEcho = properties.getBooleanProperty("localEcho");
        }
        String lineSeparator = null;
        if (!properties.containsKey("lineSeparator") || properties.getStringProperty("lineSeparator") == null) {
            if (!isUsingPTY) {
                lineSeparator = Host.isWindowsHost() ? "\\r\\n" : "\\n";
            }
        } else {
            lineSeparator = properties.getStringProperty("lineSeparator");
        }
        String arguments = properties.getStringProperty("process.args");
        Process process = (Process)properties.getProperty("process");
        PTY pty = (PTY)properties.getProperty("pty");
        ITerminalServiceOutputStreamMonitorListener[] stdoutListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.getProperty("stdoutListeners");
        ITerminalServiceOutputStreamMonitorListener[] stderrListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.getProperty("stderrListeners");
        String workingDir = properties.getStringProperty("process.working_dir");
        String[] envp = null;
        if (properties.containsKey("process.environment") && properties.getProperty("process.environment") != null && properties.getProperty("process.environment") instanceof String[]) {
            envp = (String[])properties.getProperty("process.environment");
        }
        Assert.isTrue((image != null || process != null ? 1 : 0) != 0);
        SettingsStore store = new SettingsStore();
        ProcessSettings processSettings = new ProcessSettings();
        processSettings.setImage(image);
        processSettings.setArguments(arguments);
        processSettings.setProcess(process);
        processSettings.setPTY(pty);
        processSettings.setLocalEcho(localEcho);
        processSettings.setLineSeparator(lineSeparator);
        processSettings.setStdOutListeners(stdoutListeners);
        processSettings.setStdErrListeners(stderrListeners);
        processSettings.setWorkingDir(workingDir);
        processSettings.setEnvironment(envp);
        if (properties.containsKey("process.environment.merge")) {
            processSettings.setMergeWithNativeEnvironment(properties.getBooleanProperty("process.environment.merge"));
        }
        processSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.makeSettingsPage();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

