/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tcf.te.ui.trees.AbstractContentContribution;
import org.eclipse.tcf.te.ui.trees.AbstractTreeControl;
import org.eclipse.tcf.te.ui.trees.ColumnDescriptor;
import org.eclipse.tcf.te.ui.trees.ContentDescriptor;
import org.eclipse.tcf.te.ui.trees.Pending;
import org.eclipse.tcf.te.ui.trees.PendingAwareLabelProvider;

public class TreeViewerLabelProvider
extends PendingAwareLabelProvider
implements ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private TreeViewer viewer;
    private final AbstractTreeControl parentTreeControl;

    public TreeViewerLabelProvider(AbstractTreeControl parentTreeControl, TreeViewer viewer) {
        Assert.isNotNull((Object)((Object)parentTreeControl));
        this.parentTreeControl = parentTreeControl;
        this.viewer = viewer;
    }

    private ColumnDescriptor getColumn(int columnIndex) {
        Tree tree = this.viewer.getTree();
        TreeColumn column = tree.getColumn(columnIndex);
        ColumnDescriptor descriptor = (ColumnDescriptor)column.getData();
        return descriptor;
    }

    @Override
    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    @Override
    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof Pending) {
            return columnIndex == 0 ? super.getImage(element) : null;
        }
        ColumnDescriptor column = this.getColumn(columnIndex);
        if (column != null) {
            ILabelProvider labelProvider;
            ContentDescriptor[] descriptors = this.parentTreeControl.getContentDescriptors();
            if (descriptors != null) {
                ContentDescriptor[] contentDescriptorArray = descriptors;
                int n = descriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentDescriptor descriptor = contentDescriptorArray[n2];
                    AbstractContentContribution contribution = descriptor.getContentContribution();
                    if (contribution != null && contribution.isElementHandled(element)) {
                        return contribution.getColumnImage(column.getId(), element);
                    }
                    ++n2;
                }
            }
            if ((labelProvider = column.getLabelProvider()) != null) {
                return labelProvider.getImage(element);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof Pending) {
            return columnIndex == 0 ? super.getText(element) : "";
        }
        ColumnDescriptor column = this.getColumn(columnIndex);
        if (column != null) {
            ILabelProvider labelProvider;
            ContentDescriptor[] descriptors = this.parentTreeControl.getContentDescriptors();
            if (descriptors != null) {
                ContentDescriptor[] contentDescriptorArray = descriptors;
                int n = descriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentDescriptor descriptor = contentDescriptorArray[n2];
                    AbstractContentContribution contribution = descriptor.getContentContribution();
                    if (contribution != null && contribution.isElementHandled(element)) {
                        return contribution.getColumnText(column.getId(), element);
                    }
                    ++n2;
                }
            }
            if ((labelProvider = column.getLabelProvider()) != null) {
                return labelProvider.getText(element);
            }
        }
        return "";
    }

    public Font getFont(Object element, int columnIndex) {
        ColumnDescriptor column;
        if (!(element instanceof Pending) && (column = this.getColumn(columnIndex)) != null) {
            ILabelProvider labelProvider;
            ContentDescriptor[] descriptors = this.parentTreeControl.getContentDescriptors();
            if (descriptors != null) {
                ContentDescriptor[] contentDescriptorArray = descriptors;
                int n = descriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentDescriptor descriptor = contentDescriptorArray[n2];
                    AbstractContentContribution contribution = descriptor.getContentContribution();
                    if (contribution != null && contribution.isElementHandled(element) && contribution instanceof IFontProvider) {
                        return ((IFontProvider)contribution).getFont(element);
                    }
                    ++n2;
                }
            }
            if ((labelProvider = column.getLabelProvider()) instanceof IFontProvider) {
                return ((IFontProvider)labelProvider).getFont(element);
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        ColumnDescriptor column;
        if (!(element instanceof Pending) && (column = this.getColumn(columnIndex)) != null) {
            ILabelProvider labelProvider;
            ContentDescriptor[] descriptors = this.parentTreeControl.getContentDescriptors();
            if (descriptors != null) {
                ContentDescriptor[] contentDescriptorArray = descriptors;
                int n = descriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentDescriptor descriptor = contentDescriptorArray[n2];
                    AbstractContentContribution contribution = descriptor.getContentContribution();
                    if (contribution != null && contribution.isElementHandled(element) && contribution instanceof IColorProvider) {
                        return ((IColorProvider)contribution).getForeground(element);
                    }
                    ++n2;
                }
            }
            if ((labelProvider = column.getLabelProvider()) instanceof IColorProvider) {
                return ((IColorProvider)labelProvider).getForeground(element);
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        ColumnDescriptor column;
        if (!(element instanceof Pending) && (column = this.getColumn(columnIndex)) != null) {
            ILabelProvider labelProvider;
            ContentDescriptor[] descriptors = this.parentTreeControl.getContentDescriptors();
            if (descriptors != null) {
                ContentDescriptor[] contentDescriptorArray = descriptors;
                int n = descriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentDescriptor descriptor = contentDescriptorArray[n2];
                    AbstractContentContribution contribution = descriptor.getContentContribution();
                    if (contribution != null && contribution.isElementHandled(element) && contribution instanceof IColorProvider) {
                        return ((IColorProvider)contribution).getBackground(element);
                    }
                    ++n2;
                }
            }
            if ((labelProvider = column.getLabelProvider()) instanceof IColorProvider) {
                return ((IColorProvider)labelProvider).getBackground(element);
            }
        }
        return null;
    }
}

