/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class FileReplaceListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1 || event.getType() == 8) {
            try {
                final ArrayList added = new ArrayList();
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        int kind;
                        if (delta.getResource().getType() == 1 && ((kind = delta.getKind()) == 1 || kind == 4)) {
                            added.add((IFile)delta.getResource());
                        }
                        return true;
                    }
                });
                if (!added.isEmpty()) {
                    this.processResources(added.toArray(new IResource[0]));
                }
            }
            catch (CoreException e) {
                LoggedOperation.reportError(this.getClass().getName(), e);
            }
        }
    }

    protected void processResources(IResource[] resources) {
        AbstractWorkingCopyOperation mainOp = new AbstractWorkingCopyOperation("Operation_FileReplaceListener", SVNMessages.class, resources){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                IResource[] iResourceArray = this.operableData();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource file = iResourceArray[n2];
                    if (monitor.isCanceled()) {
                        return;
                    }
                    ILocalResource local = SVNRemoteStorage.instance().asLocalResource(file);
                    if (IStateFilter.SF_PREREPLACEDREPLACED.accept(local)) {
                        IContainer parent = file.getParent();
                        ILocalResource localParent = SVNRemoteStorage.instance().asLocalResource((IResource)parent);
                        if (!IStateFilter.SF_DELETED.accept(localParent)) {
                            File originalFile = new File(FileUtility.getWorkingCopyPath(file));
                            File tmpFile = new File(originalFile + ".svntmp");
                            try {
                                IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(file);
                                ISVNConnector proxy = location.acquireSVNProxy();
                                FileOutputStream oStream = null;
                                try {
                                    oStream = new FileOutputStream(tmpFile);
                                    proxy.streamFileContent(new SVNEntryRevisionReference(originalFile.getAbsolutePath(), null, SVNRevision.BASE), 8192, oStream, new SVNProgressMonitor(this, monitor, null));
                                    if (this.equals(originalFile, tmpFile)) {
                                        originalFile.delete();
                                        proxy.revert(originalFile.getAbsolutePath(), 0, null, new SVNProgressMonitor(this, monitor, null));
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (oStream != null) {
                                        try {
                                            oStream.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    location.releaseSVNProxy(proxy);
                                    throw throwable;
                                }
                                if (oStream != null) {
                                    try {
                                        oStream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                location.releaseSVNProxy(proxy);
                            }
                            finally {
                                if (!originalFile.exists()) {
                                    tmpFile.renameTo(originalFile);
                                } else {
                                    tmpFile.delete();
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }

            /*
             * Exception decompiling
             */
            protected boolean equals(File src1, File src2) throws IOException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[WHILELOOP]], but top level block is 3[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        CompositeOperation cmpOp = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        cmpOp.add(mainOp);
        cmpOp.add(new RefreshResourcesOperation(resources));
        ProgressMonitorUtility.doTaskScheduledDefault(cmpOp);
    }
}

