/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNEntryInfoCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStatusOperation
extends AbstractFileOperation {
    protected SVNChangeStatus[] statuses;
    protected boolean recursive;

    public AbstractStatusOperation(String operationName, Class<? extends NLS> messagesClass, File[] files, boolean recursive) {
        super(operationName, messagesClass, files);
        this.recursive = recursive;
    }

    public AbstractStatusOperation(String operationName, Class<? extends NLS> messagesClass, IFileProvider provider, boolean recursive) {
        super(operationName, messagesClass, provider);
        this.recursive = recursive;
    }

    public SVNChangeStatus[] getStatuses() {
        return this.statuses;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        final ArrayList result = new ArrayList();
        final ArrayList conflicts = new ArrayList();
        ISVNEntryStatusCallback cb = new ISVNEntryStatusCallback(){

            public void next(SVNChangeStatus status) {
                result.add(status);
                if (status.hasConflict && status.treeConflicts == null) {
                    conflicts.add(status);
                }
            }
        };
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(files[i], false);
            IRepositoryLocation location = remote.getRepositoryLocation();
            final ISVNConnector proxy = location.acquireSVNProxy();
            conflicts.clear();
            this.reportStatuses(proxy, cb, files[i], monitor, files.length);
            Iterator it = conflicts.iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                final SVNChangeStatus svnChangeStatus = (SVNChangeStatus)it.next();
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        proxy.getInfo(new SVNEntryRevisionReference(svnChangeStatus.path), 0, null, new ISVNEntryInfoCallback(){

                            public void next(SVNEntryInfo info) {
                                svnChangeStatus.treeConflicts = info.treeConflicts;
                            }
                        }, new SVNProgressMonitor(AbstractStatusOperation.this, monitor, null, false));
                    }
                }, monitor, files.length);
            }
            location.releaseSVNProxy(proxy);
            ++i;
        }
        this.statuses = result.toArray(new SVNChangeStatus[result.size()]);
    }

    protected void reportStatuses(final ISVNConnector proxy, final ISVNEntryStatusCallback cb, final File current, IProgressMonitor monitor, int tasks) {
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                proxy.status(current.getAbsolutePath(), SVNDepth.infinityOrImmediates(AbstractStatusOperation.this.recursive), AbstractStatusOperation.this.isRemote() ? 64L : 0L, null, cb, new SVNProgressMonitor(AbstractStatusOperation.this, monitor, null, false));
            }
        }, monitor, tasks);
    }

    protected abstract boolean isRemote();
}

