/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryResource;

public class CreatePatchOperation
extends AbstractFileOperation {
    protected String fileName;
    protected boolean useRelativePath;
    protected int depth;
    protected long options;
    protected long diffOptions;

    public CreatePatchOperation(File file, String fileName, boolean recurse, boolean ignoreDeleted, boolean processBinary, boolean useRelativePath) {
        this(file, fileName, SVNDepth.infinityOrFiles(recurse), (ignoreDeleted ? 8192L : 0L) | (processBinary ? 4L : 0L), useRelativePath, 0L);
    }

    public CreatePatchOperation(File file, String fileName, int depth, long options, boolean useRelativePath, long diffOptions) {
        super("Operation_CreatePatchFile", SVNMessages.class, new File[]{file});
        this.fileName = fileName;
        this.depth = depth;
        this.options = options | 0x200L;
        this.useRelativePath = useRelativePath;
        this.diffOptions = diffOptions;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File file = this.operableData()[0];
        IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(file, false);
        ISVNConnector proxy = remote.getRepositoryLocation().acquireSVNProxy();
        try {
            this.writeToConsole(0, "svn diff " + (this.depth == 3 ? "" : " -N") + ISVNConnector.Options.asCommandLine(this.options) + "\n");
            String path = file.getAbsolutePath();
            proxy.diffTwo(new SVNEntryRevisionReference(path, null, SVNRevision.BASE), new SVNEntryRevisionReference(path, null, SVNRevision.WORKING), this.useRelativePath ? path : null, this.fileName, this.depth, this.options, null, this.diffOptions, (ISVNProgressMonitor)new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            remote.getRepositoryLocation().releaseSVNProxy(proxy);
        }
    }
}

