/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;

public class AddToSVNOperation
extends AbstractWorkingCopyOperation {
    protected boolean isRecursive;

    public AddToSVNOperation(IResource[] resources) {
        this(resources, false);
    }

    public AddToSVNOperation(IResource[] resources, boolean isRecursive) {
        super("Operation_AddToSVN", SVNMessages.class, resources);
        this.isRecursive = isRecursive;
    }

    public AddToSVNOperation(IResourceProvider provider) {
        this(provider, false);
    }

    public AddToSVNOperation(IResourceProvider provider, boolean isRecursive) {
        super("Operation_AddToSVN", SVNMessages.class, provider);
        this.isRecursive = isRecursive;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        if (this.isRecursive) {
            boolean bl = this.isRecursive = !FileUtility.checkForResourcesPresenceRecursive(resources, IStateFilter.SF_IGNORED);
        }
        if (this.isRecursive) {
            resources = FileUtility.shrinkChildNodesWithSwitched(resources);
        } else {
            FileUtility.reorder(resources, true);
        }
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IResource current = resources[i];
            IRepositoryLocation location = storage.getRepositoryLocation(current);
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    AddToSVNOperation.this.doAdd(current, proxy, monitor);
                }
            }, monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    public static void removeFromParentIgnore(ISVNConnector proxy, String parentPath, String name) throws Exception {
        block4: {
            try {
                SVNProperty data = proxy.getProperty(new SVNEntryRevisionReference(parentPath), "svn:ignore", null, new SVNNullProgressMonitor());
                String ignoreValue = data == null ? "" : data.value;
                StringTokenizer tok = new StringTokenizer(ignoreValue, "\n", true);
                ignoreValue = "";
                boolean skipToken = false;
                while (tok.hasMoreTokens()) {
                    String oneOf = tok.nextToken();
                    if (!oneOf.equals(name) && !skipToken) {
                        ignoreValue = String.valueOf(ignoreValue) + oneOf;
                        continue;
                    }
                    boolean bl = skipToken = !skipToken;
                }
                proxy.setPropertyLocal(new String[]{parentPath}, new SVNProperty("svn:ignore", ignoreValue.length() > 0 ? ignoreValue : null), 0, 0L, null, new SVNNullProgressMonitor());
            }
            catch (SVNConnectorException ex) {
                if (ex.getErrorId() == 200005) break block4;
                throw ex;
            }
        }
    }

    protected void doAdd(IResource current, ISVNConnector proxy, IProgressMonitor monitor) throws Exception {
        String wcPath = FileUtility.getWorkingCopyPath(current);
        this.writeToConsole(0, "svn add \"" + FileUtility.normalizePath(wcPath) + "\"" + (this.isRecursive ? "" : " -N") + ISVNConnector.Options.asCommandLine(12L) + "\n");
        IContainer parent = current.getParent();
        if (parent != null) {
            AddToSVNOperation.removeFromParentIgnore(proxy, FileUtility.getWorkingCopyPath((IResource)parent), current.getName());
        }
        proxy.add(wcPath, SVNDepth.infinityOrEmpty(this.isRecursive), 12L, new SVNProgressMonitor(this, monitor, null));
    }
}

