/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class JavaHLMergeOperation
extends AbstractWorkingCopyOperation {
    protected IRepositoryResourceProvider from;
    protected IRepositoryResourceProvider fromEnd;
    protected SVNRevisionRange[] revisions;
    protected int depth;
    protected long options;
    protected ISVNProgressMonitor externalMonitor;

    public JavaHLMergeOperation(IResource[] localTo, IRepositoryResourceProvider from, SVNRevisionRange[] revisions, boolean dryRun, boolean ignoreAncestry, int depth) {
        this(localTo, from, revisions, depth, (dryRun ? 1024L : 0L) | (ignoreAncestry ? 512L : 0L));
    }

    public JavaHLMergeOperation(IResource[] localTo, IRepositoryResourceProvider fromStart, IRepositoryResourceProvider fromEnd, boolean dryRun, boolean ignoreAncestry, int depth) {
        this(localTo, fromStart, fromEnd, depth, (dryRun ? 1024L : 0L) | (ignoreAncestry ? 512L : 0L));
    }

    public JavaHLMergeOperation(IResource[] localTo, IRepositoryResourceProvider from, boolean dryRun) {
        this(localTo, from, 1024L);
    }

    public JavaHLMergeOperation(IResource[] localTo, IRepositoryResourceProvider from, SVNRevisionRange[] revisions, int depth, long options) {
        super("Operation_JavaHLMerge", SVNMessages.class, localTo);
        this.from = from;
        this.revisions = revisions;
        this.options = options & 0x20000E04L;
        this.depth = depth;
    }

    public JavaHLMergeOperation(IResource[] localTo, IRepositoryResourceProvider fromStart, IRepositoryResourceProvider fromEnd, int depth, long options) {
        super("Operation_JavaHLMerge", SVNMessages.class, localTo);
        this.from = fromStart;
        this.fromEnd = fromEnd;
        this.options = options & 0x20000E04L;
        this.depth = depth;
    }

    public JavaHLMergeOperation(IResource[] localTo, IRepositoryResourceProvider from, long options) {
        super("Operation_JavaHLMerge", SVNMessages.class, localTo);
        this.from = from;
        this.options = options & 0x20000E04L;
    }

    public void setRecordOnly(boolean recordOnly) {
        this.options &= 0xFFFFFFFFFFFFF7FFL;
        this.options |= recordOnly ? 2048L : 0L;
    }

    public int getOperationWeight() {
        return 19;
    }

    public void setExternalMonitor(ISVNProgressMonitor externalMonitor) {
        this.externalMonitor = externalMonitor;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        IRepositoryResource[] fromStart = this.from.getRepositoryResources();
        IRepositoryResource[] fromEnd = this.fromEnd != null ? this.fromEnd.getRepositoryResources() : null;
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IResource resource = resources[i];
            final IRepositoryResource from1 = fromStart[i];
            final IRepositoryResource from2 = fromEnd == null ? null : fromEnd[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    if (from2 != null) {
                        JavaHLMergeOperation.this.doMerge2URL(resource, from1, from2, monitor);
                    } else if (JavaHLMergeOperation.this.revisions != null) {
                        JavaHLMergeOperation.this.doMerge1URL(resource, from1, monitor);
                    } else {
                        JavaHLMergeOperation.this.doMergeReintegrate(resource, from1, monitor);
                    }
                }
            }, monitor, resources.length);
            ++i;
        }
    }

    protected void doMerge1URL(IResource resource, IRepositoryResource from, IProgressMonitor monitor) throws Exception {
        IRepositoryLocation location = from.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            String wcPath = FileUtility.getWorkingCopyPath(resource);
            SVNEntryReference ref1 = SVNUtility.getEntryReference(from);
            String changes = "";
            String ranges = "";
            SVNRevisionRange[] sVNRevisionRangeArray = this.revisions;
            int n = this.revisions.length;
            int n2 = 0;
            while (n2 < n) {
                SVNRevisionRange range = sVNRevisionRangeArray[n2];
                if (range.from.equals(range.to)) {
                    changes = String.valueOf(changes) + (changes.length() > 0 ? "," + range.from.toString() : range.from.toString());
                } else {
                    ranges = String.valueOf(ranges) + " -r " + range.from.toString() + ":" + range.to.toString();
                }
                ++n2;
            }
            if (changes.length() > 0) {
                changes = " -c " + changes;
            }
            this.writeToConsole(0, "svn merge" + changes + ranges + " \"" + from.getUrl() + "@" + from.getPegRevision() + "\" \"" + FileUtility.normalizePath(wcPath) + "\"" + SVNUtility.getDepthArg(this.depth, 0L) + ISVNConnector.Options.asCommandLine(this.options) + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.merge(ref1, this.revisions, wcPath, this.depth, this.options, (ISVNProgressMonitor)new MergeProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    protected void doMerge2URL(IResource resource, IRepositoryResource from1, IRepositoryResource from2, IProgressMonitor monitor) throws Exception {
        IRepositoryLocation location = from1.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            String wcPath = FileUtility.getWorkingCopyPath(resource);
            SVNEntryRevisionReference ref1 = SVNUtility.getEntryRevisionReference(from1);
            SVNEntryRevisionReference ref2 = SVNUtility.getEntryRevisionReference(from2);
            this.writeToConsole(0, "svn merge \"" + from1.getUrl() + "@" + from1.getSelectedRevision() + "\" \"" + from2.getUrl() + "@" + from2.getSelectedRevision() + "\" \"" + FileUtility.normalizePath(wcPath) + "\"" + SVNUtility.getDepthArg(this.depth, 0L) + ISVNConnector.Options.asCommandLine(this.options) + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.mergeTwo(ref1, ref2, wcPath, this.depth, this.options, new MergeProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    protected void doMergeReintegrate(IResource resource, IRepositoryResource from1, IProgressMonitor monitor) throws Exception {
        IRepositoryLocation location = from1.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            String wcPath = FileUtility.getWorkingCopyPath(resource);
            SVNEntryReference ref1 = SVNUtility.getEntryReference(from1);
            this.writeToConsole(0, "svn merge --reintegrate \"" + from1.getUrl() + "@" + from1.getPegRevision() + "\" \"" + FileUtility.normalizePath(wcPath) + "\"" + ISVNConnector.Options.asCommandLine(this.options) + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.mergeReintegrate(ref1, wcPath, this.options, new MergeProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    protected class MergeProgressMonitor
    extends SVNProgressMonitor {
        public MergeProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root) {
            super(parent, monitor, root, (JavaHLMergeOperation.this.options & 0x400L) == 0L);
        }

        public void progress(int current, int total, ISVNProgressMonitor.ItemState state) {
            super.progress(current, total, state);
            if (JavaHLMergeOperation.this.externalMonitor != null) {
                JavaHLMergeOperation.this.externalMonitor.progress(current, total, state);
            }
        }
    }
}

