/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNConflictDetectionProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractConflictDetectionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class UpdateOperation
extends AbstractConflictDetectionOperation
implements IResourceProvider {
    protected SVNRevision selectedRevision;
    protected int depth;
    protected long options;
    protected String updateDepthPath;

    public UpdateOperation(IResource[] resources, boolean ignoreExternals) {
        this(resources, null, ignoreExternals);
    }

    public UpdateOperation(IResourceProvider provider, boolean ignoreExternals) {
        this(provider, null, ignoreExternals);
    }

    public UpdateOperation(IResourceProvider provider, SVNRevision selectedRevision, boolean ignoreExternals) {
        this(provider, selectedRevision, 3, ignoreExternals ? 1L : 0L, null);
    }

    public UpdateOperation(IResource[] resources, SVNRevision selectedRevision, boolean ignoreExternals) {
        this(resources, selectedRevision, 3, ignoreExternals ? 1L : 0L, null);
    }

    public UpdateOperation(IResourceProvider provider, SVNRevision selectedRevision, int depth, long options, String updateDepthPath) {
        super("Operation_Update", SVNMessages.class, provider);
        this.selectedRevision = selectedRevision == null ? SVNRevision.HEAD : selectedRevision;
        this.depth = depth;
        this.options = options & 0x4003L;
        this.updateDepthPath = updateDepthPath;
    }

    public UpdateOperation(IResource[] resources, SVNRevision selectedRevision, int depth, long options, String updateDepthPath) {
        super("Operation_Update", SVNMessages.class, resources);
        this.selectedRevision = selectedRevision == null ? SVNRevision.HEAD : selectedRevision;
        this.depth = depth;
        this.options = options & 0x4003L;
        this.updateDepthPath = updateDepthPath;
    }

    public void setDepthOptions(int depth, boolean isStickyDepth, String updateDepthPath) {
        this.depth = depth;
        this.options &= 0xFFFFFFFFFFFFBFFFL;
        this.options |= isStickyDepth ? 16384L : 0L;
        this.updateDepthPath = updateDepthPath;
    }

    public int getOperationWeight() {
        return 19;
    }

    public IResource[] getResources() {
        return this.getProcessed();
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        this.defineInitialResourceSet(resources);
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        Map<IProject, List<IResource>> wc2Resources = SVNUtility.splitWorkingCopies(resources);
        Iterator<Map.Entry<IProject, List<IResource>>> it = wc2Resources.entrySet().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Map.Entry<IProject, List<IResource>> entry = it.next();
            final IRepositoryLocation location = storage.getRepositoryLocation((IResource)entry.getKey());
            IResource[] wcResources = entry.getValue().toArray(new IResource[0]);
            if (this.depth == 3 || this.depth == -2) {
                wcResources = FileUtility.shrinkChildNodes(wcResources);
            } else {
                FileUtility.reorder(wcResources, true);
            }
            final String[] paths = FileUtility.asPathArray(wcResources);
            if ((this.options & 0x4000L) != 0L && this.updateDepthPath != null && paths.length == 1) {
                String newPath = String.valueOf(paths[0]) + "/" + this.updateDepthPath;
                paths[0] = newPath = FileUtility.normalizePath(newPath);
            }
            this.complexWriteToConsole(new Runnable(){

                public void run() {
                    UpdateOperation.this.writeToConsole(0, "svn update" + ISVNConnector.Options.asCommandLine(UpdateOperation.this.options));
                    int i = 0;
                    while (i < paths.length && !monitor.isCanceled()) {
                        UpdateOperation.this.writeToConsole(0, " \"" + paths[i] + "\"");
                        ++i;
                    }
                    UpdateOperation.this.writeToConsole(0, " -r " + UpdateOperation.this.selectedRevision + SVNUtility.getDepthArg(UpdateOperation.this.depth, UpdateOperation.this.options) + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                }
            });
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.update(paths, UpdateOperation.this.selectedRevision, UpdateOperation.this.depth, UpdateOperation.this.options, new ConflictDetectionProgressMonitor(UpdateOperation.this, monitor, null));
                }
            }, monitor, wc2Resources.size());
            location.releaseSVNProxy(proxy);
        }
    }

    protected class ConflictDetectionProgressMonitor
    extends SVNConflictDetectionProgressMonitor {
        public ConflictDetectionProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root) {
            super(parent, monitor, root);
        }

        protected void processConflict(ISVNProgressMonitor.ItemState state) {
            UpdateOperation.this.setUnresolvedConflict(true);
            IResource[] iResourceArray = UpdateOperation.this.getProcessed();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                Path conflictPath = new Path(state.path);
                IPath resourcePath = FileUtility.getResourcePath(res);
                if (resourcePath.isPrefixOf((IPath)conflictPath)) {
                    IResource conflictResource;
                    if (resourcePath.equals((Object)conflictPath)) {
                        UpdateOperation.this.removeProcessed(res);
                    }
                    if ((conflictResource = ResourcesPlugin.getWorkspace().getRoot().findMember(res.getFullPath().append(conflictPath.removeFirstSegments(resourcePath.segmentCount())))) == null) break;
                    UpdateOperation.this.addUnprocessed(conflictResource);
                    break;
                }
                ++n2;
            }
        }
    }
}

