/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.svnstorage;

import java.io.Serializable;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SVNRepositoryContainer
extends SVNRepositoryResource
implements IRepositoryContainer,
Serializable {
    private static final long serialVersionUID = -6380931196819185798L;
    protected transient IRepositoryResource[] children;

    protected SVNRepositoryContainer() {
    }

    public SVNRepositoryContainer(IRepositoryLocation location, String url, SVNRevision selectedRevision) {
        super(location, url, selectedRevision);
    }

    public boolean isChildrenCached() {
        return this.children != null;
    }

    public synchronized void refresh() {
        super.refresh();
        this.children = null;
    }

    public void setSelectedRevision(SVNRevision revision) {
        if (this.isChildrenCached() && revision != null && !this.getSelectedRevision().equals(revision)) {
            this.children = null;
        }
        super.setSelectedRevision(revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRepositoryResource[] getChildren() throws SVNConnectorException {
        IRepositoryResource[] retVal = this.children;
        if (retVal == null) {
            String thisUrl = this.getUrl();
            SVNEntry[] children = null;
            ISVNConnector proxy = this.getRepositoryLocation().acquireSVNProxy();
            try {
                children = SVNUtility.list(proxy, SVNUtility.getEntryRevisionReference(this), 2, -1, 0x200000L, new SVNNullProgressMonitor());
            }
            finally {
                this.getRepositoryLocation().releaseSVNProxy(proxy);
            }
            SVNRepositoryContainer sVNRepositoryContainer = this;
            synchronized (sVNRepositoryContainer) {
                retVal = new IRepositoryResource[children.length];
                int i = 0;
                while (i < children.length) {
                    if (children[i].revision == -1L) {
                        throw new SVNConnectorException("-1 for SVN Kit 1.2.0 if resource is not exists");
                    }
                    String childUrl = String.valueOf(thisUrl) + "/" + children[i].path;
                    SVNRepositoryResource resource = children[i].nodeKind == 2 ? (SVNRepositoryResource)((Object)this.asRepositoryContainer(childUrl, false)) : (SVNRepositoryResource)((Object)this.asRepositoryFile(childUrl, false));
                    resource.setRevision(children[i].revision);
                    resource.setInfo(new IRepositoryResource.Information(children[i].lock, children[i].size, children[i].author, children[i].date, children[i].hasProperties));
                    retVal[i] = resource;
                    ++i;
                }
                this.children = retVal;
            }
        }
        return retVal;
    }

    protected void getRevisionImpl(ISVNConnector proxy) throws SVNConnectorException {
        SVNEntryRevisionReference reference = SVNUtility.getEntryRevisionReference(this);
        SVNEntryInfo[] infos = SVNUtility.info(proxy, reference, 0, new SVNNullProgressMonitor());
        if (infos != null && infos.length > 0 && infos[0].lastChangedRevision != -1L) {
            this.lastRevision = SVNRevision.fromNumber(infos[0].lastChangedRevision);
            SVNProperty[] data = SVNUtility.properties(proxy, reference, 0L, new SVNNullProgressMonitor());
            this.setInfo(new IRepositoryResource.Information(infos[0].lock, 0L, infos[0].lastChangedAuthor, infos[0].lastChangedDate, data != null && data.length > 0));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IRepositoryContainer)) {
            return false;
        }
        return super.equals(obj);
    }
}

