/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.SpellcheckedTextProvider;
import org.eclipse.team.svn.ui.panel.IDialogManager;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.properties.bugtraq.BugtraqModel;
import org.eclipse.team.svn.ui.utility.UserInputHistory;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.svn.ui.verifier.CommentVerifier;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.IValidationManager;

public class CommentComposite
extends Composite {
    public static String TEMPORARY_COMMENT = null;
    protected static final String COMMENT_HISTORY_NAME = "comment";
    protected static String PREVIOUS_COMMENTS_HEADER;
    protected static String PREVIOUS_COMMENTS_HINT;
    protected static String TEMPLATE_HEADER;
    protected static String TEMPLATE_HINT;
    protected static String TSVN_LOGTEMPLATE_HEADER;
    protected static String TSVN_LOGTEMPLATE_HINT;
    protected StyledText text;
    protected Text bugIdText;
    protected String message;
    protected String bugID;
    protected UserInputHistory history;
    protected Set logTemplates;
    protected Set ignoredStrings;
    protected BugtraqModel bugtraqModel;
    protected int minLogSize;
    protected int maxLogWidth;
    protected IValidationManager validationManager;
    protected IDialogManager dialogManager;

    public CommentComposite(Composite parent, IValidationManager validationManager) {
        this(parent, validationManager, null);
    }

    public CommentComposite(Composite parent, IValidationManager validationManager, Set logTemplates) {
        this(parent, null, validationManager, logTemplates, null);
    }

    public CommentComposite(Composite parent, String message, IValidationManager validationManager, Set logTemplates, BugtraqModel bugtraqModel) {
        this(parent, null, validationManager, logTemplates, null, 0);
    }

    public CommentComposite(Composite parent, String message, IValidationManager validationManager, Set logTemplates, BugtraqModel bugtraqModel, int minLogSize) {
        this(parent, null, validationManager, logTemplates, null, minLogSize, 0);
    }

    public CommentComposite(Composite parent, String message, IValidationManager validationManager, Set logTemplates, BugtraqModel bugtraqModel, int minLogSize, int maxLogWidth) {
        super(parent, 0);
        PREVIOUS_COMMENTS_HEADER = SVNUIMessages.CommentComposite_Previous;
        PREVIOUS_COMMENTS_HINT = "    " + SVNUIMessages.CommentComposite_Previous_Hint;
        TEMPLATE_HEADER = SVNUIMessages.CommentComposite_Template;
        TEMPLATE_HINT = "    " + SVNUIMessages.CommentComposite_Template_Hint;
        TSVN_LOGTEMPLATE_HEADER = SVNUIMessages.CommentComposite_LogTemplate;
        TSVN_LOGTEMPLATE_HINT = "    " + SVNUIMessages.CommentComposite_LogTemplate_Hint;
        this.message = message;
        this.validationManager = validationManager;
        this.logTemplates = logTemplates;
        this.ignoredStrings = new HashSet();
        this.bugtraqModel = bugtraqModel;
        this.minLogSize = minLogSize;
        this.maxLogWidth = maxLogWidth;
        this.createControls();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.text.setText(message);
    }

    public String getBugID() {
        return this.bugID;
    }

    public void insertText(String text) {
        this.text.insert(text);
    }

    public void saveChanges() {
        this.message = this.text.getText();
        this.history.addLine(this.message);
        TEMPORARY_COMMENT = null;
        if (this.bugIdText != null) {
            this.bugID = this.bugIdText.getText();
        }
    }

    public void cancelChanges() {
        TEMPORARY_COMMENT = this.text.getText().trim().length() == 0 ? null : this.text.getText();
    }

    private void createControls() {
        Label label;
        GridData data = null;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        final Text[] tBugIdTextA = new Text[1];
        if (this.bugtraqModel != null && (this.bugtraqModel.getMessage() != null || this.bugtraqModel.getLogregex() != null)) {
            Composite bugtraqComposite = new Composite((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            bugtraqComposite.setLayout((Layout)layout);
            bugtraqComposite.setLayoutData((Object)new GridData(768));
            label = new Label(bugtraqComposite, 0);
            label.setLayoutData((Object)new GridData(1));
            label.setText(this.bugtraqModel.getLabel());
            if (this.bugtraqModel.getLogregex() == null) {
                this.bugIdText = new Text(bugtraqComposite, 2052);
                this.bugIdText.setLayoutData((Object)new GridData(768));
                this.bugIdText.setFocus();
                this.validationManager.attachTo((Control)this.bugIdText, new AbstractVerifier(){

                    protected String getErrorMessage(Control input) {
                        String bugId = this.getText(input);
                        if (bugId.length() > 0 && CommentComposite.this.bugtraqModel.isNumber() && !bugId.matches("[0-9]+(\\s*,\\s*?[0-9]+)*")) {
                            return SVNUIMessages.format((String)SVNUIMessages.CommentComposite_BugID_Verifier_Error_Number, (Object[])new String[]{CommentComposite.this.bugtraqModel.getLabel()});
                        }
                        return null;
                    }

                    protected String getWarningMessage(Control input) {
                        if (CommentComposite.this.bugtraqModel.isWarnIfNoIssue() && this.getText(input).length() == 0) {
                            return SVNUIMessages.CommentComposite_BugID_Verifier_Warning;
                        }
                        return null;
                    }
                });
            } else {
                Text tBugIdText = new Text(bugtraqComposite, 2060);
                tBugIdText.setLayoutData((Object)new GridData(768));
                tBugIdTextA[0] = tBugIdText;
            }
        }
        data = new GridData(1808);
        data.heightHint = 80;
        this.text = SpellcheckedTextProvider.getTextWidget(this, 834, data, this.maxLogWidth);
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (!SVNTeamPreferences.getCommentTemplatesBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "useShiftEnter") && (e.stateMask & 0x20000) != 0 && e.detail == 4) {
                    e.doit = false;
                } else if (e.character == '\t') {
                    e.doit = true;
                }
            }
        });
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new CommentVerifier(SVNUIMessages.CommentComposite_Comment_Verifier, this.minLogSize));
        if (this.bugtraqModel != null && this.bugtraqModel.getLogregex() != null) {
            this.text.setFocus();
            String[] logregex = this.bugtraqModel.getLogregex();
            final Pattern mainRegex = Pattern.compile(logregex[0]);
            final Pattern numberRegex = logregex.length > 1 ? Pattern.compile(logregex[1]) : (this.bugtraqModel.isNumber() ? Pattern.compile("[0-9]+(\\s*,\\s*?[0-9]+)*") : null);
            verifier.add(new AbstractVerifier(){

                protected String getErrorMessage(Control input) {
                    return null;
                }

                protected String getWarningMessage(Control input) {
                    if (CommentComposite.this.bugtraqModel.isWarnIfNoIssue()) {
                        String text = this.getText(input);
                        Matcher matcher = mainRegex.matcher(text);
                        if (matcher.find()) {
                            String bugIdEntry = matcher.group();
                            if (numberRegex != null) {
                                matcher = numberRegex.matcher(bugIdEntry);
                                String entryList = null;
                                while (matcher.find()) {
                                    String string = entryList = entryList == null ? matcher.group() : String.valueOf(entryList) + ", " + matcher.group();
                                }
                                if (entryList != null) {
                                    tBugIdTextA[0].setText(entryList);
                                    return null;
                                }
                                tBugIdTextA[0].setText("");
                                return SVNUIMessages.format((String)SVNUIMessages.CommentComposite_BugID_Verifier_Error_Text, (Object[])new String[]{CommentComposite.this.bugtraqModel.getLabel(), numberRegex.pattern()});
                            }
                            tBugIdTextA[0].setText(bugIdEntry);
                            return null;
                        }
                        tBugIdTextA[0].setText("");
                        return SVNUIMessages.CommentComposite_BugID_Verifier_Warning;
                    }
                    return null;
                }
            });
        }
        this.validationManager.attachTo((Control)this.text, verifier);
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNUIMessages.CommentComposite_ChooseComment);
        this.history = new UserInputHistory(COMMENT_HISTORY_NAME, SVNTeamPreferences.getCommentTemplatesInt(SVNTeamUIPlugin.instance().getPreferenceStore(), "savedCommentsCount"));
        final Combo previousCommentsCombo = new Combo((Composite)this, 8);
        data = new GridData(768);
        data.widthHint = 200;
        previousCommentsCombo.setLayoutData((Object)data);
        final List commentsList = this.getCommentsList();
        if (this.message != null && this.message.length() > 0) {
            this.text.setText(this.message);
        } else if (TEMPORARY_COMMENT != null) {
            this.text.setText(TEMPORARY_COMMENT);
        }
        this.text.selectAll();
        ArrayList<String> flattenCommentsList = new ArrayList<String>();
        Iterator iter = commentsList.iterator();
        while (iter.hasNext()) {
            flattenCommentsList.add(FileUtility.flattenText((String)((String)iter.next())));
        }
        previousCommentsCombo.setVisibleItemCount(flattenCommentsList.size());
        previousCommentsCombo.setItems(flattenCommentsList.toArray(new String[flattenCommentsList.size()]));
        previousCommentsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int idx = previousCommentsCombo.getSelectionIndex();
                if (idx != -1) {
                    String comboText = (String)commentsList.get(idx);
                    CommentComposite.this.text.setText(CommentComposite.this.ignoredStrings.contains(comboText) ? CommentComposite.this.text.getText() : comboText);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void postInit(IDialogManager dialogManager) {
        this.dialogManager = dialogManager;
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 9) {
                    CommentComposite.this.text.traverse(16);
                    event.doit = false;
                }
            }
        });
        if (this.minLogSize > 0) {
            this.validationManager.validateContent();
        }
    }

    protected List getCommentsList() {
        ArrayList<String> commentsList = new ArrayList<String>();
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        boolean logTemplatesEnabled = SVNTeamPreferences.getCommentTemplatesBoolean(store, "comment.logTemplates.enabled");
        boolean userTemplatesEnabled = SVNTeamPreferences.getCommentTemplatesBoolean(store, "comment.templates.enabled");
        if (logTemplatesEnabled && this.logTemplates != null || userTemplatesEnabled) {
            commentsList.add(PREVIOUS_COMMENTS_HEADER);
            this.ignoredStrings.add(PREVIOUS_COMMENTS_HEADER);
            if (this.history.getHistory().length > 0) {
                commentsList.addAll(Arrays.asList(this.history.getHistory()));
            } else {
                commentsList.add(PREVIOUS_COMMENTS_HINT);
                this.ignoredStrings.add(PREVIOUS_COMMENTS_HINT);
            }
        } else {
            commentsList.addAll(Arrays.asList(this.history.getHistory()));
        }
        if (userTemplatesEnabled) {
            commentsList.add(TEMPLATE_HEADER);
            this.ignoredStrings.add(TEMPLATE_HEADER);
            String[] templates = FileUtility.decodeStringToArray((String)SVNTeamPreferences.getCommentTemplatesString(store, "comment.templates"));
            if (templates.length == 0) {
                commentsList.add(TEMPLATE_HINT);
                this.ignoredStrings.add(TEMPLATE_HINT);
            } else {
                commentsList.addAll(new ArrayList<String>(Arrays.asList(templates)));
            }
        }
        if (this.logTemplates != null && logTemplatesEnabled) {
            commentsList.add(TSVN_LOGTEMPLATE_HEADER);
            this.ignoredStrings.add(TSVN_LOGTEMPLATE_HEADER);
            if (this.logTemplates.size() > 0) {
                String mainTemplate = (String)this.logTemplates.iterator().next();
                this.text.setText(mainTemplate);
                this.text.selectAll();
                commentsList.addAll(this.logTemplates);
            } else {
                commentsList.add(TSVN_LOGTEMPLATE_HINT);
                this.ignoredStrings.add(TSVN_LOGTEMPLATE_HINT);
            }
        }
        return commentsList;
    }
}

