/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNDiffStatus;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.resource.IRepositoryResourceWithStatusProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromDifferenceRepositoryResourceProviderOperation
extends AbstractRepositoryOperation
implements IRepositoryResourceWithStatusProvider {
    protected IRepositoryResource[] repositoryResources;
    protected IRepositoryResource[] repositoryResourcesToDelete;
    protected IRepositoryResource newer;
    protected IRepositoryResource older;
    protected IRepositoryLocation location;
    protected HashMap<String, String> url2status = new HashMap();

    public FromDifferenceRepositoryResourceProviderOperation(IRepositoryResource first, IRepositoryResource second) {
        this((IRepositoryResourceProvider)new IRepositoryResourceProvider.DefaultRepositoryResourceProvider(new IRepositoryResource[]{first, second}));
    }

    public FromDifferenceRepositoryResourceProviderOperation(IRepositoryResourceProvider provider) {
        super("Operation_GetRepositoryResource", SVNUIMessages.class, provider);
    }

    public IRepositoryResourceProvider getDeletionsProvider() {
        return new IRepositoryResourceProvider(){

            public IRepositoryResource[] getRepositoryResources() {
                return FromDifferenceRepositoryResourceProviderOperation.this.repositoryResourcesToDelete;
            }
        };
    }

    protected IRepositoryResource createResourceFor(int kind, String url) {
        IRepositoryFile retVal = null;
        if (kind == 1) {
            retVal = this.location.asRepositoryFile(url, false);
        } else if (kind == 2) {
            retVal = this.location.asRepositoryContainer(url, false);
        }
        if (retVal == null) {
            throw new RuntimeException(SVNUIMessages.Error_CompareUnknownNodeKind);
        }
        return retVal;
    }

    protected IRepositoryResource getResourceForStatus(SVNDiffStatus status) {
        String url = SVNUtility.decodeURL((String)status.pathNext);
        return this.createResourceFor(SVNUtility.getNodeKind((String)status.pathPrev, (int)status.nodeKind, (boolean)false), url);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] operable = this.operableData();
        this.newer = operable[0];
        this.older = operable[1];
        this.location = this.newer.getRepositoryLocation();
        HashSet<IRepositoryResource> resourcesToReturn = new HashSet<IRepositoryResource>();
        HashSet<IRepositoryResource> resourcesToDelete = new HashSet<IRepositoryResource>();
        ArrayList statusesList = new ArrayList();
        ISVNConnector proxy = this.location.acquireSVNProxy();
        final LocateResourceURLInHistoryOperation op = new LocateResourceURLInHistoryOperation(new IRepositoryResource[]{this.newer, this.older});
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
            }
        }, monitor, 3);
        this.newer = op.getRepositoryResources()[0];
        this.older = op.getRepositoryResources()[1];
        SVNEntryRevisionReference refPrev = SVNUtility.getEntryRevisionReference((IRepositoryResource)this.older);
        SVNEntryRevisionReference refNext = SVNUtility.getEntryRevisionReference((IRepositoryResource)this.newer);
        ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)this, (String)SVNMessages.Progress_Running);
        try {
            if (SVNUtility.useSingleReferenceSignature((SVNEntryRevisionReference)refPrev, (SVNEntryRevisionReference)refNext)) {
                SVNUtility.diffStatus((ISVNConnector)proxy, statusesList, (SVNEntryReference)refPrev, (SVNRevisionRange)new SVNRevisionRange(refPrev.revision, refNext.revision), (int)3, (long)0L, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null, false));
            } else {
                SVNUtility.diffStatus((ISVNConnector)proxy, statusesList, (SVNEntryRevisionReference)refPrev, (SVNEntryRevisionReference)refNext, (int)3, (long)0L, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null, false));
            }
        }
        finally {
            this.location.releaseSVNProxy(proxy);
        }
        for (SVNDiffStatus status : statusesList) {
            IRepositoryResource resourceToAdd = this.getResourceForStatus(status);
            resourceToAdd.setSelectedRevision(this.newer.getSelectedRevision());
            resourceToAdd.setPegRevision(this.newer.getPegRevision());
            resourcesToReturn.add(resourceToAdd);
            String strStatus = SVNRemoteStorage.getCompoundStatusString((int)status.propStatus, (int)status.textStatus, (boolean)true);
            this.url2status.put(resourceToAdd.getUrl(), strStatus);
            if (status.textStatus != 4) continue;
            resourcesToDelete.add(resourceToAdd);
        }
        this.repositoryResources = resourcesToReturn.toArray(new IRepositoryResource[0]);
        this.repositoryResourcesToDelete = resourcesToDelete.toArray(new IRepositoryResource[0]);
    }

    public IRepositoryResource[] getRepositoryResources() {
        return this.repositoryResources;
    }

    public Map<String, String> getStatusesMap() {
        return this.url2status;
    }
}

