/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.dialogfields;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.IDialogFieldListener;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableTitleAreaDialog;

public abstract class AbstractValidationTitleAreaDialog
extends ResizableTitleAreaDialog {
    private final String m_shellText;
    private final String m_titleText;
    private final Image m_titleImage;
    private final String m_titleMessage;
    private boolean m_validationEnabled;
    protected final IDialogFieldListener m_validateListener = new IDialogFieldListener(){

        public void dialogFieldChanged(DialogField field) {
            AbstractValidationTitleAreaDialog.this.validateAll();
        }
    };

    public AbstractValidationTitleAreaDialog(Shell parentShell, AbstractUIPlugin plugin, String shellText, String titleText, Image titleImage, String titleMessage) {
        super(parentShell, plugin);
        this.m_shellText = shellText;
        this.m_titleText = titleText;
        this.m_titleImage = titleImage;
        this.m_titleMessage = titleMessage;
    }

    protected final Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText(this.m_shellText);
        this.setTitle(this.m_titleText);
        if (this.m_titleImage != null) {
            this.setTitleImage(this.m_titleImage);
        }
        this.setMessage(this.m_titleMessage);
        this.m_validationEnabled = true;
        this.validateAll();
        return control;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridDataFactory.create((Control)container).grab().fill();
        this.createControls(container);
        return area;
    }

    protected abstract void createControls(Composite var1);

    public final void validateAll() {
        if (this.m_validationEnabled) {
            String errorMessage;
            try {
                errorMessage = this.validate();
            }
            catch (Throwable e) {
                errorMessage = e.getMessage();
            }
            this.setErrorMessage(errorMessage);
            this.setValid(errorMessage == null);
        }
    }

    protected void setValid(boolean enabled) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    protected String validate() throws Exception {
        return null;
    }
}

