/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;

public class NLSHint {
    private String fAccessorName;
    private IPackageFragment fAccessorPackage;
    private String fResourceBundleName;
    private IPackageFragment fResourceBundlePackage;
    private NLSSubstitution[] fSubstitutions;

    public NLSHint(IJavaScriptUnit cu, JavaScriptUnit astRoot) {
        Assert.isNotNull((Object)cu);
        Assert.isNotNull((Object)astRoot);
        IPackageFragment cuPackage = (IPackageFragment)cu.getAncestor(4);
        this.fAccessorName = "Messages";
        this.fAccessorPackage = cuPackage;
        this.fResourceBundleName = "messages.properties";
        this.fResourceBundlePackage = cuPackage;
        IJavaScriptProject project = cu.getJavaScriptProject();
        NLSLine[] lines = NLSHint.createRawLines(cu);
        AccessorClassReference accessClassRef = NLSHint.findFirstAccessorReference(lines, astRoot);
        if (accessClassRef == null) {
            ArrayList eclipseNLSLines = new ArrayList();
            accessClassRef = this.createEclipseNLSLines(this.getDocument(cu), astRoot, eclipseNLSLines);
            if (!eclipseNLSLines.isEmpty()) {
                NLSLine[] rawLines = lines;
                int rawLinesLength = rawLines.length;
                int eclipseLinesLength = eclipseNLSLines.size();
                lines = new NLSLine[rawLinesLength + eclipseLinesLength];
                int i = 0;
                while (i < rawLinesLength) {
                    lines[i] = rawLines[i];
                    ++i;
                }
                i = 0;
                while (i < eclipseLinesLength) {
                    lines[i + rawLinesLength] = (NLSLine)eclipseNLSLines.get(i);
                    ++i;
                }
            }
        }
        Properties props = null;
        if (accessClassRef != null) {
            props = NLSHintHelper.getProperties(project, accessClassRef);
        }
        if (props == null) {
            props = new Properties();
        }
        this.fSubstitutions = this.createSubstitutions(lines, props, astRoot);
        if (accessClassRef != null) {
            this.fAccessorName = accessClassRef.getName();
            ITypeBinding accessorClassBinding = accessClassRef.getBinding();
            try {
                String fullBundleName;
                IPackageFragment accessorPack = NLSHintHelper.getPackageOfAccessorClass(project, accessorClassBinding);
                if (accessorPack != null) {
                    this.fAccessorPackage = accessorPack;
                }
                if ((fullBundleName = accessClassRef.getResourceBundleName()) != null) {
                    this.fResourceBundleName = String.valueOf(Signature.getSimpleName((String)fullBundleName)) + ".properties";
                    String packName = Signature.getQualifier((String)fullBundleName);
                    IPackageFragment pack = NLSHintHelper.getResourceBundlePackage(project, packName, this.fResourceBundleName);
                    if (pack != null) {
                        this.fResourceBundlePackage = pack;
                    }
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
    }

    private AccessorClassReference createEclipseNLSLines(final IDocument document, JavaScriptUnit astRoot, List nlsLines) {
        final AccessorClassReference[] firstAccessor = new AccessorClassReference[1];
        final TreeMap lineToNLSLine = new TreeMap();
        astRoot.accept(new ASTVisitor(){
            private IJavaScriptUnit fCache_CU;
            private JavaScriptUnit fCache_AST;

            public boolean visit(QualifiedName node) {
                ITypeBinding superType;
                ITypeBinding type = node.getQualifier().resolveTypeBinding();
                if (type != null && (superType = type.getSuperclass()) != null && NLS.class.getName().equals(superType.getQualifiedName())) {
                    String bundleName;
                    Integer line;
                    try {
                        line = new Integer(document.getLineOfOffset(node.getStartPosition()));
                    }
                    catch (BadLocationException badLocationException) {
                        return true;
                    }
                    NLSLine nlsLine = (NLSLine)lineToNLSLine.get(line);
                    if (nlsLine == null) {
                        nlsLine = new NLSLine(line);
                        lineToNLSLine.put(line, nlsLine);
                    }
                    SimpleName name = node.getName();
                    NLSElement element = new NLSElement(node.getName().getIdentifier(), name.getStartPosition(), name.getLength(), nlsLine.size() - 1, true);
                    nlsLine.add(element);
                    try {
                        IJavaScriptUnit bundleCU = (IJavaScriptUnit)type.getJavaElement().getAncestor(5);
                        if (this.fCache_CU == null || !this.fCache_CU.equals(bundleCU) || this.fCache_AST == null) {
                            this.fCache_CU = bundleCU;
                            this.fCache_AST = this.fCache_CU != null ? JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)this.fCache_CU, ASTProvider.WAIT_YES, null) : null;
                        }
                        bundleName = NLSHintHelper.getResourceBundleName(this.fCache_AST);
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        return true;
                    }
                    element.setAccessorClassReference(new AccessorClassReference(type, bundleName, new Region(node.getStartPosition(), node.getLength())));
                    if (firstAccessor[0] == null) {
                        firstAccessor[0] = element.getAccessorClassReference();
                    }
                }
                return true;
            }
        });
        nlsLines.addAll(lineToNLSLine.values());
        return firstAccessor[0];
    }

    private IDocument getDocument(IJavaScriptUnit cu) {
        ITextFileBufferManager manager;
        IPath path;
        block10: {
            IDocument iDocument;
            path = cu.getPath();
            manager = FileBuffers.getTextFileBufferManager();
            try {
                manager.connect(path, LocationKind.NORMALIZE, null);
            }
            catch (CoreException coreException) {
                return null;
            }
            try {
                ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
                if (buffer == null) break block10;
                iDocument = buffer.getDocument();
            }
            catch (Throwable throwable) {
                try {
                    manager.disconnect(path, LocationKind.NORMALIZE, null);
                }
                catch (CoreException coreException) {
                    return null;
                }
                throw throwable;
            }
            try {
                manager.disconnect(path, LocationKind.NORMALIZE, null);
            }
            catch (CoreException coreException) {
                return null;
            }
            return iDocument;
        }
        try {
            manager.disconnect(path, LocationKind.NORMALIZE, null);
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    private NLSSubstitution[] createSubstitutions(NLSLine[] lines, Properties props, JavaScriptUnit astRoot) {
        ArrayList<NLSSubstitution> result = new ArrayList<NLSSubstitution>();
        int i = 0;
        while (i < lines.length) {
            NLSElement[] elements = lines[i].getElements();
            int j = 0;
            while (j < elements.length) {
                NLSElement nlsElement = elements[j];
                if (nlsElement.hasTag()) {
                    AccessorClassReference accessorClassReference = NLSHintHelper.getAccessorClassReference(astRoot, nlsElement);
                    if (accessorClassReference == null) {
                        result.add(new NLSSubstitution(1, NLSHint.stripQuotes(nlsElement.getValue()), nlsElement));
                    } else {
                        String key = NLSHint.stripQuotes(nlsElement.getValue());
                        String value = props.getProperty(key);
                        result.add(new NLSSubstitution(0, key, value, nlsElement, accessorClassReference));
                    }
                } else if (nlsElement.isEclipseNLS()) {
                    String key = nlsElement.getValue();
                    result.add(new NLSSubstitution(0, key, props.getProperty(key), nlsElement, nlsElement.getAccessorClassReference()));
                } else {
                    result.add(new NLSSubstitution(2, NLSHint.stripQuotes(nlsElement.getValue()), nlsElement));
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new NLSSubstitution[result.size()]);
    }

    private static AccessorClassReference findFirstAccessorReference(NLSLine[] lines, JavaScriptUnit astRoot) {
        AccessorClassReference accessorClassReference;
        NLSElement nlsElement;
        int j;
        NLSElement[] elements;
        int i = 0;
        while (i < lines.length) {
            elements = lines[i].getElements();
            j = 0;
            while (j < elements.length) {
                nlsElement = elements[j];
                if (nlsElement.hasTag() && (accessorClassReference = NLSHintHelper.getAccessorClassReference(astRoot, nlsElement)) != null) {
                    return accessorClassReference;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < lines.length) {
            elements = lines[i].getElements();
            j = 0;
            while (j < elements.length) {
                nlsElement = elements[j];
                if (!nlsElement.hasTag() && (accessorClassReference = NLSHintHelper.getAccessorClassReference(astRoot, nlsElement)) != null) {
                    return accessorClassReference;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private static String stripQuotes(String str) {
        return str.substring(1, str.length() - 1);
    }

    private static NLSLine[] createRawLines(IJavaScriptUnit cu) {
        try {
            return NLSScanner.scan(cu);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return new NLSLine[0];
        }
        catch (InvalidInputException invalidInputException) {
            return new NLSLine[0];
        }
    }

    public String getAccessorClassName() {
        return this.fAccessorName;
    }

    public IPackageFragment getAccessorClassPackage() {
        return this.fAccessorPackage;
    }

    public String getResourceBundleName() {
        return this.fResourceBundleName;
    }

    public IPackageFragment getResourceBundlePackage() {
        return this.fResourceBundlePackage;
    }

    public NLSSubstitution[] getSubstitutions() {
        return this.fSubstitutions;
    }
}

