/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext.ui;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtVariableCompletions {
    @Inject
    private IJavaProjectProvider javaProjectProvider;

    public void getVariableProposals(EObject ctx, EReference refToTypeRef, VariableType varType, Set<String> notAllowedNames, CompletionDataAcceptor acceptor) {
        String typeName = this.getTextUnderReference(ctx, refToTypeRef);
        this.internalGetVariableProposals(typeName, ctx, varType, notAllowedNames, acceptor);
    }

    public void getVariableProposals(String typeName, EObject ctx, VariableType varType, Set<String> notAllowedNames, CompletionDataAcceptor acceptor) {
        this.internalGetVariableProposals(typeName, ctx, varType, notAllowedNames, acceptor);
    }

    protected void internalGetVariableProposals(String typeName, EObject ctx, VariableType varType, Set<String> notAllowedNames, CompletionDataAcceptor acceptor) {
        boolean isMany = false;
        String baseType = null;
        if (this.isCollectionType(typeName)) {
            baseType = this.getFirstTypeArgumentSimpleName(typeName);
            isMany = true;
        } else if (this.isArray(typeName)) {
            baseType = this.getArrayComponentTypeSimpleName(typeName);
            isMany = true;
        } else {
            baseType = this.getRawTypeSimpleName(typeName);
        }
        String[] stringArray = this.getVariableProposals(baseType, isMany, ctx, varType, notAllowedNames);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            acceptor.accept(string, new StyledString(String.valueOf(string) + " : " + typeName), this.getImage(ctx));
            ++n2;
        }
    }

    protected boolean isCollectionType(String typeName) {
        return this.getCollectionTypes().contains(this.getRawTypeSimpleName(typeName)) && this.getFirstTypeArgumentSimpleName(typeName) != null;
    }

    protected boolean isArray(String typeName) {
        return this.getArrayComponentTypeSimpleName(typeName) != null;
    }

    protected String getArrayComponentTypeSimpleName(String typeName) {
        int idx = typeName.indexOf(91);
        if (idx != -1) {
            return this.getSimpleName(typeName.substring(0, idx));
        }
        return null;
    }

    protected Image getImage(EObject context) {
        return JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE);
    }

    protected String getRawTypeSimpleName(String typeName) {
        int idxOfFirstBracket = typeName.indexOf(60);
        if (idxOfFirstBracket != -1) {
            String mainType = typeName.substring(0, idxOfFirstBracket);
            return this.getSimpleName(mainType);
        }
        return this.getSimpleName(typeName);
    }

    protected String getFirstTypeArgumentSimpleName(String typeName) {
        int idxOfFirstBracket = typeName.indexOf(this.leftTypeArgParen());
        if (idxOfFirstBracket != -1) {
            int idx2;
            int afterFirstBracket = idxOfFirstBracket + 1;
            int index = typeName.indexOf(this.rightTypeArgParen(), afterFirstBracket);
            if (index == -1) {
                return null;
            }
            int idx1 = typeName.indexOf(this.typeArgSeparator(), afterFirstBracket);
            if (idx1 != -1 && idx1 < index) {
                index = idx1;
            }
            if ((idx2 = typeName.indexOf(this.leftTypeArgParen(), afterFirstBracket)) != -1 && idx2 < index) {
                index = idx2;
            }
            String substring = typeName.substring(afterFirstBracket, index);
            String firstInnerType = this.getSimpleName(substring);
            return firstInnerType;
        }
        return null;
    }

    protected String typeArgSeparator() {
        return ",";
    }

    protected String rightTypeArgParen() {
        return ">";
    }

    protected String leftTypeArgParen() {
        return "<";
    }

    protected Set<String> getCollectionTypes() {
        return Sets.newHashSet((Object[])new String[]{"Collection", "List", "Iterable", "Set", "Iterator", "HashSet", "LinkedHashSet", "ArrayList", "LinkedList"});
    }

    protected String getSimpleName(String mainType) {
        if (mainType.indexOf(46) != -1) {
            return mainType.substring(mainType.lastIndexOf(46) + 1);
        }
        return mainType;
    }

    protected String getTextUnderReference(EObject ctx, EReference refToTypeRef) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)ctx, (EStructuralFeature)refToTypeRef);
        StringBuilder sb = new StringBuilder();
        for (INode n : nodes) {
            sb.append(NodeModelUtils.getTokenText((INode)n));
        }
        return sb.toString();
    }

    public String[] getVariableProposals(String simpleTypeName, boolean isPlural, EObject ctx, VariableType varType, Set<String> excludedNames) {
        if (!Strings.isEmpty((String)simpleTypeName)) {
            IJavaProject javaProject = null;
            if (ctx != null && ctx.eResource() != null && ctx.eResource().getResourceSet() != null) {
                javaProject = this.javaProjectProvider.getJavaProject(ctx.eResource().getResourceSet());
            }
            return NamingConventions.suggestVariableNames((int)this.getVariableKind(varType), (int)2, (String)simpleTypeName, (IJavaProject)javaProject, (int)(isPlural ? 1 : 0), (String[])excludedNames.toArray(new String[excludedNames.size()]), (boolean)false);
        }
        return new String[0];
    }

    protected int getVariableKind(VariableType varType) {
        switch (varType) {
            case INSTANCE_FIELD: {
                return 2;
            }
            case LOCAL_VAR: {
                return 5;
            }
            case PARAMETER: {
                return 4;
            }
            case STATIC_FIELD: {
                return 3;
            }
        }
        throw new IllegalStateException("unhandled enum const" + (Object)((Object)varType));
    }

    public static interface CompletionDataAcceptor {
        public void accept(String var1, StyledString var2, Image var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VariableType {
        INSTANCE_FIELD,
        PARAMETER,
        LOCAL_VAR,
        STATIC_FIELD;

    }
}

